/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl;

import fr.inrialpes.exmo.align.impl.Annotations;
import fr.inrialpes.exmo.align.impl.BasicCell;
import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.BasicRelation;
import fr.inrialpes.exmo.align.impl.Extensions;
import fr.inrialpes.exmo.align.impl.MEnumeration;
import fr.inrialpes.exmo.align.impl.MIterator;
import fr.inrialpes.exmo.align.impl.Namespace;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import fr.inrialpes.exmo.ontowrap.BasicOntology;
import fr.inrialpes.exmo.ontowrap.Ontology;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentProcess;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.align.Visitable;
import org.xml.sax.ContentHandler;

public class BasicAlignment
implements Alignment {
    protected Ontology<Object> onto1 = null;
    protected Ontology<Object> onto2 = null;
    protected int debug = 0;
    protected String level = "0";
    protected String type = "**";
    protected Hashtable<Object, Set<Cell>> hash1 = new Hashtable();
    protected Hashtable<Object, Set<Cell>> hash2 = new Hashtable();
    protected long time = 0L;
    protected Extensions extensions = new Extensions();
    protected BasicParameters namespaces = new BasicParameters();

    public void accept(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        alignmentVisitor.visit((Visitable)this);
    }

    public BasicAlignment() {
        if (this instanceof AlignmentProcess) {
            this.setExtension(Namespace.ALIGNMENT.uri, Annotations.METHOD, this.getClass().getName());
        }
        this.onto1 = new BasicOntology();
        this.onto2 = new BasicOntology();
    }

    public void init(Object object, Object object2, Object object3) throws AlignmentException {
        this.init(object, object2);
    }

    public void init(Object object, Object object2) throws AlignmentException {
        if (object instanceof Ontology) {
            this.onto1 = (Ontology)object;
            this.onto2 = (Ontology)object2;
        } else {
            this.onto1.setOntology(object);
            this.onto2.setOntology(object2);
        }
    }

    public static Properties getParameters() {
        return null;
    }

    public int nbCells() {
        int n = 0;
        Enumeration<Set<Cell>> enumeration = this.hash1.elements();
        while (enumeration.hasMoreElements()) {
            n += enumeration.nextElement().size();
        }
        return n;
    }

    public Object getOntology1() {
        return this.onto1.getOntology();
    }

    public Object getOntology2() {
        return this.onto2.getOntology();
    }

    public Ontology<Object> getOntologyObject1() {
        return this.onto1;
    }

    public Ontology<Object> getOntologyObject2() {
        return this.onto2;
    }

    public URI getOntology1URI() {
        return this.onto1.getURI();
    }

    public URI getOntology2URI() {
        return this.onto2.getURI();
    }

    public void setOntology1(Object object) throws AlignmentException {
        this.onto1.setOntology(object);
    }

    public void setOntology2(Object object) throws AlignmentException {
        this.onto2.setOntology(object);
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setLevel(String string) {
        this.level = string;
    }

    public String getLevel() {
        return this.level;
    }

    public URI getFile1() {
        return this.onto1.getFile();
    }

    public void setFile1(URI uRI) {
        this.onto1.setFile(uRI);
    }

    public URI getFile2() {
        return this.onto2.getFile();
    }

    public void setFile2(URI uRI) {
        this.onto2.setFile(uRI);
    }

    public Collection<String[]> getExtensions() {
        return this.extensions.getValues();
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public void setExtension(String string, String string2, String string3) {
        this.extensions.setExtension(string, string2, string3);
    }

    public String getExtension(String string, String string2) {
        return this.extensions.getExtension(string, string2);
    }

    public BasicParameters getXNamespaces() {
        return this.namespaces;
    }

    public void setXNamespace(String string, String string2) {
        this.namespaces.setParameter(string, string2);
    }

    public String getXNamespace(String string) {
        return this.namespaces.getParameter(string);
    }

    public Enumeration<Cell> getElements() {
        return new MEnumeration<Cell>(this.hash1);
    }

    public Iterator<Cell> iterator() {
        return new MIterator<Cell>(this.hash1);
    }

    public ArrayList<Cell> getArrayElements() {
        ArrayList<Cell> arrayList = new ArrayList<Cell>();
        Iterator<Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            arrayList.add(cell);
        }
        return arrayList;
    }

    public Cell addAlignCell(String string, Object object, Object object2, Relation relation, double d, Extensions extensions) throws AlignmentException {
        Cell cell = this.createCell(string, object, object2, relation, d);
        ((BasicCell)cell).setExtensions(extensions);
        this.addCell(cell);
        return cell;
    }

    public Cell addAlignCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        Cell cell = this.createCell(string, object, object2, relation, d);
        this.addCell(cell);
        return cell;
    }

    public Cell addAlignCell(Object object, Object object2, String string, double d) throws AlignmentException {
        return this.addAlignCell(null, object, object2, BasicRelation.createRelation(string), d);
    }

    public Cell addAlignCell(Object object, Object object2) throws AlignmentException {
        return this.addAlignCell(null, object, object2, BasicRelation.createRelation("="), 1.0);
    }

    public Cell createCell(String string, Object object, Object object2, Relation relation, double d) throws AlignmentException {
        return new BasicCell(string, object, object2, relation, d);
    }

    protected void addCell(Cell cell) throws AlignmentException {
        Set<Cell> set;
        boolean bl = false;
        Set<Cell> set2 = this.hash1.get(cell.getObject1());
        if (set2 != null) {
            set = set2.iterator();
            while (!bl && set.hasNext()) {
                if (!cell.equals((Cell)((BasicCell)set.next()))) continue;
                bl = true;
            }
            if (!bl) {
                set2.add(cell);
            }
        } else {
            set2 = new HashSet<Cell>();
            set2.add(cell);
            this.hash1.put(cell.getObject1(), set2);
        }
        bl = false;
        set = this.hash2.get(cell.getObject2());
        if (set != null) {
            Iterator iterator = set.iterator();
            while (!bl && iterator.hasNext()) {
                if (!cell.equals((Cell)((BasicCell)iterator.next()))) continue;
                bl = true;
            }
            if (!bl) {
                set.add(cell);
            }
        } else {
            set = new HashSet<Cell>();
            set.add(cell);
            this.hash2.put(cell.getObject2(), set);
        }
    }

    public void remCell(Cell cell) throws AlignmentException {
        Set<Cell> set;
        boolean bl = false;
        Set<Cell> set2 = this.hash1.get(cell.getObject1());
        if (set2 != null) {
            set2.remove(cell);
        }
        if ((set = this.hash2.get(cell.getObject2())) != null) {
            set.remove(cell);
        }
    }

    public Set<Cell> getAlignCells1(Object object) throws AlignmentException {
        return this.hash1.get(object);
    }

    public Set<Cell> getAlignCells2(Object object) throws AlignmentException {
        return this.hash2.get(object);
    }

    public Cell getAlignCell1(Object object) throws AlignmentException {
        if (Annotations.STRICT_IMPLEMENTATION) {
            throw new AlignmentException("getAlignCell1: deprecated (use getAlignCells1 instead)");
        }
        Set<Cell> set = this.hash1.get(object);
        Cell cell = null;
        double d = 0.0;
        if (set != null) {
            for (Cell cell2 : set) {
                double d2 = cell2.getStrength();
                if (!(d2 > d)) continue;
                d = d2;
                cell = cell2;
            }
        }
        return cell;
    }

    public Cell getAlignCell2(Object object) throws AlignmentException {
        if (Annotations.STRICT_IMPLEMENTATION) {
            throw new AlignmentException("getAlignCell2: deprecated (use getAlignCells2 instead)");
        }
        Set<Cell> set = this.hash2.get(object);
        Cell cell = null;
        double d = 0.0;
        if (set != null) {
            for (Cell cell2 : set) {
                double d2 = cell2.getStrength();
                if (!(d2 > d)) continue;
                d = d2;
                cell = cell2;
            }
        }
        return cell;
    }

    public Object getAlignedObject1(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell1(object);
        if (cell != null) {
            return cell.getObject2();
        }
        return null;
    }

    public Object getAlignedObject2(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell2(object);
        if (cell != null) {
            return cell.getObject1();
        }
        return null;
    }

    public Relation getAlignedRelation1(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell1(object);
        if (cell != null) {
            return cell.getRelation();
        }
        return null;
    }

    public Relation getAlignedRelation2(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell2(object);
        if (cell != null) {
            return cell.getRelation();
        }
        return null;
    }

    public double getAlignedStrength1(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell1(object);
        if (cell != null) {
            return cell.getStrength();
        }
        return 0.0;
    }

    public double getAlignedStrength2(Object object) throws AlignmentException {
        Cell cell = this.getAlignCell2(object);
        if (cell != null) {
            return cell.getStrength();
        }
        return 0.0;
    }

    public void removeAlignCell(Cell cell) throws AlignmentException {
        Set<Cell> set = this.hash1.get(cell.getObject1());
        Set<Cell> set2 = this.hash2.get(cell.getObject2());
        set.remove(cell);
        set2.remove(cell);
        if (set.isEmpty()) {
            this.hash1.remove(cell.getObject1());
        }
        if (set2.isEmpty()) {
            this.hash2.remove(cell.getObject2());
        }
    }

    public void cut2(double d) throws AlignmentException {
        Iterator<Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            if (!(cell.getStrength() < d)) continue;
            this.removeAlignCell(cell);
        }
    }

    public void cut(double d) throws AlignmentException {
        this.cut("hard", d);
    }

    public void cut(String string, double d) throws AlignmentException {
        double d2;
        if (d > 1.0 || d < 0.0) {
            throw new AlignmentException("Not a percentage or threshold : " + d);
        }
        ArrayList<Cell> arrayList = this.getArrayElements();
        Collections.sort(arrayList);
        int n = arrayList.size();
        int n2 = 0;
        if (string.equals("perc")) {
            n2 = new Double((double)n * d).intValue();
        } else if (string.equals("best")) {
            n2 = Math.min(n, new Double(d * 100.0).intValue());
        } else if (string.equals("hardgap") || string.equals("propgap")) {
            double d3 = ((Cell)arrayList.get(0)).getStrength();
            d2 = string.equals("propgap") ? d3 * d : d;
            for (n2 = 1; n2 < n && !(d3 - ((Cell)arrayList.get(n2)).getStrength() > d2); ++n2) {
                d3 = ((Cell)arrayList.get(n2)).getStrength();
                if (!string.equals("propgap")) continue;
                d2 = d3 * d;
            }
        } else {
            if (string.equals("hard")) {
                d2 = d;
            } else if (string.equals("span")) {
                d2 = ((Cell)arrayList.get(0)).getStrength() - d;
            } else if (string.equals("prop")) {
                d2 = ((Cell)arrayList.get(0)).getStrength() * d;
            } else {
                throw new AlignmentException("Not a cut specification : " + string);
            }
            for (n2 = 0; n2 < n && !(((Cell)arrayList.get(n2)).getStrength() < d2); ++n2) {
            }
        }
        n = n2;
        this.hash1.clear();
        this.hash2.clear();
        for (n2 = 0; n2 < n; ++n2) {
            this.addCell((Cell)arrayList.get(n2));
        }
    }

    public URIAlignment toURIAlignment() throws AlignmentException {
        throw new AlignmentException("[BasicAlignment].toURIAlignment() cannot process");
    }

    public void harden(double d) throws AlignmentException {
        Iterator<Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            if (cell.getStrength() < d) {
                this.removeAlignCell(cell);
                continue;
            }
            cell.setStrength(1.0);
        }
    }

    public BasicAlignment createNewAlignment(Object object, Object object2) throws AlignmentException {
        BasicAlignment basicAlignment = new BasicAlignment();
        basicAlignment.init(object, object2);
        return basicAlignment;
    }

    public Alignment diff(Alignment alignment) throws AlignmentException {
        if (this.onto1.getURI() != alignment.getOntology1URI()) {
            throw new AlignmentException("Can only diff alignments with same ontologies");
        }
        if (this.onto2.getURI() != alignment.getOntology2URI()) {
            throw new AlignmentException("Can only diff alignments with same ontologies");
        }
        BasicAlignment basicAlignment = this.createNewAlignment(this.onto1, this.onto2);
        Iterator<Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            Set set = alignment.getAlignCells1(cell.getObject1());
            boolean bl = false;
            if (set != null) {
                for (Cell cell2 : set) {
                    if (!cell.equals(cell2)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            basicAlignment.addCell(cell);
        }
        return basicAlignment;
    }

    public Alignment meet(Alignment alignment) throws AlignmentException {
        if (this.onto1.getURI() != alignment.getOntology1URI()) {
            throw new AlignmentException("Can only meet alignments with same ontologies");
        }
        if (this.onto2.getURI() != alignment.getOntology2URI()) {
            throw new AlignmentException("Can only meet alignments with same ontologies");
        }
        BasicAlignment basicAlignment = this.createNewAlignment(this.onto1, this.onto2);
        Iterator<Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            Set set = alignment.getAlignCells1(cell.getObject1());
            boolean bl = false;
            if (set != null) {
                for (Cell cell2 : set) {
                    if (!cell.equals(cell2)) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            basicAlignment.addCell(cell);
        }
        return basicAlignment;
    }

    public Alignment join(Alignment alignment) throws AlignmentException {
        if (this.onto1.getURI() != alignment.getOntology1URI()) {
            throw new AlignmentException("Can only join alignments with same ontologies");
        }
        if (this.onto2.getURI() != alignment.getOntology2URI()) {
            throw new AlignmentException("Can only join alignments with same ontologies");
        }
        BasicAlignment basicAlignment = this.createNewAlignment(this.onto1, this.onto2);
        basicAlignment.ingest(alignment);
        Iterator<Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            Set set = alignment.getAlignCells1(cell.getObject1());
            boolean bl = false;
            if (set != null) {
                for (Cell cell2 : set) {
                    if (!cell.equals(cell2)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            basicAlignment.addCell(cell);
        }
        return basicAlignment;
    }

    public Alignment compose(Alignment alignment) throws AlignmentException {
        if (this.onto2.getURI() != alignment.getOntology1URI()) {
            throw new AlignmentException("Can only compose alignments with a common ontologies");
        }
        BasicAlignment basicAlignment = this.createNewAlignment(this.onto1, ((BasicAlignment)alignment).getOntologyObject2());
        Iterator<Cell> iterator = this.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            Set set = alignment.getAlignCells1(cell.getObject2());
            if (set == null) continue;
            for (Cell cell2 : set) {
                Cell cell3 = cell.compose(cell2);
                if (cell3 == null) continue;
                basicAlignment.addCell(cell3);
            }
        }
        return basicAlignment;
    }

    public Alignment inverse() throws AlignmentException {
        String string;
        BasicAlignment basicAlignment = this.createNewAlignment(this.onto2, this.onto1);
        basicAlignment.setFile1(this.getFile2());
        basicAlignment.setFile2(this.getFile1());
        basicAlignment.setType(this.getType());
        basicAlignment.setLevel(this.getLevel());
        Extensions extensions = (Extensions)this.extensions.clone();
        String string2 = this.extensions.getExtension(Namespace.ALIGNMENT.uri, Annotations.ID);
        if (string2 != null && !string2.equals("")) {
            extensions.setExtension(Namespace.ALIGNMENT.uri, Annotations.DERIVEDFROM, string2);
            extensions.unsetExtension(Namespace.ALIGNMENT.uri, Annotations.ID);
        }
        if ((string = basicAlignment.getExtension(Namespace.ALIGNMENT.uri, Annotations.PRETTY)) != null) {
            extensions.setExtension(Namespace.ALIGNMENT.uri, Annotations.PRETTY, string + "/inverted");
        }
        extensions.setExtension(Namespace.ALIGNMENT.uri, Annotations.PROVENANCE, this.extensions.getExtension(Namespace.ALIGNMENT.uri, Annotations.PROVENANCE) + "");
        extensions.setExtension(Namespace.ALIGNMENT.uri, Annotations.METHOD, "http://exmo.inrialpes.fr/align/impl/BasicAlignment#inverse");
        basicAlignment.setExtensions(extensions);
        Enumeration<String> enumeration = this.namespaces.getNames();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            basicAlignment.setXNamespace(string3, this.getXNamespace(string3));
        }
        enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            basicAlignment.addCell(((Cell)enumeration.nextElement()).inverse());
        }
        return basicAlignment;
    }

    public void dump(ContentHandler contentHandler) {
    }

    public void ingest(Alignment alignment) throws AlignmentException {
        if (alignment != null) {
            for (Cell cell : alignment) {
                this.addCell(cell);
            }
        }
    }

    public Object clone() {
        BasicAlignment basicAlignment;
        try {
            basicAlignment = this.createNewAlignment(this.onto1, this.onto2);
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
            return null;
        }
        basicAlignment.setType(this.getType());
        basicAlignment.setLevel(this.getLevel());
        basicAlignment.setFile1(this.getFile1());
        basicAlignment.setFile2(this.getFile2());
        Extensions extensions = (Extensions)this.extensions.clone();
        String string = basicAlignment.getExtension(Namespace.ALIGNMENT.uri, Annotations.ID);
        if (string != null && !string.equals("")) {
            extensions.setExtension(Namespace.ALIGNMENT.uri, Annotations.DERIVEDFROM, string);
            extensions.unsetExtension(Namespace.ALIGNMENT.getUriPrefix(), Annotations.ID);
        }
        extensions.setExtension(Namespace.ALIGNMENT.uri, Annotations.METHOD, this.getClass().getName() + "#clone");
        basicAlignment.setExtensions(extensions);
        Enumeration<String> enumeration = this.namespaces.getNames();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            basicAlignment.setXNamespace(string2, this.getXNamespace(string2));
        }
        try {
            basicAlignment.ingest(this);
        }
        catch (AlignmentException alignmentException) {
            alignmentException.printStackTrace();
        }
        return basicAlignment;
    }

    public void render(AlignmentVisitor alignmentVisitor) throws AlignmentException {
        this.accept(alignmentVisitor);
    }

    public void cleanUp() {
    }
}

