/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;

public class OWLOntologies {
    private OWLOntologies() {
    }

    public static List topologicallySortOntologies(Set ontologies) throws OWLException {
        LinkedList result = new LinkedList();
        HashSet markSet = new HashSet(ontologies);
        int lastSize = -1;
        while (!markSet.isEmpty()) {
            OWLOntology oimodel = (OWLOntology)markSet.iterator().next();
            OWLOntologies.processPredecendents(oimodel, markSet, result);
            if (lastSize == result.size()) {
                throw new OWLException("OWL Ontology inclusion tree has a cycle, can't deal with that - FIX ME");
            }
            lastSize = result.size();
        }
        return result;
    }

    private static void processPredecendents(OWLOntology oimodel, Set markSet, List result) throws OWLException {
        markSet.remove(oimodel);
        Iterator iterator = oimodel.getIncludedOntologies().iterator();
        while (iterator.hasNext()) {
            OWLOntology includedOIModel = (OWLOntology)iterator.next();
            if (!markSet.contains(includedOIModel)) continue;
            OWLOntologies.processPredecendents(includedOIModel, markSet, result);
        }
        result.add(oimodel);
    }

    public static Set getAllIncludedOntologies(OWLOntology ontology) throws OWLException {
        Set set = ontology.getIncludedOntologies();
        HashSet result = new HashSet(set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            OWLOntology currentOIModel = (OWLOntology)iterator.next();
            result.addAll(OWLOntologies.getAllIncludedOntologies(currentOIModel));
        }
        return result;
    }
}

