/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.model.change;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.change.AddAnnotationInstance;
import org.semanticweb.owl.model.change.AddClassAxiom;
import org.semanticweb.owl.model.change.AddDataPropertyInstance;
import org.semanticweb.owl.model.change.AddDataPropertyRange;
import org.semanticweb.owl.model.change.AddDomain;
import org.semanticweb.owl.model.change.AddEnumeration;
import org.semanticweb.owl.model.change.AddEquivalentClass;
import org.semanticweb.owl.model.change.AddImport;
import org.semanticweb.owl.model.change.AddIndividualAxiom;
import org.semanticweb.owl.model.change.AddIndividualClass;
import org.semanticweb.owl.model.change.AddInverse;
import org.semanticweb.owl.model.change.AddObjectPropertyInstance;
import org.semanticweb.owl.model.change.AddObjectPropertyRange;
import org.semanticweb.owl.model.change.AddPropertyAxiom;
import org.semanticweb.owl.model.change.AddSuperClass;
import org.semanticweb.owl.model.change.AddSuperProperty;
import org.semanticweb.owl.model.change.ChangeVisitorAdapter;
import org.semanticweb.owl.model.change.SetDeprecated;
import org.semanticweb.owl.model.change.SetFunctional;
import org.semanticweb.owl.model.change.SetInverseFunctional;
import org.semanticweb.owl.model.change.SetOneToOne;
import org.semanticweb.owl.model.change.SetSymmetric;
import org.semanticweb.owl.model.change.SetTransitive;
import org.semanticweb.owl.model.helper.OWLEntityCollector;

public class OntologyChangeEntityCollector
extends ChangeVisitorAdapter {
    static Logger logger = Logger.getLogger((Class)OntologyChangeEntityCollector.class);
    Set entities;
    OWLEntityCollector collector = new OWLEntityCollector();

    public void reset() {
        this.entities = new HashSet();
    }

    public Set getEntities() {
        return new HashSet(this.entities);
    }

    public void visit(AddAnnotationInstance event) throws OWLException {
        this.collector.reset();
        event.getSubject().accept(this.collector);
        event.getProperty().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
    }

    public void visit(AddIndividualAxiom event) throws OWLException {
        this.collector.reset();
        event.getAxiom().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
    }

    public void visit(AddClassAxiom event) throws OWLException {
        this.collector.reset();
        event.getAxiom().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
    }

    public void visit(AddPropertyAxiom event) throws OWLException {
        this.collector.reset();
        event.getAxiom().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
    }

    public void visit(AddSuperClass event) throws OWLException {
        this.collector.reset();
        event.getDescription().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
        this.entities.add(event.getOWLClass());
    }

    public void visit(AddSuperProperty event) throws OWLException {
        this.entities.add(event.getProperty());
        this.entities.add(event.getSuperProperty());
    }

    public void visit(AddIndividualClass event) throws OWLException {
        this.collector.reset();
        event.getDescription().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
        this.entities.add(event.getIndividual());
    }

    public void visit(AddEquivalentClass event) throws OWLException {
        this.collector.reset();
        event.getDescription().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
        this.entities.add(event.getOWLClass());
    }

    public void visit(AddEnumeration event) throws OWLException {
        this.collector.reset();
        event.getEnumeration().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
        this.entities.add(event.getOWLClass());
    }

    public void visit(AddDomain event) throws OWLException {
        this.collector.reset();
        event.getDomain().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
        this.entities.add(event.getProperty());
    }

    public void visit(AddDataPropertyRange event) throws OWLException {
        this.entities.add(event.getProperty());
    }

    public void visit(AddObjectPropertyRange event) throws OWLException {
        this.collector.reset();
        event.getRange().accept(this.collector);
        Iterator it = this.collector.entities().iterator();
        while (it.hasNext()) {
            this.entities.add(it.next());
        }
        this.entities.add(event.getProperty());
    }

    public void visit(AddInverse event) throws OWLException {
        this.entities.add(event.getProperty());
        this.entities.add(event.getInverse());
    }

    public void visit(SetFunctional event) throws OWLException {
        this.entities.add(event.getProperty());
    }

    public void visit(SetTransitive event) throws OWLException {
        this.entities.add(event.getProperty());
    }

    public void visit(SetSymmetric event) throws OWLException {
        this.entities.add(event.getProperty());
    }

    public void visit(SetInverseFunctional event) throws OWLException {
        this.entities.add(event.getProperty());
    }

    public void visit(SetOneToOne event) throws OWLException {
        this.entities.add(event.getProperty());
    }

    public void visit(SetDeprecated event) throws OWLException {
        this.entities.add(event.getObject());
    }

    public void visit(AddObjectPropertyInstance event) throws OWLException {
        this.entities.add(event.getSubject());
        this.entities.add(event.getProperty());
        this.entities.add(event.getObject());
    }

    public void visit(AddDataPropertyInstance event) throws OWLException {
        this.entities.add(event.getProperty());
        this.entities.add(event.getSubject());
    }

    public void visit(AddImport event) throws OWLException {
    }
}

