/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.util.Set;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLClassAxiomImpl;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.model.OWLClassAxiomVisitor;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLSubClassAxiom;

public class OWLSubClassAxiomImpl
extends OWLClassAxiomImpl
implements OWLSubClassAxiom {
    private OWLDescription subClass;
    private OWLDescription superClass;
    private Set ontologies;

    public OWLSubClassAxiomImpl(OWLDataFactoryImpl factory, OWLDescription subClass, OWLDescription superClass) {
        super(factory);
        this.subClass = subClass;
        this.superClass = superClass;
        this.ontologies = ListFactory.getSet();
    }

    public OWLDescription getSuperClass() {
        return this.superClass;
    }

    public OWLDescription getSubClass() {
        return this.subClass;
    }

    public Set getOntologies() {
        return ListFactory.getSet(this.ontologies);
    }

    public void accept(OWLObjectVisitor visitor) throws OWLException {
        visitor.visit((OWLSubClassAxiom)this);
    }

    public void accept(OWLClassAxiomVisitor visitor) throws OWLException {
        visitor.visit((OWLSubClassAxiom)this);
    }

    public boolean equals(Object o) {
        OWLSubClassAxiomImpl scaObj;
        return super.equals(o) && (scaObj = (OWLSubClassAxiomImpl)o).getSubClass().equals(this.subClass) && scaObj.getSuperClass().equals(this.superClass);
    }

    public int hashCode() {
        return super.hashCode() + OWLSubClassAxiomImpl.hashCode(this.subClass) + OWLSubClassAxiomImpl.hashCode(this.superClass);
    }
}

