/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.impl.model.OWLDeprecatableObjectImpl;
import org.semanticweb.owl.impl.model.OWLEntityImpl;
import org.semanticweb.owl.impl.model.OWLImplHelper;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLProperty;

public abstract class OWLPropertyImpl
extends OWLEntityImpl
implements OWLProperty,
OWLDeprecatableObjectImpl {
    private Map superProperties = ListFactory.getMap();
    private Map domains = ListFactory.getMap();
    protected Map ranges = ListFactory.getMap();
    private Set functional = ListFactory.getSet();
    private Set deprecated = ListFactory.getSet();

    public OWLPropertyImpl(OWLDataFactoryImpl factory) {
        super(factory);
    }

    public Set getSuperProperties() {
        return OWLImplHelper.unionValues(this.superProperties);
    }

    public Set getSuperProperties(OWLOntology o) {
        return OWLImplHelper.getAppropriateSet(this.superProperties, o);
    }

    public Set getSuperProperties(Set ontos) {
        return OWLImplHelper.selectValues(this.superProperties, ontos);
    }

    boolean addSuperProperty(OWLOntology ontology, OWLProperty superProperty) {
        return OWLImplHelper.getAppropriateSet(this.superProperties, ontology).add(superProperty);
    }

    boolean removeSuperProperty(OWLOntology ontology, OWLProperty superProperty) {
        return OWLImplHelper.getAppropriateSet(this.superProperties, ontology).remove(superProperty);
    }

    public Set getDomains() {
        return OWLImplHelper.unionValues(this.domains);
    }

    public Set getDomains(OWLOntology o) {
        return OWLImplHelper.getAppropriateSet(this.domains, o);
    }

    public Set getDomains(Set ontos) {
        return OWLImplHelper.selectValues(this.domains, ontos);
    }

    boolean addDomain(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.domains, ontology).add(description);
    }

    boolean removeDomain(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.domains, ontology).remove(description);
    }

    public Set getRanges() {
        return OWLImplHelper.unionValues(this.ranges);
    }

    public Set getRanges(OWLOntology o) {
        return OWLImplHelper.getAppropriateSet(this.ranges, o);
    }

    public Set getRanges(Set ontos) {
        return OWLImplHelper.selectValues(this.ranges, ontos);
    }

    public boolean isFunctional() {
        return !this.functional.isEmpty();
    }

    public boolean isFunctional(OWLOntology o) {
        return this.functional.contains(o);
    }

    public boolean isFunctional(Set ontos) {
        Iterator it = ontos.iterator();
        while (it.hasNext()) {
            if (!this.functional.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    void setFunctional(OWLOntology o, boolean b) {
        if (b) {
            this.functional.add(o);
        } else if (this.functional.contains(o)) {
            this.functional.remove(o);
        }
    }

    public boolean isDeprecated(OWLOntology o) {
        return this.deprecated.contains(o);
    }

    public void setDeprecated(OWLOntology o, boolean b) {
        if (b) {
            this.deprecated.add(o);
        } else if (this.deprecated.contains(o)) {
            this.deprecated.remove(o);
        }
    }
}

