/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.impl.model.OWLEntityImpl;
import org.semanticweb.owl.impl.model.OWLImplHelper;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;

public class OWLIndividualImpl
extends OWLEntityImpl
implements OWLIndividual {
    private Map types;
    private Map objectPropertyValues;
    private Map incomingObjectPropertyValues;
    private Map dataPropertyValues;
    private URI anonId;

    public OWLIndividualImpl(OWLDataFactoryImpl factory, URI uri) {
        this(factory, uri, false);
    }

    public OWLIndividualImpl(OWLDataFactoryImpl factory, URI uri, boolean isAnon) {
        super(factory);
        if (uri == null) {
            throw new NullPointerException();
        }
        if (isAnon) {
            this.anonId = uri;
        } else {
            this.uri = uri;
        }
        this.types = ListFactory.getMap();
        this.objectPropertyValues = ListFactory.getMap();
        this.incomingObjectPropertyValues = ListFactory.getMap();
        this.dataPropertyValues = ListFactory.getMap();
    }

    public boolean isAnonymous() {
        return this.uri == null;
    }

    public URI getAnonId() {
        return this.anonId;
    }

    public Set getTypes(OWLOntology o) {
        return OWLImplHelper.getAppropriateSet(this.types, o);
    }

    public Set getTypes(Set ontologies) {
        return OWLImplHelper.selectValues(this.types, ontologies);
    }

    public Set getTypes() {
        return OWLImplHelper.unionValues(this.types);
    }

    boolean addType(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.types, ontology).add(description);
    }

    boolean removeType(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.types, ontology).remove(description);
    }

    public Map getObjectPropertyValues(OWLOntology o) {
        return OWLImplHelper.getAppropriateMap(this.objectPropertyValues, o);
    }

    public Map getObjectPropertyValues(Set ontologies) {
        return OWLImplHelper.selectMaps(this.objectPropertyValues, ontologies);
    }

    public Map getObjectPropertyValues() {
        return OWLImplHelper.unionMaps(this.objectPropertyValues);
    }

    boolean addObjectPropertyValue(OWLOntology o, OWLObjectProperty prop, OWLIndividual ind) {
        Map m = OWLImplHelper.getAppropriateMap(this.objectPropertyValues, o);
        Set s = (Set)m.get(prop);
        if (s == null) {
            s = ListFactory.getSet();
            m.put(prop, s);
        }
        boolean added = s.add(ind);
        return ((OWLIndividualImpl)ind).addIncomingObjectPropertyValue(o, prop, this) && added;
    }

    boolean removeObjectPropertyValue(OWLOntology o, OWLObjectProperty prop, OWLIndividual ind) {
        Map m = OWLImplHelper.getAppropriateMap(this.objectPropertyValues, o);
        Set s = (Set)m.get(prop);
        boolean removed = s.remove(ind);
        return ((OWLIndividualImpl)ind).removeIncomingObjectPropertyValue(o, prop, this) && removed;
    }

    public Map getIncomingObjectPropertyValues(OWLOntology o) {
        return OWLImplHelper.getAppropriateMap(this.incomingObjectPropertyValues, o);
    }

    public Map getIncomingObjectPropertyValues(Set ontologies) {
        return OWLImplHelper.selectMaps(this.incomingObjectPropertyValues, ontologies);
    }

    public Map getIncomingObjectPropertyValues() {
        return OWLImplHelper.unionMaps(this.incomingObjectPropertyValues);
    }

    boolean addIncomingObjectPropertyValue(OWLOntology o, OWLObjectProperty prop, OWLIndividual ind) {
        Map m = OWLImplHelper.getAppropriateMap(this.incomingObjectPropertyValues, o);
        Set s = (Set)m.get(prop);
        if (s == null) {
            s = ListFactory.getSet();
            m.put(prop, s);
        }
        return s.add(ind);
    }

    boolean removeIncomingObjectPropertyValue(OWLOntology o, OWLObjectProperty prop, OWLIndividual ind) {
        Map m = OWLImplHelper.getAppropriateMap(this.incomingObjectPropertyValues, o);
        Set s = (Set)m.get(prop);
        return s.remove(ind);
    }

    public Map getDataPropertyValues(OWLOntology o) {
        return OWLImplHelper.getAppropriateMap(this.dataPropertyValues, o);
    }

    public Map getDataPropertyValues(Set ontologies) {
        return OWLImplHelper.selectMaps(this.dataPropertyValues, ontologies);
    }

    public Map getDataPropertyValues() {
        return OWLImplHelper.unionMaps(this.dataPropertyValues);
    }

    boolean addDataPropertyValue(OWLOntology o, OWLDataProperty prop, OWLDataValue val) {
        Map m = OWLImplHelper.getAppropriateMap(this.dataPropertyValues, o);
        Set s = (Set)m.get(prop);
        if (s == null) {
            s = ListFactory.getSet();
            m.put(prop, s);
        }
        return s.add(val);
    }

    boolean removeDataPropertyValue(OWLOntology o, OWLDataProperty prop, OWLDataValue val) {
        Map m = OWLImplHelper.getAppropriateMap(this.dataPropertyValues, o);
        Set s = (Set)m.get(prop);
        return s.remove(val);
    }

    public void accept(OWLObjectVisitor visitor) throws OWLException {
        visitor.visit((OWLIndividual)this);
    }

    public void accept(OWLEntityVisitor visitor) throws OWLException {
        visitor.visit((OWLIndividual)this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OWLIndividualImpl) {
            OWLIndividualImpl that = (OWLIndividualImpl)other;
            URI thisURI = this.getURI();
            URI thatURI = that.getURI();
            if (thisURI != null) {
                if (thatURI != null) {
                    return thisURI.equals(thatURI);
                }
                return false;
            }
            if (thatURI == null) {
                thisURI = this.getAnonId();
                thatURI = that.getAnonId();
                return thisURI != null && thatURI != null && thisURI.equals(thatURI);
            }
            return false;
        }
        return false;
    }
}

