/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.model.OWLOntology;

public class OWLImplHelper {
    static Logger logger = Logger.getLogger((Class)OWLImplHelper.class);

    static Set getAppropriateSet(Map map, OWLOntology o) {
        try {
            Set s = (Set)map.get(o);
            if (s == null) {
                s = ListFactory.getSet();
                map.put(o, s);
            }
            return s;
        }
        catch (ClassCastException ex) {
            return ListFactory.getSet();
        }
    }

    static Map getAppropriateMap(Map map, OWLOntology o) {
        try {
            Map m = (Map)map.get(o);
            if (m == null) {
                m = ListFactory.getMap();
                map.put(o, m);
            }
            logger.debug((Object)"YY");
            return m;
        }
        catch (ClassCastException ex) {
            logger.debug((Object)"XX");
            return ListFactory.getMap();
        }
    }

    static Set unionValues(Map map) {
        Set result = ListFactory.getSet();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Set s = (Set)it.next();
            result.addAll(s);
        }
        return result;
    }

    static Set selectValues(Map map, Set ontos) {
        Set result = ListFactory.getSet();
        Iterator it = ontos.iterator();
        while (it.hasNext()) {
            OWLOntology onto = (OWLOntology)it.next();
            Set s = OWLImplHelper.getAppropriateSet(map, onto);
            result.addAll(s);
        }
        return result;
    }

    static Map unionMaps(Map map) {
        Map result = ListFactory.getMap();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            Map m = (Map)it.next();
            Iterator keyIt = m.keySet().iterator();
            while (keyIt.hasNext()) {
                Object key = keyIt.next();
                Set s = null;
                if (!result.containsKey(key)) {
                    s = ListFactory.getSet();
                    result.put(key, s);
                } else {
                    s = (Set)result.get(key);
                }
                Set vals = (Set)m.get(key);
                logger.debug(m.get(key));
                s.addAll(vals);
            }
        }
        return result;
    }

    static Map selectMaps(Map map, Set ontologies) {
        Map result = ListFactory.getMap();
        Iterator it = ontologies.iterator();
        while (it.hasNext()) {
            Map m = (Map)map.get(it.next());
            if (m == null) continue;
            Iterator keyIt = m.keySet().iterator();
            while (keyIt.hasNext()) {
                Object key = keyIt.next();
                Set s = null;
                if (!result.containsKey(key)) {
                    s = ListFactory.getSet();
                    result.put(key, s);
                } else {
                    s = (Set)result.get(key);
                }
                Set vals = (Set)m.get(key);
                logger.debug(m.get(key));
                s.addAll(vals);
            }
        }
        return result;
    }
}

