/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.impl.model.OWLOntologyImpl;
import org.semanticweb.owl.io.Parser;
import org.semanticweb.owl.io.ParserException;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.util.PhysicalURIToDefaultParametersResolver;

public class OWLConnectionImpl
implements OWLConnection {
    Map openOntologies = new HashMap();
    static Logger logger = Logger.getLogger((Class)OWLConnectionImpl.class);
    protected static final Map s_defaultParameters;
    protected Map m_parameters;
    protected Map m_ontologiesByLogicalURI;
    protected Map m_ontologiesByPhysicalURI;
    protected OWLDataFactory m_owlDataFactory;
    protected ChangeVisitor m_applyChangeVisitor;

    public OWLConnectionImpl() throws OWLException {
        this(s_defaultParameters, new HashMap(), new HashMap());
    }

    public OWLConnectionImpl(Map parameters) throws OWLException {
        this(parameters, new HashMap(), new HashMap());
    }

    public OWLConnectionImpl(Map parameters, Map ontologiesByLogicalURI, Map ontologiesByPhysicalURI) throws OWLException {
        this.m_parameters = new HashMap(parameters);
        this.m_ontologiesByLogicalURI = ontologiesByLogicalURI;
        this.m_ontologiesByPhysicalURI = ontologiesByPhysicalURI;
        this.m_owlDataFactory = OWLDataFactoryImpl.getInstance(this);
        this.m_applyChangeVisitor = null;
    }

    public OWLDataFactory getDataFactory() {
        return this.m_owlDataFactory;
    }

    public synchronized Map getParameters() {
        return this.m_parameters;
    }

    public synchronized void close() {
        this.m_ontologiesByLogicalURI = null;
        this.m_ontologiesByPhysicalURI = null;
    }

    public synchronized boolean isOpen() {
        return this.m_ontologiesByLogicalURI != null;
    }

    public synchronized OWLConnection getConnection() throws OWLException {
        HashMap childOIModelsByLogicalURI = new HashMap();
        HashMap childOIModelsByPhysicalURI = new HashMap();
        return new OWLConnectionImpl(this.m_parameters, childOIModelsByLogicalURI, childOIModelsByPhysicalURI);
    }

    public synchronized OWLOntology openOntologyPhysical(URI physicalURI) throws OWLException {
        logger.info((Object)"TO DO: Use default Parser instead of hard-coded one");
        Parser parser = null;
        try {
            parser = (Parser)Class.forName("org.semanticweb.owl.io.owl_rdf.OWLRDFParser").newInstance();
        }
        catch (Exception ex) {
            throw new OWLException(ex.getMessage());
        }
        if (this.m_ontologiesByPhysicalURI.containsKey(physicalURI)) {
            return (OWLOntology)this.m_ontologiesByPhysicalURI.get(physicalURI);
        }
        OWLOntology onto = null;
        logger.info((Object)"TO DO: logicalURI should be derived from Code");
        try {
            onto = parser.parseOntology(physicalURI);
        }
        catch (ParserException e) {
            throw new OWLException("Parsing failed", (Exception)((Object)e));
        }
        this.m_ontologiesByPhysicalURI.put(physicalURI, onto);
        return onto;
    }

    public synchronized OWLOntology openOntologyLogical(URI logicalURI) throws OWLException {
        if (this.m_ontologiesByLogicalURI.containsKey(logicalURI)) {
            return (OWLOntology)this.m_ontologiesByLogicalURI.get(logicalURI);
        }
        try {
            return this.loadOntologyPhysical(logicalURI);
        }
        catch (OWLException e) {
            throw new OWLException("Cannot find ontology with logical URI" + logicalURI);
        }
    }

    public synchronized OWLOntology createOWLOntology(URI physicalURI, URI logicalURI) throws OWLException {
        if (this.m_ontologiesByPhysicalURI.containsKey(physicalURI) || this.m_ontologiesByLogicalURI.containsKey(logicalURI)) {
            throw new OWLException("Cannot create ontology with this physical or logical URI, since it is already open:\n  " + physicalURI + "\n  " + logicalURI);
        }
        logicalURI = physicalURI.resolve(logicalURI);
        if (this.m_ontologiesByPhysicalURI.containsKey(physicalURI)) {
            throw new OWLException("Model with physical URI '" + physicalURI + "' has already been opened.");
        }
        if (this.m_ontologiesByLogicalURI.containsKey(logicalURI)) {
            throw new OWLException("Model with logical URI '" + logicalURI + "' has already been opened.");
        }
        OWLOntology onto = this.m_owlDataFactory.getOWLOntology(logicalURI, physicalURI);
        if (logicalURI != null) {
            this.m_ontologiesByLogicalURI.put(logicalURI, onto);
        }
        if (physicalURI != null) {
            this.m_ontologiesByPhysicalURI.put(physicalURI, onto);
        }
        return onto;
    }

    public synchronized void notifyOntologyDeleted(OWLOntology onto) throws OWLException {
        this.m_ontologiesByLogicalURI.remove(onto.getLogicalURI());
        this.m_ontologiesByPhysicalURI.remove(onto.getPhysicalURI());
        ((OWLDataFactoryImpl)this.m_owlDataFactory).forgetOWLOntology(onto);
    }

    public synchronized void dropAllOntologies() throws OWLException {
        this.m_ontologiesByLogicalURI = new HashMap();
        this.m_ontologiesByPhysicalURI = new HashMap();
        this.m_owlDataFactory = OWLDataFactoryImpl.getInstance(this);
    }

    public synchronized Set getOpenOWLOntologies() {
        return new HashSet(this.m_ontologiesByLogicalURI.values());
    }

    public synchronized Set getAllOntologies() {
        return new HashSet(this.m_ontologiesByLogicalURI.values());
    }

    public synchronized Set getAllLogicalURIs() {
        return this.m_ontologiesByLogicalURI.keySet();
    }

    public synchronized void applyChanges(List changes) throws OWLException {
        logger.info((Object)"Not yet implemented!");
    }

    public ChangeVisitor getChangeVisitor(OWLOntology o) throws OWLException {
        if (o instanceof OWLOntologyImpl) {
            return (ChangeVisitor)o;
        }
        throw new OWLException("Cannot create visitor for: " + o + "\nWrong implementation class");
    }

    public void changeOntologyLogicalURI(OWLOntology o, URI uri) throws OWLException {
        if (!o.getURI().equals(uri)) {
            if (this.m_ontologiesByLogicalURI.containsKey(uri)) {
                throw new OWLException("Logical URI " + uri + " in use");
            }
            this.m_ontologiesByLogicalURI.remove(o.getLogicalURI());
            this.m_ontologiesByLogicalURI.put(uri, o);
        }
    }

    public OWLOntology createOntology(URI physicalURI, URI logicalURI) throws OWLException {
        if (this.m_ontologiesByPhysicalURI.containsKey(physicalURI) || this.m_ontologiesByLogicalURI.containsKey(logicalURI)) {
            throw new OWLException("Cannot create ontology with this physical or logical URI, since it is already open:\n  " + physicalURI + "\n  " + logicalURI);
        }
        logicalURI = physicalURI.resolve(logicalURI);
        if (this.m_ontologiesByPhysicalURI.containsKey(physicalURI)) {
            throw new OWLException("Model with physical URI '" + physicalURI + "' has already been opened.");
        }
        if (this.m_ontologiesByLogicalURI.containsKey(logicalURI)) {
            throw new OWLException("Model with logical URI '" + logicalURI + "' has already been opened.");
        }
        OWLOntology onto = this.m_owlDataFactory.getOWLOntology(logicalURI, physicalURI);
        if (logicalURI != null) {
            this.m_ontologiesByLogicalURI.put(logicalURI, onto);
        }
        if (physicalURI != null) {
            this.m_ontologiesByPhysicalURI.put(physicalURI, onto);
        }
        return onto;
    }

    public OWLOntology getOntologyLogical(URI logicalURI) throws OWLException {
        throw new OWLException("This implementation does not yet track logical URI usage.");
    }

    public OWLOntology getOntologyPhysical(URI physicalURI) throws OWLException {
        return this.m_ontologiesByPhysicalURI.containsKey(physicalURI) ? (OWLOntology)this.m_ontologiesByPhysicalURI.get(physicalURI) : this.loadOntologyPhysical(physicalURI);
    }

    public OWLOntology loadOntologyPhysical(URI physicalURI) throws OWLException {
        if (this.m_ontologiesByPhysicalURI.containsKey(physicalURI)) {
            throw new OWLException("Ontology with physical URI '" + physicalURI + "' has already been loaded.");
        }
        OWLOntology onto = null;
        logger.info((Object)"TO DO: logicalURI should be derived from Code");
        Parser parser = null;
        try {
            parser = (Parser)Class.forName("org.semanticweb.owl.io.owl_rdf.OWLRDFParser").newInstance();
            parser.setConnection((OWLConnection)this);
        }
        catch (Exception ex) {
            throw new OWLException(ex.getMessage());
        }
        try {
            onto = parser.parseOntology(physicalURI);
        }
        catch (ParserException e) {
            throw new OWLException("Parsing failed", (Exception)((Object)e));
        }
        this.m_ontologiesByPhysicalURI.put(physicalURI, onto);
        this.m_ontologiesByLogicalURI.put(onto.getURI(), onto);
        return onto;
    }

    public OWLOntology reloadOntologyPhysical(URI physicalURI) throws OWLException {
        if (!this.m_ontologiesByPhysicalURI.containsKey(physicalURI)) {
            throw new OWLException("Ontology with physical URI '" + physicalURI + "' has not yet been loaded.");
        }
        this.m_ontologiesByLogicalURI.remove(this.getOntologyPhysical(physicalURI).getURI());
        this.m_ontologiesByPhysicalURI.remove(physicalURI);
        return this.loadOntologyPhysical(physicalURI);
    }

    static {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("OWL_CONNECTION", "org.semanticweb.owl.impl.model");
        s_defaultParameters = Collections.unmodifiableMap(parameters);
        OWLManager.registerPhysicalURIToDefaultParametersResolver((PhysicalURIToDefaultParametersResolver)new PhysicalURIResolver());
    }

    protected static class PhysicalURIResolver
    implements PhysicalURIToDefaultParametersResolver {
        protected PhysicalURIResolver() {
        }

        public Map getDefaultParametersForPhysicalURI(String physicalURI, Map contextParameters) {
            if (physicalURI.startsWith("jar:") || physicalURI.startsWith("file:") || physicalURI.startsWith("http:")) {
                return new HashMap(s_defaultParameters);
            }
            return null;
        }
    }
}

