/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.net.URI;
import java.util.Set;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.impl.model.OWLDeprecatableObjectImpl;
import org.semanticweb.owl.impl.model.OWLObjectImpl;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;

public class OWLConcreteDataTypeImpl
extends OWLObjectImpl
implements OWLDataType,
OWLDeprecatableObjectImpl {
    private URI uri;
    private Set deprecated;

    public OWLConcreteDataTypeImpl(OWLDataFactoryImpl factory, URI uri) {
        super(factory);
        this.uri = uri;
        this.deprecated = ListFactory.getSet();
    }

    public URI getURI() {
        return this.uri;
    }

    public void accept(OWLObjectVisitor visitor) throws OWLException {
        visitor.visit((OWLDataType)this);
    }

    public boolean isDeprecated(OWLOntology o) {
        return this.deprecated.contains(o);
    }

    public void setDeprecated(OWLOntology o, boolean b) {
        if (b) {
            this.deprecated.add(o);
        } else if (this.deprecated.contains(o)) {
            this.deprecated.remove(o);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o) && ((OWLConcreteDataTypeImpl)o).getURI().equals(this.uri);
    }

    public int hashCode() {
        return super.hashCode() + OWLConcreteDataTypeImpl.hashCode(this.uri) + OWLConcreteDataTypeImpl.hashCode(this.deprecated);
    }
}

