/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.impl.model;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.impl.model.ListFactory;
import org.semanticweb.owl.impl.model.OWLDataFactoryImpl;
import org.semanticweb.owl.impl.model.OWLDeprecatableObjectImpl;
import org.semanticweb.owl.impl.model.OWLEntityImpl;
import org.semanticweb.owl.impl.model.OWLImplHelper;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;

public class OWLClassImpl
extends OWLEntityImpl
implements OWLClass,
OWLDeprecatableObjectImpl {
    private Map superClasses;
    private Map subClasses;
    private Map equivalentClasses;
    private Map enumerations;
    private Set deprecated;

    public OWLClassImpl(OWLDataFactoryImpl factory, URI uri) {
        super(factory);
        this.uri = uri;
        this.superClasses = ListFactory.getMap();
        this.equivalentClasses = ListFactory.getMap();
        this.enumerations = ListFactory.getMap();
        this.deprecated = ListFactory.getSet();
        this.subClasses = ListFactory.getMap();
    }

    public Set getSuperClasses(OWLOntology o) {
        return ListFactory.getSet(OWLImplHelper.getAppropriateSet(this.superClasses, o));
    }

    public Set getSuperClasses(Set ontos) {
        return ListFactory.getSet(OWLImplHelper.selectValues(this.superClasses, ontos));
    }

    public Set getSuperClasses() {
        return ListFactory.getSet(OWLImplHelper.unionValues(this.superClasses));
    }

    boolean addSuperClass(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.superClasses, ontology).add(description);
    }

    boolean addSubClass(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.subClasses, ontology).add(description);
    }

    boolean removeSubClass(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.subClasses, ontology).remove(description);
    }

    boolean removeSuperClass(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.superClasses, ontology).remove(description);
    }

    public Set getEquivalentClasses(OWLOntology o) {
        return ListFactory.getSet(OWLImplHelper.getAppropriateSet(this.equivalentClasses, o));
    }

    public Set getEquivalentClasses(Set ontos) {
        return ListFactory.getSet(OWLImplHelper.selectValues(this.equivalentClasses, ontos));
    }

    public Set getEquivalentClasses() {
        return OWLImplHelper.unionValues(this.equivalentClasses);
    }

    boolean addEquivalentClass(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.equivalentClasses, ontology).add(description);
    }

    boolean removeEquivalentClass(OWLOntology ontology, OWLDescription description) {
        return OWLImplHelper.getAppropriateSet(this.equivalentClasses, ontology).remove(description);
    }

    public Set getEnumerations(OWLOntology o) {
        return ListFactory.getSet(OWLImplHelper.getAppropriateSet(this.enumerations, o));
    }

    public Set getEnumerations(Set ontos) {
        return ListFactory.getSet(OWLImplHelper.selectValues(this.enumerations, ontos));
    }

    public Set getEnumerations() {
        return OWLImplHelper.unionValues(this.enumerations);
    }

    boolean addEnumeration(OWLOntology ontology, OWLEnumeration enumeration) {
        return OWLImplHelper.getAppropriateSet(this.enumerations, ontology).add(enumeration);
    }

    boolean removeEnumeration(OWLOntology ontology, OWLEnumeration enumeration) {
        return OWLImplHelper.getAppropriateSet(this.enumerations, ontology).remove(enumeration);
    }

    public boolean isDeprecated(OWLOntology o) {
        return this.deprecated.contains(o);
    }

    public void setDeprecated(OWLOntology o, boolean b) {
        if (b) {
            this.deprecated.add(o);
        } else if (this.deprecated.contains(o)) {
            this.deprecated.remove(o);
        }
    }

    public void accept(OWLObjectVisitor visitor) throws OWLException {
        visitor.visit((OWLClass)this);
    }

    public void accept(OWLEntityVisitor visitor) throws OWLException {
        visitor.visit((OWLClass)this);
    }

    public void accept(OWLDescriptionVisitor visitor) throws OWLException {
        visitor.visit((OWLClass)this);
    }

    public Set getSubClasses(OWLOntology o) throws OWLException {
        return ListFactory.getSet(OWLImplHelper.getAppropriateSet(this.subClasses, o));
    }

    public Set getSubClasses(Set ontos) throws OWLException {
        return ListFactory.getSet(OWLImplHelper.selectValues(this.subClasses, ontos));
    }
}

