/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.owl_rdf;

import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.owl.io.RendererException;
import org.semanticweb.owl.io.owl_rdf.QNameShortFormProvider;
import org.semanticweb.owl.io.owl_rdf.RenderingConstants;
import org.semanticweb.owl.io.owl_rdf.RenderingVisitor;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.helper.OntologyHelper;

public class Renderer
implements org.semanticweb.owl.io.Renderer,
RenderingConstants {
    protected OWLOntology ontology;
    protected PrintWriter pw;
    protected Set allURIs;
    protected int reservedNames;
    protected RenderingVisitor visitor;
    protected QNameShortFormProvider qnameProvider;

    public void setOptions(Map map) {
    }

    public Map getOptions() {
        return null;
    }

    public void renderOntology(OWLOntology ontology, Writer writer) throws RendererException {
        this.ontology = ontology;
        try {
            this.pw = new PrintWriter(writer);
            this.allURIs = OntologyHelper.allURIs((OWLOntology)ontology);
            this.visitor = new RenderingVisitor(this);
            this.qnameProvider = new QNameShortFormProvider();
            this.generateShortNames();
            this.writeHeader();
            Iterator it = this.orderedEntities(ontology.getClasses()).iterator();
            while (it.hasNext()) {
                this.renderClass(ontology, (OWLClass)it.next());
            }
            it = this.orderedEntities(ontology.getObjectProperties()).iterator();
            while (it.hasNext()) {
                this.renderObjectProperty(ontology, (OWLObjectProperty)it.next());
            }
            this.pw.println();
            it = this.orderedEntities(ontology.getDataProperties()).iterator();
            while (it.hasNext()) {
                this.renderDataProperty(ontology, (OWLDataProperty)it.next());
            }
            this.pw.println();
            it = this.orderedEntities(ontology.getIndividuals()).iterator();
            while (it.hasNext()) {
                this.renderIndividual(ontology, (OWLIndividual)it.next());
            }
            this.pw.println();
            it = this.orderedEntities(ontology.getClassAxioms()).iterator();
            while (it.hasNext()) {
                this.renderClassAxiom((OWLClassAxiom)it.next());
            }
            it = this.orderedEntities(ontology.getPropertyAxioms()).iterator();
            while (it.hasNext()) {
                this.renderPropertyAxiom((OWLPropertyAxiom)it.next());
            }
            this.writeExtensions();
            this.writeFooter();
            this.pw.flush();
        }
        catch (OWLException ex) {
            throw new RendererException(ex.getMessage());
        }
    }

    protected void writeExtensions() throws OWLException {
    }

    protected void renderPropertyAxiom(OWLPropertyAxiom axiom) throws OWLException {
        this.visitor.reset();
        this.visitor.setLevel(0);
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.println(this.visitor.result());
    }

    protected void writeFooter() {
        this.pw.println("</rdf:RDF>");
    }

    protected void renderClass(OWLOntology ontology, OWLClass clazz) throws OWLException {
        OWLDescription eq;
        boolean done = false;
        this.pw.println("<owl:Class rdf:about=\"" + clazz.getURI().toString() + "\">");
        Iterator it = clazz.getEquivalentClasses(ontology).iterator();
        while (it.hasNext()) {
            eq = (OWLDescription)it.next();
            this.visitor.reset();
            this.visitor.setLevel(2);
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  <owl:equivalentClass>");
            this.pw.print(this.visitor.result());
            this.pw.println("  </owl:equivalentClass>");
            done = true;
        }
        if (!clazz.getSuperClasses(ontology).isEmpty()) {
            it = clazz.getSuperClasses(ontology).iterator();
            while (it.hasNext()) {
                eq = (OWLDescription)it.next();
                this.visitor.reset();
                this.visitor.setLevel(2);
                eq.accept((OWLObjectVisitor)this.visitor);
                this.pw.println("  <rdfs:subClassOf>");
                this.pw.print(this.visitor.result());
                this.pw.println("  </rdfs:subClassOf>");
                done = true;
            }
        }
        it = clazz.getEnumerations(ontology).iterator();
        while (it.hasNext()) {
            OWLEnumeration enum_ = (OWLEnumeration)it.next();
            this.pw.println("  <owl:oneOf rdf:parseType=\"Collection\">");
            Iterator indIt = enum_.getIndividuals().iterator();
            while (indIt.hasNext()) {
                OWLIndividual desc = (OWLIndividual)indIt.next();
                this.visitor.reset();
                this.visitor.setLevel(2);
                desc.accept((OWLObjectVisitor)this.visitor);
                this.pw.print(this.visitor.result());
            }
            this.pw.println("  </owl:oneOf>");
        }
        this.pw.println("</owl:Class>");
        this.renderAnnotations(ontology, (OWLNamedObject)clazz);
    }

    protected void renderIndividual(OWLOntology ontology, OWLIndividual ind) throws OWLException {
        if (ind.getTypes(ontology).isEmpty() && ind.getObjectPropertyValues(ontology).keySet().isEmpty() && ind.getDataPropertyValues(ontology).keySet().isEmpty()) {
            this.pw.println("<owl:Thing rdf:about=\"" + ind.getURI() + "\" />");
        } else {
            this.pw.println("<rdf:Description rdf:about=\"" + ind.getURI() + "\">");
            Iterator it = ind.getTypes(ontology).iterator();
            while (it.hasNext()) {
                OWLDescription eq = (OWLDescription)it.next();
                this.visitor.reset();
                this.visitor.setLevel(2);
                eq.accept((OWLObjectVisitor)this.visitor);
                this.pw.println("  <rdf:type>");
                this.pw.print(this.visitor.result());
                this.pw.println("  </rdf:type>");
            }
            Map propertyValues = ind.getObjectPropertyValues(ontology);
            Iterator it2 = propertyValues.keySet().iterator();
            while (it2.hasNext()) {
                OWLObjectProperty prop = (OWLObjectProperty)it2.next();
                Set vals = (Set)propertyValues.get(prop);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLIndividual oi = (OWLIndividual)valIt.next();
                    this.pw.println("  <" + this.shortForm(prop.getURI()) + " rdf:resource=\"" + oi.getURI() + "\"/>");
                }
            }
            Map dataValues = ind.getDataPropertyValues(ontology);
            Iterator it3 = dataValues.keySet().iterator();
            while (it3.hasNext()) {
                OWLDataProperty prop = (OWLDataProperty)it3.next();
                Set vals = (Set)dataValues.get(prop);
                Iterator valIt = vals.iterator();
                while (valIt.hasNext()) {
                    OWLDataValue dtv = (OWLDataValue)valIt.next();
                    this.pw.print("  <" + this.shortForm(prop.getURI()));
                    if (dtv.getURI() != null) {
                        this.pw.print(" rdf:datatype=\"" + dtv.getURI() + "\"");
                    }
                    if (dtv.getLang() != null) {
                        this.pw.print(" xml:lang=\"" + dtv.getLang() + "\"");
                    }
                    this.pw.print(">");
                    this.pw.print(this.sanitize(dtv.getValue().toString()));
                    this.pw.println("</" + this.shortForm(prop.getURI()) + ">");
                }
            }
            this.pw.println("</rdf:Description>");
        }
        this.renderAnnotations(ontology, (OWLNamedObject)ind);
    }

    protected void renderObjectProperty(OWLOntology ontology, OWLObjectProperty prop) throws OWLException {
        OWLNamedObject element;
        OWLDescription eq;
        this.pw.println("<owl:ObjectProperty rdf:about=\"" + prop.getURI().toString() + "\">");
        if (prop.isTransitive(ontology)) {
            this.pw.println("  <rdf:type rdf:resource=\"&owl;TransitiveProperty\" />");
        }
        if (prop.isFunctional(ontology)) {
            this.pw.println("  <rdf:type rdf:resource=\"&owl;FunctionalProperty\" />");
        }
        if (prop.isInverseFunctional(ontology)) {
            this.pw.println("  <rdf:type rdf:resource=\"&owl;InverseFunctionalProperty\" />");
        }
        if (prop.isSymmetric(ontology)) {
            this.pw.println("  <rdf:type rdf:resource=\"&owl;SymmetricProperty\" />");
        }
        Iterator iter = prop.getDomains(ontology).iterator();
        while (iter.hasNext()) {
            eq = (OWLDescription)iter.next();
            this.visitor.reset();
            this.visitor.setLevel(2);
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  <rdfs:domain>");
            this.pw.print(this.visitor.result());
            this.pw.println("  </rdfs:domain>");
        }
        iter = prop.getRanges(ontology).iterator();
        while (iter.hasNext()) {
            eq = (OWLDescription)iter.next();
            this.visitor.reset();
            this.visitor.setLevel(2);
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  <rdfs:range>");
            this.pw.print(this.visitor.result());
            this.pw.println("  </rdfs:range>");
        }
        iter = prop.getInverses(ontology).iterator();
        while (iter.hasNext()) {
            element = (OWLNamedObject)iter.next();
            this.pw.println("  <owl:inverseOf rdf:resource=\"" + element.getURI().toString() + "\" />");
        }
        iter = prop.getSuperProperties(ontology).iterator();
        while (iter.hasNext()) {
            element = (OWLNamedObject)iter.next();
            this.pw.println("  <rdfs:subPropertyOf rdf:resource=\"" + element.getURI().toString() + "\" />");
        }
        this.pw.println("</owl:ObjectProperty>");
        this.renderAnnotations(ontology, (OWLNamedObject)prop);
    }

    protected void renderDataProperty(OWLOntology ontology, OWLDataProperty prop) throws OWLException {
        OWLDescription eq;
        this.pw.println("<owl:DatatypeProperty rdf:about=\"" + prop.getURI() + "\">");
        if (prop.isFunctional(ontology)) {
            this.pw.println("  <rdf:type rdf:resource=\"&owl;FunctionalProperty\" />");
        }
        Iterator iter = prop.getDomains(ontology).iterator();
        while (iter.hasNext()) {
            eq = (OWLDescription)iter.next();
            this.visitor.reset();
            this.visitor.setLevel(2);
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  <rdfs:domain>" + this.visitor.result() + "</rdfs:domain>");
        }
        iter = prop.getRanges(ontology).iterator();
        while (iter.hasNext()) {
            eq = (OWLDataRange)iter.next();
            this.visitor.reset();
            this.visitor.setLevel(2);
            eq.accept((OWLObjectVisitor)this.visitor);
            this.pw.println("  <rdfs:range>" + this.visitor.result() + "</rdfs:range>");
        }
        iter = prop.getSuperProperties(ontology).iterator();
        while (iter.hasNext()) {
            OWLNamedObject element = (OWLNamedObject)iter.next();
            this.pw.println("  <rdfs:subPropertyOf rdf:resource=\"" + element.getURI().toString() + "\" />");
        }
        this.pw.println("</owl:DatatypeProperty>");
        this.renderAnnotations(ontology, (OWLNamedObject)prop);
    }

    protected void renderAnnotations(OWLOntology ontology, OWLNamedObject object) throws OWLException {
        boolean i = false;
        if (!object.getAnnotations(ontology).isEmpty()) {
            this.pw.println("<rdf:Description rdf:about=\"" + object.getURI() + "\">");
            Iterator it = object.getAnnotations(ontology).iterator();
            while (it.hasNext()) {
                OWLAnnotationInstance oai = (OWLAnnotationInstance)it.next();
                OWLAnnotationProperty prop = oai.getProperty();
                Object content = oai.getContent();
                if (content instanceof OWLIndividual) {
                    this.pw.println("  <" + this.shortForm(prop.getURI()) + " rdf:resource=\"" + ((OWLIndividual)content).getURI() + "\"/>");
                    continue;
                }
                if (content instanceof URI) {
                    this.pw.println("  <" + this.shortForm(prop.getURI()) + " rdf:resource=\"" + (URI)content + "\"/>");
                    continue;
                }
                if (content instanceof OWLDataValue) {
                    OWLDataValue odv = (OWLDataValue)content;
                    this.pw.print("  <" + this.shortForm(prop.getURI()));
                    if (odv.getURI() != null) {
                        this.pw.print(" rdf:datatype=\"" + odv.getURI() + "\"");
                    }
                    if (odv.getLang() != null) {
                        this.pw.print(" xml:lang=\"" + odv.getLang() + "\"");
                    }
                    this.pw.print(">");
                    this.pw.print(odv.getValue().toString());
                    this.pw.println("</" + this.shortForm(prop.getURI()) + ">");
                    continue;
                }
                this.pw.println("  <" + this.shortForm(prop.getURI()) + ">" + content.toString() + "</" + this.shortForm(prop.getURI()) + ">");
            }
            this.pw.println("</rdf:Description>");
        }
    }

    protected void renderClassAxiom(OWLClassAxiom axiom) throws OWLException {
        this.visitor.reset();
        this.visitor.setLevel(0);
        axiom.accept((OWLObjectVisitor)this.visitor);
        this.pw.print(this.visitor.result());
    }

    protected void generateShortNames() {
        Iterator it = this.allURIs.iterator();
        while (it.hasNext()) {
            URI uri = (URI)it.next();
            String string = this.qnameProvider.shortForm(uri, false);
        }
    }

    protected void writeHeader() {
        this.pw.println("<?xml version=\"1.0\"?>");
        this.pw.println("<!DOCTYPE owl [");
        this.pw.println("<!ENTITY owl  \"http://www.w3.org/2002/07/owl#\">");
        this.pw.println("<!ENTITY xsd  \"http://www.w3.org/2001/XMLSchema#\">");
        this.pw.println("<!ENTITY rdf \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">");
        this.pw.println("<!ENTITY rdfs \"http://www.w3.org/2000/01/rdf-schema#\">");
        this.pw.println("]>");
        this.pw.println("<rdf:RDF");
        Iterator it = this.qnameProvider.getPrefixSet().iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            String ns = this.qnameProvider.getURI(prefix);
            this.pw.println(" xmlns:" + prefix + "=\"" + ns + "\"");
        }
        this.pw.println(">");
        try {
            Iterator iter;
            this.pw.println("<owl:Ontology rdf:about=\"" + this.ontology.getLogicalURI().toString() + "\">");
            if (this.ontology.getAnnotations() != null) {
                Set annotSet = this.ontology.getAnnotations();
                iter = annotSet.iterator();
                while (iter.hasNext()) {
                    OWLAnnotationInstance annot = (OWLAnnotationInstance)iter.next();
                    OWLAnnotationProperty prop = annot.getProperty();
                    String propURI = prop.getURI().toString();
                    String propLbl = "";
                    if (propURI.equals("http://www.w3.org/2000/01/rdf-schema#comment")) {
                        propLbl = "rdfs:comment";
                    } else if (propURI.equals("http://www.w3.org/2000/01/rdf-schema#label")) {
                        propLbl = "rdfs:label";
                    } else if (propURI.equals("http://www.w3.org/2002/07/owl#versionInfo")) {
                        propLbl = "owl:versionInfo";
                    }
                    String value = annot.getContent().toString();
                    if (propLbl.equals("")) continue;
                    this.pw.println("<" + propLbl + ">" + value + "</" + propLbl + ">");
                }
            }
            if (this.ontology.getIncludedOntologies() != null) {
                Set inclOntSet = this.ontology.getIncludedOntologies();
                iter = inclOntSet.iterator();
                while (iter.hasNext()) {
                    OWLOntology impOnt = (OWLOntology)iter.next();
                    this.pw.println("<owl:imports rdf:resource=\"" + impOnt.getURI().toString() + "\"/>");
                }
            }
            this.pw.println("</owl:Ontology>");
        }
        catch (OWLException e) {
            e.printStackTrace();
        }
    }

    protected String sanitize(String str) {
        StringBuffer result = new StringBuffer();
        char[] str_chars = str.toCharArray();
        for (int index = 0; index < str_chars.length; ++index) {
            char character = str_chars[index];
            if (character == '&') {
                result.append("&amp;");
                continue;
            }
            if (character == '<') {
                result.append("&lt;");
                continue;
            }
            result.append(character);
        }
        return result.toString();
    }

    public String shortForm(URI uri) throws RendererException {
        String qname = this.qnameProvider.shortForm(uri, false);
        if (qname == null) {
            throw new RendererException("Cannot give a qname to a URI that ends in a non-name character");
        }
        return qname;
    }

    protected SortedSet orderedEntities(Set entities) {
        TreeSet ss = new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    return ((OWLEntity)o1).getURI().toString().compareTo(((OWLEntity)o2).getURI().toString());
                }
                catch (Exception ex) {
                    return o1.toString().compareTo(o2.toString());
                }
            }
        });
        ss.addAll(entities);
        return ss;
    }

    public static void main(String[] args) {
    }
}

