/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.owl_rdf;

import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import edu.unika.aifb.rdf.api.syntax.RDFParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.semanticweb.owl.io.Parser;
import org.semanticweb.owl.io.ParserException;
import org.semanticweb.owl.io.owl_rdf.MalformedOWLConstructRDFException;
import org.semanticweb.owl.io.owl_rdf.OWLConsumer;
import org.semanticweb.owl.io.owl_rdf.OWLFullConstructRDFException;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorConstants;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.util.OWLConnection;
import org.semanticweb.owl.util.OWLManager;
import org.semanticweb.owl.util.URIMapper;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OWLRDFParser
implements Parser,
OWLRDFErrorConstants {
    OWLOntology onto;
    Map options = new HashMap();
    OWLRDFErrorHandler errorHandler;
    OWLConsumer consumer;
    RDFParser parser;
    OWLConnection connection;
    boolean importing = true;
    static Logger logger = Logger.getLogger((Class)OWLRDFParser.class);

    public void setConnection(OWLConnection conn) {
        this.connection = conn;
    }

    public OWLConnection getConnection() {
        return this.connection;
    }

    public void setOWLRDFErrorHandler(OWLRDFErrorHandler handler) {
        this.errorHandler = handler;
    }

    protected void setConsumer(OWLConsumer consumer) {
        this.consumer = consumer;
    }

    public boolean isAnonymousNodeURI(String uri) {
        return this.parser.isAnonymousNodeURI(uri);
    }

    public OWLOntology parseOntology(Reader reader, URI physicalURI) throws ParserException {
        if (this.connection == null) {
            String message = "Parser has no connection set!";
            throw new ParserException(message);
        }
        try {
            OWLOntology onto = this.connection.createOntology(physicalURI, physicalURI);
            this.parseOntology(onto, reader, physicalURI);
        }
        catch (ParserException ex) {
            throw ex;
        }
        catch (OWLException ex) {
            throw new ParserException(ex.getMessage());
        }
        return this.onto;
    }

    public OWLOntology parseOntology(URI uri) throws ParserException {
        URI theRealURIToRetrieve = uri;
        try {
            if (this.options.containsKey("uriMapper")) {
                logger.debug((Object)"Mapper found");
                try {
                    URIMapper mapper = (URIMapper)this.options.get("uriMapper");
                    if (mapper != null) {
                        logger.debug((Object)"Mapper non-null");
                        theRealURIToRetrieve = mapper.mapURI(uri);
                        logger.debug((Object)("Mapped URI: " + theRealURIToRetrieve.toString()));
                        if (theRealURIToRetrieve == null) {
                            logger.debug((Object)"Mapped URI null!");
                            theRealURIToRetrieve = uri;
                        }
                    }
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
            }
            URLConnection connection = theRealURIToRetrieve.toURL().openConnection();
            connection.addRequestProperty("Accept", "application/rdf+xml, application/xml; q=0.5, text/xml; q=0.3, */*; q=0.2");
            String contentEncoding = connection.getContentEncoding();
            if (contentEncoding == null) {
                contentEncoding = "UTF-8";
            }
            InputStreamReader isr = new InputStreamReader(connection.getInputStream(), contentEncoding);
            return this.parseOntology(isr, uri);
        }
        catch (MalformedURLException e) {
            throw new ParserException("URI is not a valid URL: ", (Exception)e, 2032);
        }
        catch (IOException e) {
            throw new ParserException("IO troubles when reading from URL: " + theRealURIToRetrieve.toString(), (Exception)e, 2031);
        }
    }

    protected void parseOntology(OWLOntology ontology, Reader reader, URI uri) throws ParserException {
        InputSource source;
        block20: {
            this.onto = ontology;
            this.parser = new RDFParser();
            source = new InputSource(reader);
            try {
                Boolean bool;
                source.setSystemId(uri.toString());
                if (this.consumer == null) {
                    this.consumer = new OWLConsumer(this.onto);
                    this.consumer.setImporting(this.importing);
                    this.consumer.setOWLRDFParser(this);
                    if (this.errorHandler != null) {
                        this.consumer.setOWLRDFErrorHandler(this.errorHandler);
                    }
                }
                if (this.options.containsKey("ignoreAnnotationContent")) {
                    try {
                        bool = (Boolean)this.options.get("ignoreAnnotationContent");
                        if (bool != null) {
                            this.consumer.setIgnoreAnnotationContent(bool);
                        }
                    }
                    catch (ClassCastException ex) {
                        // empty catch block
                    }
                }
                if (this.options.containsKey("ignoreSchemaImports")) {
                    try {
                        bool = (Boolean)this.options.get("ignoreSchemaImports");
                        if (bool != null) {
                            this.consumer.setIgnoreSchemaImports(bool);
                        }
                    }
                    catch (ClassCastException ex) {
                        // empty catch block
                    }
                }
                if (!this.options.containsKey("fixSameAs")) break block20;
                try {
                    bool = (Boolean)this.options.get("fixSameAs");
                    if (bool != null) {
                        this.consumer.setFixSameAs(bool);
                    }
                }
                catch (ClassCastException ex) {}
            }
            catch (OWLException e) {
                throw new ParserException(e.getMessage());
            }
        }
        try {
            this.parser.parse(source, (RDFConsumer)this.consumer);
        }
        catch (MalformedOWLConstructRDFException e) {
            this.onto = null;
            this.consumer = null;
            this.parser = null;
            source = null;
            throw new ParserException(e.getMessage());
        }
        catch (OWLFullConstructRDFException e) {
            this.onto = null;
            this.consumer = null;
            this.parser = null;
            source = null;
            throw new ParserException(e.getMessage());
        }
        catch (SAXException e) {
            this.onto = null;
            this.consumer = null;
            this.parser = null;
            source = null;
            throw new ParserException("Parsing failed due to XML Problem: " + e.getMessage(), (Exception)e, 2030);
        }
        catch (IOException e) {
            throw new ParserException("Parsing failed due to IO Errors: ", (Exception)e, 2031);
        }
        this.consumer = null;
    }

    protected void parseOntology(OWLOntology ontology, URI uri) throws ParserException {
        try {
            URI theRealURIToRetrieve = uri;
            if (this.options.containsKey("uriMapper")) {
                logger.debug((Object)"Mapper found");
                try {
                    URIMapper mapper = (URIMapper)this.options.get("uriMapper");
                    if (mapper != null) {
                        logger.debug((Object)"Mapper non-null");
                        theRealURIToRetrieve = mapper.mapURI(uri);
                        logger.debug((Object)("Mapped URI: " + theRealURIToRetrieve.toString()));
                        if (theRealURIToRetrieve == null) {
                            logger.debug((Object)"Mapped URI null!");
                            theRealURIToRetrieve = uri;
                        }
                    }
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
            }
            this.parseOntology(ontology, new InputStreamReader(theRealURIToRetrieve.toURL().openStream()), uri);
        }
        catch (MalformedURLException e) {
            throw new ParserException("URI is not a valid URL: ", (Exception)e, 2032);
        }
        catch (IOException e) {
            throw new ParserException("IO troubles when reading from URL: " + uri.toString(), (Exception)e, 2033);
        }
    }

    public void setOptions(Map options) {
        this.options = options;
    }

    public Map getOptions() {
        return this.options;
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            OWLConnection connection = null;
            try {
                connection = OWLManager.getOWLConnection();
            }
            catch (OWLException e) {
                System.err.println("Could not obtain connection:");
                System.err.println(e.getMessage());
                System.exit(-1);
            }
            OWLRDFParser parser = new OWLRDFParser();
            OWLRDFErrorHandler handler = new OWLRDFErrorHandler(){

                public void owlFullConstruct(int code, String message) throws SAXException {
                    System.out.println("FULL:    " + message);
                }

                public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                    System.out.println("FULL:    " + message);
                }

                public void error(String message) throws SAXException {
                    throw new SAXException(message.toString());
                }

                public void warning(String message) throws SAXException {
                    System.out.println("WARNING: " + message);
                }
            };
            parser.setOWLRDFErrorHandler(handler);
            URI uri = new URI(args[0]);
            OWLOntology onto = connection.createOntology(uri, uri);
            parser.parseOntology(onto, uri);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setImporting(boolean importing) {
        this.importing = importing;
    }
}

