/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.owl_rdf;

import edu.unika.aifb.rdf.api.syntax.RDFConsumer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owl.io.ParserException;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorConstants;
import org.semanticweb.owl.io.owl_rdf.OWLRDFErrorHandler;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.RDFSVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.RDFVocabularyAdapter;
import org.semanticweb.owl.io.vocabulary.XMLSchemaSimpleDatatypeVocabulary;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataEnumeration;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDeprecatableObject;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.change.AddAnnotationInstance;
import org.semanticweb.owl.model.change.AddClassAxiom;
import org.semanticweb.owl.model.change.AddDataPropertyInstance;
import org.semanticweb.owl.model.change.AddDataPropertyRange;
import org.semanticweb.owl.model.change.AddDataType;
import org.semanticweb.owl.model.change.AddDomain;
import org.semanticweb.owl.model.change.AddEntity;
import org.semanticweb.owl.model.change.AddEnumeration;
import org.semanticweb.owl.model.change.AddEquivalentClass;
import org.semanticweb.owl.model.change.AddImport;
import org.semanticweb.owl.model.change.AddIndividualAxiom;
import org.semanticweb.owl.model.change.AddIndividualClass;
import org.semanticweb.owl.model.change.AddInverse;
import org.semanticweb.owl.model.change.AddObjectPropertyInstance;
import org.semanticweb.owl.model.change.AddObjectPropertyRange;
import org.semanticweb.owl.model.change.AddPropertyAxiom;
import org.semanticweb.owl.model.change.AddSuperClass;
import org.semanticweb.owl.model.change.ChangeVisitor;
import org.semanticweb.owl.model.change.OntologyChange;
import org.semanticweb.owl.model.change.SetDeprecated;
import org.semanticweb.owl.model.change.SetFunctional;
import org.semanticweb.owl.model.change.SetInverseFunctional;
import org.semanticweb.owl.model.change.SetLogicalURI;
import org.semanticweb.owl.model.change.SetSymmetric;
import org.semanticweb.owl.model.change.SetTransitive;
import org.semanticweb.owl.util.OWLConnection;
import org.xml.sax.SAXException;

public class OWLConsumer
implements RDFConsumer,
OWLRDFErrorConstants {
    OWLRDFParser myParser = null;
    static final int UNSET = -1;
    static final int ONEOF = 0;
    static final int UNION = 1;
    static final int INTERSECTION = 2;
    static final int COMPLEMENT = 3;
    static final int RESTRICTION = 4;
    static final int ALL = 10;
    static final int SOME = 11;
    static final int HASVALUE = 12;
    static final int DATAHASVALUE = 13;
    static final int MIN = 14;
    static final int MAX = 15;
    static final int CARD = 16;
    static final int CLASS = 17;
    static final int LIST = 18;
    static final BigInteger MAXCARDASBIGINTEGER = new BigInteger(new Integer(Integer.MAX_VALUE).toString());
    OWLConnection connection;
    OWLOntology onto = null;
    OWLDataFactory factory = null;
    static Logger logger = Logger.getLogger((Class)OWLConsumer.class);
    static Logger tripleLogger = Logger.getLogger((String)(OWLConsumer.class.getName() + "Triples"));
    static Logger parseMessageLogger = Logger.getLogger((String)(OWLConsumer.class.getName() + "Parsing"));
    static Logger progressLogger = Logger.getLogger((String)(OWLConsumer.class.getName() + "Progress"));
    protected int tripleCount = 0;
    protected static int tripleCountChunk = 5000;
    protected Map stringsToURIs;
    HashSet definitelyOntologies = new HashSet();
    HashSet owlClasses = new HashSet();
    HashSet owlIndividuals = new HashSet();
    HashSet owlOntologyProperties = new HashSet();
    HashSet rdfsClasses = new HashSet();
    HashSet rdfProperties = new HashSet();
    HashMap rdfTypes = new HashMap();
    HashSet owlRestrictions = new HashSet();
    HashMap onProperty = new HashMap();
    HashMap allValues = new HashMap();
    HashMap someValues = new HashMap();
    HashMap hasValue = new HashMap();
    HashMap dataHasValue = new HashMap();
    HashMap minCardinality = new HashMap();
    HashMap maxCardinality = new HashMap();
    HashMap cardinality = new HashMap();
    HashSet lists = new HashSet();
    HashMap listFirst = new HashMap();
    HashMap listRest = new HashMap();
    HashSet allDifferent = new HashSet();
    HashMap distinctMembers = new HashMap();
    HashMap subClass = new HashMap();
    HashMap equivalentClass = new HashMap();
    HashMap subProperty = new HashMap();
    HashMap equivalentProperty = new HashMap();
    HashMap disjointWith = new HashMap();
    HashMap sameAs = new HashMap();
    HashMap differentFrom = new HashMap();
    HashMap owlInverseOf = new HashMap();
    HashSet arbitraryTriples = new HashSet();
    HashSet arbitraryDataTriples = new HashSet();
    HashMap translatedDescriptions = new HashMap();
    HashMap createdIndividuals = new HashMap();
    HashSet pendingTranslations = new HashSet();
    HashSet definitelyClasses = new HashSet();
    HashSet definitelyObjectProperties = new HashSet();
    HashSet definitelyAnnotationProperties = new HashSet();
    HashSet definitelyDataProperties = new HashSet();
    HashSet definitelyDatatypes = new HashSet();
    HashSet builtInClasses = new HashSet();
    HashSet assumedClasses = new HashSet();
    HashSet assumedDataProperties = new HashSet();
    HashSet assumedObjectProperties = new HashSet();
    HashSet untypedIndividuals = new HashSet();
    HashSet definitelyTypedIndividuals = new HashSet();
    HashSet assumedOntologies = new HashSet();
    boolean checkDefinitions = true;
    boolean importing = true;
    URI xsdString;
    URI rdfLiteral;
    URI xmlLiteral;
    String rdfNodeID;
    boolean ignoreAnnotationContent = false;
    boolean ignoreSchemaImports = false;
    boolean fixSameAs = false;
    Set xsdDatatypes;
    HashSet parsedURIs = new HashSet();
    HashSet bNodes = new HashSet();
    HashSet usedBNodes = new HashSet();
    URI ontologyLogicalURI;
    protected OWLRDFErrorHandler handler;
    OWLVocabularyAdapter v = OWLVocabularyAdapter.INSTANCE;
    RDFSVocabularyAdapter rdfsV = RDFSVocabularyAdapter.INSTANCE;
    RDFVocabularyAdapter rdfV = RDFVocabularyAdapter.INSTANCE;
    HashSet createdClasses = new HashSet();
    HashSet createdObjectProperties = new HashSet();
    HashSet createdDatatypeProperties = new HashSet();
    HashSet createdRestrictions = new HashSet();
    HashSet createdOntologies = new HashSet();
    HashSet createdAllDifferent = new HashSet();
    HashSet deprecatedProperties = new HashSet();
    HashSet badTriples = new HashSet();
    HashSet functionalProperties = new HashSet();
    HashSet deprecatedClasses = new HashSet();
    HashSet triples = new HashSet();
    HashSet usedTriples = new HashSet();
    HashSet literalTriples = new HashSet();
    HashMap triplesBySubject = new HashMap();
    HashMap triplesByObject = new HashMap();
    HashMap triplesByPredicateSubject = new HashMap();
    HashMap triplesByPredicateObject = new HashMap();
    HashMap triplesByPredicate = new HashMap();
    HashMap literalTriplesBySubject = new HashMap();

    public void setOWLRDFParser(OWLRDFParser p) {
        this.myParser = p;
    }

    public void setIgnoreAnnotationContent(boolean b) {
        if (b) {
            try {
                this.warning("Ignoring Annotation Content...");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ignoreAnnotationContent = b;
    }

    public void setIgnoreSchemaImports(boolean b) {
        if (b) {
            try {
                this.warning("Ignoring Schema Imports...");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.ignoreSchemaImports = b;
    }

    public void setFixSameAs(boolean b) {
        if (b) {
            try {
                this.warning("Fixing SameAs...");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fixSameAs = b;
    }

    protected void owlFullConstruct(int code, String message) throws SAXException {
        if (this.handler != null) {
            this.handler.owlFullConstruct(code, message);
        }
    }

    protected void owlFullConstruct(int code, String message, Object obj) throws SAXException {
        if (this.handler != null) {
            this.handler.owlFullConstruct(code, message, obj);
        }
    }

    protected void error(String message) throws SAXException {
        if (this.handler != null) {
            this.handler.error(message);
        }
    }

    protected void warning(String message) throws SAXException {
        if (this.handler != null) {
            this.handler.warning(message);
        }
    }

    public void setOWLRDFErrorHandler(OWLRDFErrorHandler h) {
        this.handler = h;
    }

    protected void rdfListToSet(URI start, Set mySet) throws SAXException {
        Triple listTriple = this.getTriple(start.toString(), this.v.getInstanceOf(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#List");
        if (listTriple != null) {
            this.usedTriples.add(listTriple);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)">in");
        }
        if (!start.toString().equals(this.v.getNil())) {
            Set rests = this.getObjects(start.toString(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
            if (rests.size() != 1) {
                this.error("Malformed List (multiple rests): " + start);
            }
            try {
                Triple nextTriple = (Triple)this.getSingletonObject(rests);
                this.usedTriples.add(nextTriple);
                URI next = nextTriple.object;
                Set firsts = this.getObjects(start.toString(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
                if (firsts.size() == 1) {
                    Triple firstTriple = (Triple)this.getSingletonObject(firsts);
                    this.usedTriples.add(firstTriple);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding " + firstTriple.object));
                    }
                    mySet.add(firstTriple.object);
                    if (next != null) {
                        this.rdfListToSet(next, mySet);
                    } else {
                        this.owlFullConstruct(2008, "Malformed List! " + start);
                    }
                } else {
                    firsts = this.getLiterals(start.toString(), "http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
                    if (firsts.size() == 1) {
                        LiteralTriple firstLiteralTriple = (LiteralTriple)this.getSingletonObject(firsts);
                        this.usedTriples.add(firstLiteralTriple);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Adding " + firstLiteralTriple.object));
                        }
                        String[] obs = new String[]{firstLiteralTriple.object, firstLiteralTriple.language, firstLiteralTriple.dataType};
                        mySet.add(obs);
                        if (next != null) {
                            this.rdfListToSet(next, mySet);
                        } else {
                            this.owlFullConstruct(2008, "Malformed List! " + start);
                        }
                    } else {
                        this.owlFullConstruct(2008, "Malformed List! " + start);
                    }
                }
            }
            catch (NoSuchElementException e) {
                this.owlFullConstruct(2008, "Malformed List! " + start);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"<out");
        }
    }

    protected Set uriToClassSet(Set uriSet) throws SAXException {
        Iterator iter;
        HashSet<OWLDescription> result = new HashSet<OWLDescription>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"---");
            iter = uriSet.iterator();
            while (iter.hasNext()) {
                logger.debug(iter.next());
            }
            logger.debug((Object)"---");
        }
        iter = uriSet.iterator();
        while (iter.hasNext()) {
            URI element = (URI)iter.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("XX: " + element));
            }
            OWLDescription d = this.translateDescription(element);
            this.checkAndConsumeBNode(element);
            result.add(d);
        }
        return result;
    }

    public Set uriToIndividualSet(Set uriSet) throws SAXException {
        HashSet<OWLIndividual> result = new HashSet<OWLIndividual>();
        Iterator iter = uriSet.iterator();
        while (iter.hasNext()) {
            URI element = (URI)iter.next();
            OWLIndividual i = this.translateIndividual(element);
            result.add(i);
        }
        return result;
    }

    public OWLConsumer(OWLOntology onto) throws OWLException {
        this.stringsToURIs = new HashMap();
        this.onto = onto;
        this.factory = onto.getOWLDataFactory();
        this.setOWLRDFErrorHandler(new OWLRDFErrorHandler(){

            public void owlFullConstruct(int code, String message, Object obj) throws SAXException {
                parseMessageLogger.warn((Object)message);
            }

            public void owlFullConstruct(int code, String message) throws SAXException {
                parseMessageLogger.warn((Object)message);
            }

            public void error(String message) throws SAXException {
                parseMessageLogger.error((Object)message);
            }

            public void warning(String message) throws SAXException {
                parseMessageLogger.warn((Object)message);
            }
        });
        try {
            URI t = this.newURI(OWLVocabularyAdapter.INSTANCE.getThing());
            this.definitelyClasses.add(t);
            this.builtInClasses.add(t);
            URI nt = this.newURI(OWLVocabularyAdapter.INSTANCE.getNothing());
            this.definitelyClasses.add(nt);
            this.builtInClasses.add(nt);
        }
        catch (URISyntaxException ex) {
            System.err.println("Error in creating OWL vocabulary!" + ex.getMessage());
        }
        try {
            String p;
            Iterator it = OWLVocabularyAdapter.INSTANCE.getAnnotationProperties().iterator();
            while (it.hasNext()) {
                p = (String)it.next();
                URI ap = this.newURI(p);
                if (this.definitelyAnnotationProperties.contains(ap)) continue;
                this.definitelyAnnotationProperties.add(ap);
            }
            it = OWLVocabularyAdapter.INSTANCE.getOntologyProperties().iterator();
            while (it.hasNext()) {
                p = (String)it.next();
                this.owlOntologyProperties.add(this.newURI(p));
            }
            URI u = this.newURI(OWLVocabularyAdapter.INSTANCE.getThing());
            this.translatedDescriptions.put(u, this.factory.getOWLThing());
            u = this.newURI(OWLVocabularyAdapter.INSTANCE.getNothing());
            this.translatedDescriptions.put(u, this.factory.getOWLNothing());
            this.xsdString = this.newURI("http://www.w3.org/2001/XMLSchema#string");
            this.definitelyDatatypes.add(this.xsdString);
            this.rdfLiteral = this.newURI(RDFSVocabularyAdapter.INSTANCE.getLiteral());
            this.definitelyDatatypes.add(this.rdfLiteral);
            this.xmlLiteral = this.newURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
            this.definitelyDatatypes.add(this.xmlLiteral);
            this.xsdDatatypes = XMLSchemaSimpleDatatypeVocabulary.INSTANCE.getDatatypes();
            this.rdfNodeID = "http://www.w3.org/1999/02/22-rdf-syntax-ns#" + "nodeID";
        }
        catch (URISyntaxException ex) {
            System.err.println("Error in creating Vocabulary!" + ex.getMessage());
        }
        catch (OWLException ex) {
            System.err.println("Error in creating Thing/Nothing!" + ex.getMessage());
        }
    }

    protected void setAssumptions(HashSet[] assumptions) {
        this.assumedClasses = assumptions[0];
        this.assumedDataProperties = assumptions[1];
        this.assumedObjectProperties = assumptions[2];
        this.definitelyClasses = assumptions[3];
        this.definitelyObjectProperties = assumptions[4];
        this.definitelyDataProperties = assumptions[5];
        this.untypedIndividuals = assumptions[6];
        this.definitelyTypedIndividuals = assumptions[7];
        this.parsedURIs = assumptions[8];
        this.rdfsClasses = assumptions[9];
        this.rdfProperties = assumptions[10];
        this.definitelyAnnotationProperties = assumptions[11];
        this.definitelyDatatypes = assumptions[12];
        this.definitelyOntologies = assumptions[13];
        this.assumedOntologies = assumptions[14];
    }

    protected void setCheckDefinitions(boolean b) {
        this.checkDefinitions = b;
    }

    public void startModel(String arg0) throws SAXException {
        logger.info((Object)("Start model " + arg0));
        this.parsedURIs.add(arg0);
    }

    protected OWLProperty getProperty(URI uri) throws OWLException {
        OWLObjectProperty ret = null;
        ret = this.onto.getObjectProperty(uri);
        if (ret == null) {
            ret = this.onto.getDataProperty(uri);
        }
        return ret;
    }

    public void endModel() throws SAXException {
        URI prop2;
        URI prop1;
        OWLDisjointClassesAxiom ax;
        Iterator iter;
        Object triple;
        Iterator it;
        URI disj2;
        URI disj1;
        Iterator it2;
        AddClassAxiom ac;
        OWLEquivalentClassesAxiom ax2;
        OWLDescription d;
        URI descURI;
        Iterator descIt;
        HashSet<OWLDescription> descriptionSet;
        Object key;
        Iterator keys;
        OWLAnd desc;
        OWLObjectProperty entity;
        SetDeprecated oc;
        Triple objectCharacteristic;
        URI uri;
        Triple triple2;
        this.usedTriples = new HashSet();
        Set workingTriples = null;
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getOntology());
        progressLogger.info((Object)("Ontologies: " + workingTriples.size()));
        boolean foundLogicalURI = false;
        Iterator it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OWLOntology: " + triple2.subject));
            }
            uri = triple2.subject;
            this.definitelyOntologies.add(uri);
            if (this.assumedOntologies.contains(uri)) {
                this.assumedOntologies.remove(uri);
            }
            boolean theOne = !this.isObject(uri);
            if (!(theOne = theOne || workingTriples.size() == 1)) continue;
            if (!foundLogicalURI) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Logical URI: " + uri));
                }
                this.ontologyLogicalURI = uri;
                foundLogicalURI = true;
                try {
                    SetLogicalURI slu = new SetLogicalURI(this.onto, uri, null);
                    this.applyChange((OntologyChange)slu);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
                continue;
            }
            this.warning("Cannot determine what the logical URI of this ontology should be.\nMultiple owl:Ontology nodes are present.\nChoosing: " + this.ontologyLogicalURI + " as the logical URI.");
        }
        if (this.ontologyLogicalURI == null) {
            try {
                this.warning("No Logical URI can be determined. Using physical URI: " + this.onto.getPhysicalURI());
                this.ontologyLogicalURI = this.onto.getPhysicalURI();
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getClass_());
        progressLogger.info((Object)("Classes: " + workingTriples.size()));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OWLClass: " + triple2.subject));
            }
            uri = triple2.subject;
            this.definitelyClasses.add(uri);
            if (this.isAnonymousNode(uri.toString())) continue;
            OWLClass entity2 = this.createClass(this.onto, uri);
            this.assumedClasses.remove(uri);
            if (this.tripleExists(uri.toString(), this.v.getInstanceOf(), this.v.getDeprecatedClass())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Deprecated Class: " + uri));
                }
                try {
                    SetDeprecated se = new SetDeprecated(this.onto, (OWLDeprecatableObject)entity2, true, null);
                    this.applyChange((OntologyChange)se);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            this.translatedDescriptions.put(uri, entity2);
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getObjectProperty());
        progressLogger.info((Object)("ObjectProperties: " + workingTriples.size()));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            OWLObjectProperty entity3 = this.createObjectProperty(this.onto, uri);
            this.definitelyObjectProperties.add(uri);
            this.assumedObjectProperties.remove(uri);
            objectCharacteristic = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getDeprecatedProperty());
            if (objectCharacteristic != null) {
                this.usedTriples.add(objectCharacteristic);
                try {
                    oc = new SetDeprecated(this.onto, (OWLDeprecatableObject)entity3, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            if ((objectCharacteristic = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getFunctionalProperty())) != null) {
                this.usedTriples.add(objectCharacteristic);
                try {
                    oc = new SetFunctional(this.onto, (OWLProperty)entity3, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            if ((objectCharacteristic = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getInverseFunctionalProperty())) != null) {
                this.usedTriples.add(objectCharacteristic);
                try {
                    oc = new SetInverseFunctional(this.onto, entity3, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            if ((objectCharacteristic = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getTransitive())) != null) {
                this.usedTriples.add(objectCharacteristic);
                try {
                    oc = new SetTransitive(this.onto, entity3, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            if ((objectCharacteristic = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getSymmetricProperty())) == null) continue;
            this.usedTriples.add(objectCharacteristic);
            try {
                oc = new SetSymmetric(this.onto, entity3, true, null);
                this.applyChange((OntologyChange)oc);
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getDatatypeProperty());
        progressLogger.info((Object)("DataProperties: " + workingTriples.size()));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            OWLDataProperty entity4 = this.createDataProperty(this.onto, uri);
            this.definitelyDataProperties.add(uri);
            this.assumedDataProperties.remove(uri);
            objectCharacteristic = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getDeprecatedProperty());
            if (objectCharacteristic != null) {
                this.usedTriples.add(objectCharacteristic);
                try {
                    oc = new SetDeprecated(this.onto, (OWLDeprecatableObject)entity4, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            if ((objectCharacteristic = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getFunctionalProperty())) != null) {
                this.usedTriples.add(objectCharacteristic);
                try {
                    oc = new SetFunctional(this.onto, (OWLProperty)entity4, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            if ((objectCharacteristic = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getInverseFunctionalProperty())) == null) continue;
            this.usedTriples.add(objectCharacteristic);
            this.owlFullConstruct(2009, "Data Properties cannot be inverse functional: " + uri, uri);
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getFunctionalProperty());
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            try {
                OWLDataProperty dp;
                OWLObjectProperty op = this.onto.getObjectProperty(uri);
                if (op != null || (dp = this.onto.getDataProperty(uri)) != null) continue;
                this.owlFullConstruct(2010, "Functional Property " + uri + " unspecified", uri);
                OWLObjectProperty entity5 = this.createObjectProperty(this.onto, uri);
                this.definitelyObjectProperties.add(uri);
                this.assumedObjectProperties.remove(uri);
                SetFunctional oc2 = new SetFunctional(this.onto, (OWLProperty)entity5, true, null);
                this.applyChange((OntologyChange)oc2);
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getInverseFunctionalProperty());
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            if (this.usedTriples.contains(triple2)) {
                logger.debug((Object)("Used IFP triple: " + triple2));
                continue;
            }
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            try {
                OWLObjectProperty op = this.onto.getObjectProperty(uri);
                if (op != null) continue;
                entity = this.createObjectProperty(this.onto, uri);
                this.definitelyObjectProperties.add(uri);
                this.assumedObjectProperties.remove(uri);
                try {
                    oc = new SetInverseFunctional(this.onto, entity, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getSymmetricProperty());
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            try {
                OWLObjectProperty op = this.onto.getObjectProperty(uri);
                if (op != null) continue;
                entity = this.createObjectProperty(this.onto, uri);
                this.definitelyObjectProperties.add(uri);
                this.assumedObjectProperties.remove(uri);
                try {
                    oc = new SetSymmetric(this.onto, entity, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getTransitive());
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            try {
                OWLObjectProperty op = this.onto.getObjectProperty(uri);
                if (op != null) continue;
                entity = this.createObjectProperty(this.onto, uri);
                this.definitelyObjectProperties.add(uri);
                this.assumedObjectProperties.remove(uri);
                try {
                    oc = new SetTransitive(this.onto, entity, true, null);
                    this.applyChange((OntologyChange)oc);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getAnnotationProperty());
        progressLogger.info((Object)("AnnotationProperties: " + workingTriples.size()));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            OWLAnnotationProperty entity6 = this.createAnnotationProperty(this.onto, uri);
            this.definitelyAnnotationProperties.add(uri);
            this.definitelyTypedIndividuals.add(uri);
            this.untypedIndividuals.remove(uri);
        }
        progressLogger.info((Object)(this.definitelyAnnotationProperties.size() + " AnnotationProperties present."));
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getDatatype());
        progressLogger.info((Object)("Datatypes: " + workingTriples.size()));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            OWLDataType entity7 = this.createDatatype(this.onto, uri);
        }
        workingTriples = this.getByPredicate(this.v.getImports());
        progressLogger.info((Object)("Imports: " + workingTriples.size()));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            uri = triple2.subject;
            if (!this.importing) continue;
            this.importOntology(this.onto, triple2.subject, triple2.object);
        }
        progressLogger.info((Object)"Defining Classes");
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getClass_());
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            AddEquivalentClass ae;
            triple2 = (Triple)it3.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Defining Class: " + triple2.subject));
            }
            if (this.isAnonymousNode((uri = triple2.subject).toString())) continue;
            OWLClass clazz = null;
            try {
                clazz = this.onto.getClass(uri);
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
            Set oneofs = this.getObjects(uri.toString(), this.v.getOneOf());
            Iterator ooit = oneofs.iterator();
            while (ooit.hasNext()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  one-of");
                }
                Triple ooTriple = (Triple)ooit.next();
                this.usedTriples.add(ooTriple);
                URI listStart = ooTriple.object;
                HashSet uriSet = new HashSet();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  listToSet");
                }
                this.rdfListToSet(listStart, uriSet);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  uriToIndividual");
                }
                Set individuals = this.uriToIndividualSet(uriSet);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("  adding " + individuals.size() + " individuals"));
                }
                try {
                    OWLEnumeration enum_ = this.factory.getOWLEnumeration(individuals);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"  made enum ");
                    }
                    AddEnumeration ae2 = new AddEnumeration(this.onto, clazz, enum_, null);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"  applying change ");
                    }
                    this.applyChange((OntologyChange)ae2);
                }
                catch (OWLException e) {
                    this.error(e.getMessage());
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"  done");
            }
            Set unionofs = this.getObjects(uri.toString(), this.v.getUnionOf());
            Iterator uoit = unionofs.iterator();
            while (uoit.hasNext()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  union");
                }
                Triple uoTriple = (Triple)uoit.next();
                this.usedTriples.add(uoTriple);
                URI listStart = uoTriple.object;
                HashSet uriSet = new HashSet();
                this.rdfListToSet(listStart, uriSet);
                Set classes = this.uriToClassSet(uriSet);
                try {
                    OWLOr desc2 = this.factory.getOWLOr(classes);
                    AddEquivalentClass ae3 = new AddEquivalentClass(this.onto, clazz, (OWLDescription)desc2, null);
                    this.applyChange((OntologyChange)ae3);
                }
                catch (OWLException e) {
                    this.error(e.getMessage());
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"  done");
            }
            Set intersectionOfs = this.getObjects(uri.toString(), this.v.getIntersectionOf());
            Iterator ioit = intersectionOfs.iterator();
            while (ioit.hasNext()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  intersection");
                }
                Triple ioTriple = (Triple)ioit.next();
                this.usedTriples.add(ioTriple);
                URI listStart = ioTriple.object;
                HashSet uriSet = new HashSet();
                this.rdfListToSet(listStart, uriSet);
                Set classes = this.uriToClassSet(uriSet);
                try {
                    desc = this.factory.getOWLAnd(classes);
                    ae = new AddEquivalentClass(this.onto, clazz, (OWLDescription)desc, null);
                    this.applyChange((OntologyChange)ae);
                }
                catch (OWLException e) {
                    this.error(e.getMessage());
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"  done");
            }
            Set complementOfs = this.getObjects(uri.toString(), this.v.getComplementOf());
            Iterator coit = complementOfs.iterator();
            while (coit.hasNext()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  complement");
                }
                Triple coTriple = (Triple)coit.next();
                this.usedTriples.add(coTriple);
                URI argURI = coTriple.object;
                this.checkAndConsumeBNode(argURI);
                OWLDescription arg = this.translateDescription(argURI);
                try {
                    desc = this.factory.getOWLNot(arg);
                    ae = new AddEquivalentClass(this.onto, clazz, (OWLDescription)desc, null);
                    this.applyChange((OntologyChange)ae);
                }
                catch (OWLException e) {
                    this.error(e.getMessage());
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"  done");
            }
        }
        workingTriples = this.getByPredicate(this.v.getInverseOf());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " Inverses"));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            this.createInverseOf(this.onto, triple2.subject, triple2.object);
        }
        workingTriples = this.getByPredicate(this.v.getDomain());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " Domains"));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            this.createDomain(this.onto, triple2.subject, triple2.object);
        }
        workingTriples = this.getByPredicate(this.v.getRange());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " Ranges"));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            triple2 = (Triple)it3.next();
            this.usedTriples.add(triple2);
            this.createRange(this.onto, triple2.subject, triple2.object);
        }
        workingTriples = this.getByPredicate(this.v.getSubClassOf());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " SubClass"));
        it3 = workingTriples.iterator();
        while (it3.hasNext()) {
            try {
                triple2 = (Triple)it3.next();
                this.usedTriples.add(triple2);
                URI subC = triple2.subject;
                URI superC = triple2.object;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(subC + " -> " + superC));
                }
                OWLDescription c = this.translateDescription(subC);
                OWLDescription d2 = this.translateDescription(superC);
                this.checkAndConsumeBNode(subC);
                this.checkAndConsumeBNode(superC);
                if (c == null || d2 == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Null Description: " + c + " " + d2));
                    }
                    this.error("SubClass problems: " + subC + " " + superC);
                }
                if (c instanceof OWLClass) {
                    AddSuperClass asc = new AddSuperClass(this.onto, (OWLClass)c, d2, null);
                    this.applyChange((OntologyChange)asc);
                    continue;
                }
                OWLSubClassAxiom ax3 = this.factory.getOWLSubClassAxiom(c, d2);
                AddClassAxiom ac2 = new AddClassAxiom(this.onto, (OWLClassAxiom)ax3, null);
                this.applyChange((OntologyChange)ac2);
            }
            catch (OWLException e) {
                this.error(e.getMessage());
            }
        }
        workingTriples = this.getByPredicate(this.v.getEquivalentClass());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " EquivalentClass"));
        HashMap<URI, Integer> equivalenceClasses = new HashMap<URI, Integer>();
        HashMap<Triple, Integer> triplesContributing = new HashMap<Triple, Integer>();
        int eqClasses = 0;
        Iterator it4 = workingTriples.iterator();
        while (it4.hasNext()) {
            Triple triple3 = (Triple)it4.next();
            this.usedTriples.add(triple3);
            URI eq1 = triple3.subject;
            URI eq2 = triple3.object;
            Integer eq1Key = (Integer)equivalenceClasses.get(eq1);
            Integer eq2Key = (Integer)equivalenceClasses.get(eq2);
            if (eq1Key == null && eq2Key == null) {
                Integer index = new Integer(eqClasses++);
                equivalenceClasses.put(eq1, index);
                equivalenceClasses.put(eq2, index);
                triplesContributing.put(triple3, index);
                continue;
            }
            if (eq1Key == null) {
                equivalenceClasses.put(eq1, eq2Key);
                triplesContributing.put(triple3, eq2Key);
                continue;
            }
            if (eq2Key == null) {
                equivalenceClasses.put(eq2, eq1Key);
                triplesContributing.put(triple3, eq1Key);
                continue;
            }
            triplesContributing.put(triple3, eq2Key);
            keys = equivalenceClasses.keySet().iterator();
            while (keys.hasNext()) {
                key = keys.next();
                if (!equivalenceClasses.get(key).equals(eq1Key)) continue;
                equivalenceClasses.put((URI)key, eq2Key);
            }
            keys = triplesContributing.keySet().iterator();
            while (keys.hasNext()) {
                key = keys.next();
                if (!triplesContributing.get(key).equals(eq1Key)) continue;
                triplesContributing.put((Triple)key, eq2Key);
            }
        }
        try {
            HashSet indices = new HashSet(equivalenceClasses.values());
            Iterator indexIt = indices.iterator();
            while (indexIt.hasNext()) {
                Triple trip;
                Object index = indexIt.next();
                HashSet trips = new HashSet();
                Iterator keys2 = triplesContributing.keySet().iterator();
                while (keys2.hasNext()) {
                    Object key2 = keys2.next();
                    if (!triplesContributing.get(key2).equals(index)) continue;
                    trips.add(key2);
                }
                boolean defo = true;
                Iterator tripIt = trips.iterator();
                while (tripIt.hasNext()) {
                    trip = (Triple)tripIt.next();
                    defo = defo && !this.isAnonymousNode(trip.subject.toString());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("DEFO: " + defo));
                }
                if (defo) {
                    tripIt = trips.iterator();
                    while (tripIt.hasNext()) {
                        trip = (Triple)tripIt.next();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Equiv: " + trip));
                        }
                        URI subj = trip.subject;
                        URI obj = trip.object;
                        OWLDescription lhs = this.translateDescription(subj);
                        OWLDescription rhs = this.translateDescription(obj);
                        this.checkAndConsumeBNode(obj);
                        AddEquivalentClass aec = new AddEquivalentClass(this.onto, (OWLClass)lhs, rhs, null);
                        this.applyChange((OntologyChange)aec);
                    }
                    continue;
                }
                HashSet eqs = new HashSet();
                keys = equivalenceClasses.keySet().iterator();
                while (keys.hasNext()) {
                    key = keys.next();
                    if (!equivalenceClasses.get(key).equals(index)) continue;
                    eqs.add(key);
                }
                descriptionSet = new HashSet<OWLDescription>();
                descIt = eqs.iterator();
                while (descIt.hasNext()) {
                    descURI = (URI)descIt.next();
                    d = this.translateDescription(descURI);
                    this.checkAndConsumeBNode(descURI);
                    descriptionSet.add(d);
                }
                ax2 = this.factory.getOWLEquivalentClassesAxiom(descriptionSet);
                ac = new AddClassAxiom(this.onto, (OWLClassAxiom)ax2, null);
                this.applyChange((OntologyChange)ac);
            }
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
        workingTriples = this.getByPredicate(this.v.getDisjointWith());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " DisjointWith"));
        boolean stillWorkToDo = false;
        HashSet<URI> nodesAlreadyDone = new HashSet<URI>();
        URI found = null;
        HashMap<URI, HashSet<URI>> multiDisjoints = new HashMap<URI, HashSet<URI>>();
        do {
            found = null;
            it2 = workingTriples.iterator();
            while (it2.hasNext()) {
                Triple triple4 = (Triple)it2.next();
                this.usedTriples.add(triple4);
                disj1 = triple4.subject;
                disj2 = triple4.object;
                if (!nodesAlreadyDone.contains(disj1) && this.isAnonymousNode(disj1.toString())) {
                    found = disj1;
                }
                if (nodesAlreadyDone.contains(disj2) || !this.isAnonymousNode(disj2.toString())) continue;
                found = disj2;
            }
            if (found == null) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + found));
            }
            nodesAlreadyDone.add(found);
            HashSet<URI> reachableNodes = new HashSet<URI>();
            reachableNodes.add(found);
            boolean somethingChanged = false;
            do {
                somethingChanged = false;
                it = workingTriples.iterator();
                while (it.hasNext()) {
                    triple = (Triple)it.next();
                    URI disj12 = ((Triple)triple).subject;
                    URI disj22 = ((Triple)triple).object;
                    if (reachableNodes.contains(disj12) && !reachableNodes.contains(disj22) && this.isAnonymousNode(disj12.toString())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Found Reachable " + disj22));
                        }
                        reachableNodes.add(disj22);
                        nodesAlreadyDone.add(disj22);
                        somethingChanged = true;
                    }
                    if (!reachableNodes.contains(disj22) || reachableNodes.contains(disj12) || !this.isAnonymousNode(disj22.toString())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found Reachable " + disj12));
                    }
                    reachableNodes.add(disj12);
                    nodesAlreadyDone.add(disj12);
                    somethingChanged = true;
                }
            } while (somethingChanged);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"--- disj ---");
                iter = reachableNodes.iterator();
                while (iter.hasNext()) {
                    logger.debug(iter.next());
                }
                logger.debug((Object)"+++ disj +++");
            }
            iter = reachableNodes.iterator();
            while (iter.hasNext()) {
                URI a = (URI)iter.next();
                Iterator iter2 = reachableNodes.iterator();
                while (iter2.hasNext()) {
                    URI b = (URI)iter2.next();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(a + " -?- " + b));
                    }
                    if (a == b) continue;
                    HashSet<URI> s = (HashSet<URI>)multiDisjoints.get(a);
                    if (s == null) {
                        s = new HashSet<URI>();
                        multiDisjoints.put(a, s);
                    }
                    s.add(b);
                    if (this.tripleExists(a.toString(), this.v.getDisjointWith(), b.toString()) || this.tripleExists(b.toString(), this.v.getDisjointWith(), a.toString())) continue;
                    this.owlFullConstruct(2011, "Badly constructed disjoint! Non complete subgraph involving bnodes. No edge between " + a + " and " + b);
                }
            }
            descriptionSet = new HashSet();
            descIt = reachableNodes.iterator();
            while (descIt.hasNext()) {
                descURI = (URI)descIt.next();
                d = this.translateDescription(descURI);
                this.checkAndConsumeBNode(descURI);
                descriptionSet.add(d);
            }
            try {
                ax2 = this.factory.getOWLDisjointClassesAxiom(descriptionSet);
                ac = new AddClassAxiom(this.onto, (OWLClassAxiom)ax2, null);
                this.applyChange((OntologyChange)ac);
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        } while (found != null);
        it2 = workingTriples.iterator();
        while (it2.hasNext()) {
            try {
                Triple triple5 = (Triple)it2.next();
                disj1 = triple5.subject;
                disj2 = triple5.object;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(disj1 + " || " + disj2));
                }
                Set multis = (Set)multiDisjoints.get(disj1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("multis: " + multis));
                }
                if (multis != null && multis.contains(disj2)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(disj1 + " != " + disj2));
                }
                OWLDescription c = this.translateDescription(disj1);
                this.checkAndConsumeBNode(disj1);
                OWLDescription d3 = this.translateDescription(disj2);
                this.checkAndConsumeBNode(disj2);
                if (c == null || d3 == null) {
                    this.error("Disjoint problems: " + disj1 + " " + disj2);
                }
                HashSet<OWLDescription> set = new HashSet<OWLDescription>(2, 1.0f);
                set.add(d3);
                set.add(c);
                ax = this.factory.getOWLDisjointClassesAxiom(set);
                AddClassAxiom ac3 = new AddClassAxiom(this.onto, (OWLClassAxiom)ax, null);
                this.applyChange((OntologyChange)ac3);
            }
            catch (OWLException e) {
                this.error(e.getMessage());
            }
        }
        workingTriples = this.getByPredicate(this.v.getSubPropertyOf());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " SubProperty"));
        it2 = workingTriples.iterator();
        while (it2.hasNext()) {
            Triple triple6 = (Triple)it2.next();
            this.usedTriples.add(triple6);
            prop1 = triple6.subject;
            prop2 = triple6.object;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(prop1 + " -> " + prop2));
            }
            this.createSubProperty(this.onto, prop1, prop2);
        }
        workingTriples = this.getByPredicate(this.v.getEquivalentProperty());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " EquivalentProperty"));
        it2 = workingTriples.iterator();
        while (it2.hasNext()) {
            Triple triple7 = (Triple)it2.next();
            this.usedTriples.add(triple7);
            prop1 = triple7.subject;
            prop2 = triple7.object;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(prop1 + " == " + prop2));
            }
            this.createEquivalentProperty(this.onto, prop1, prop2);
        }
        workingTriples = this.getByPredicate(this.v.getInstanceOf());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " Types"));
        it2 = workingTriples.iterator();
        while (it2.hasNext()) {
            try {
                Triple triple8 = (Triple)it2.next();
                if (this.languageMachineryType(triple8.object)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Ignoring: " + triple8));
                    continue;
                }
                this.usedTriples.add(triple8);
                URI indURI = triple8.subject;
                URI typeURI = triple8.object;
                this.checkAndConsumeBNode(typeURI);
                if (this.definitelyOntologies.contains(indURI)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(indURI + "rdf:type " + typeURI));
                }
                OWLIndividual ind = this.translateIndividual(indURI);
                desc = this.translateDescription(typeURI);
                AddIndividualClass aic = new AddIndividualClass(this.onto, ind, (OWLDescription)desc, null);
                this.applyChange((OntologyChange)aic);
                this.definitelyTypedIndividuals.add(indURI);
                this.untypedIndividuals.remove(indURI);
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.v.getAllDifferent());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " AllDifferent"));
        it2 = workingTriples.iterator();
        while (it2.hasNext()) {
            Triple triple9 = (Triple)it2.next();
            this.usedTriples.add(triple9);
            URI uri2 = triple9.subject;
            Set distincts = this.getObjects(uri2.toString(), this.v.getDistinctMembers());
            if (distincts.size() == 0) {
                this.owlFullConstruct(2021, "AllDifferent " + uri2 + " with no distinctMembers");
                continue;
            }
            if (distincts.size() > 1) {
                this.owlFullConstruct(2021, "AllDifferent " + uri2 + " with multiple distinctMembers");
                continue;
            }
            Triple disTriple = (Triple)this.getSingletonObject(distincts);
            this.usedTriples.add(disTriple);
            URI listStart = disTriple.object;
            HashSet uriSet = new HashSet();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"  listToSet");
            }
            this.rdfListToSet(listStart, uriSet);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"  uriToIndividual");
            }
            Set individuals = this.uriToIndividualSet(uriSet);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("  adding " + individuals.size() + " individuals"));
            }
            try {
                ax = this.factory.getOWLDifferentIndividualsAxiom(individuals);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  made axiom ");
                }
                AddIndividualAxiom aia = new AddIndividualAxiom(this.onto, (OWLIndividualAxiom)ax, null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"  applying change ");
                }
                this.applyChange((OntologyChange)aia);
            }
            catch (OWLException e) {
                this.error(e.getMessage());
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)"  done");
        }
        workingTriples = this.getByPredicate(this.v.getSameAs());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " SameAs"));
        it2 = workingTriples.iterator();
        while (it2.hasNext()) {
            Triple triple10 = (Triple)it2.next();
            this.usedTriples.add(triple10);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(triple10.subject + " === " + triple10.object));
            }
            this.createSameIndividualAs(this.onto, triple10.subject, triple10.object);
        }
        workingTriples = this.getByPredicate(this.v.getDifferentFrom());
        progressLogger.info((Object)("Processing " + workingTriples.size() + " DifferentFrom"));
        it2 = workingTriples.iterator();
        while (it2.hasNext()) {
            Triple triple11 = (Triple)it2.next();
            this.usedTriples.add(triple11);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(triple11.subject + " =/= " + triple11.object));
            }
            this.createDifferentFrom(this.onto, triple11.subject, triple11.object);
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), this.rdfsV.getProperty());
        Iterator iter2 = workingTriples.iterator();
        while (iter2.hasNext()) {
            Triple triple12 = (Triple)iter2.next();
            this.usedTriples.add(triple12);
            this.rdfProperties.add(triple12.subject);
            this.warning("Possibly using wrong vocabulary (rdf:Property instead of owl:[Object|Data]Property)\n\t" + triple12.subject);
        }
        workingTriples = this.getSubjects(this.v.getInstanceOf(), "http://www.w3.org/2000/01/rdf-schema#Class");
        iter2 = workingTriples.iterator();
        while (iter2.hasNext()) {
            Triple triple13 = (Triple)iter2.next();
            this.usedTriples.add(triple13);
            this.rdfsClasses.add(triple13.subject);
            this.warning("Possibly using wrong vocabulary (rdfs:Class instead of owl:Class)\n\t" + triple13.subject);
        }
        it2 = this.bNodes.iterator();
        while (it2.hasNext()) {
            URI bnode = (URI)it2.next();
            if (this.usedBNodes.contains(bnode) || !this.tripleExists(bnode.toString(), this.v.getInstanceOf(), this.v.getClass_()) && !this.tripleExists(bnode.toString(), this.v.getInstanceOf(), this.v.getRestriction())) continue;
            OWLDescription desc3 = this.translateDescription(bnode);
            this.checkAndConsumeBNode(bnode);
            try {
                HashSet<OWLDescription> set = new HashSet<OWLDescription>();
                set.add(desc3);
                OWLEquivalentClassesAxiom ax4 = this.factory.getOWLEquivalentClassesAxiom(set);
                AddClassAxiom ac4 = new AddClassAxiom(this.onto, (OWLClassAxiom)ax4, null);
                this.applyChange((OntologyChange)ac4);
            }
            catch (OWLException e) {
                this.error(e.getMessage());
            }
        }
        this.additionalParsingHook();
        HashSet<Triple> remainingTriples = new HashSet<Triple>();
        Iterator it5 = this.triples.iterator();
        while (it5.hasNext()) {
            Triple triple14 = (Triple)it5.next();
            if (this.usedTriples.contains(triple14) || triple14.predicate.toString().equals(this.v.getInstanceOf()) && this.languageMachineryType(triple14.object)) continue;
            remainingTriples.add(triple14);
        }
        progressLogger.info((Object)(remainingTriples.size() + " Triples left"));
        HashMap<URI, HashSet<URI>> bNodeConnectedness = new HashMap<URI, HashSet<URI>>();
        this.tripleCount = 0;
        iter = remainingTriples.iterator();
        while (iter.hasNext()) {
            ++this.tripleCount;
            if (tripleLogger.isInfoEnabled() && this.tripleCount % tripleCountChunk == 0) {
                tripleLogger.info((Object)Integer.toString(this.tripleCount));
            }
            triple = (Triple)iter.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(((Triple)triple).subject + "-" + ((Triple)triple).predicate + "-" + ((Triple)triple).object));
            }
            if (this.definitelyAnnotationProperties.contains(((Triple)triple).predicate)) {
                this.createAnnotationInstance(this.onto, ((Triple)triple).subject, ((Triple)triple).predicate, ((Triple)triple).object);
                continue;
            }
            if (this.owlOntologyProperties.contains(((Triple)triple).predicate)) {
                URI culprit;
                if (((Triple)triple).predicate.toString().equals(this.v.getImports())) continue;
                if (!this.definitelyOntologies.contains(((Triple)triple).subject)) {
                    culprit = ((Triple)triple).subject;
                    if (this.isAnonymousNode(culprit.toString())) {
                        culprit = null;
                    }
                    this.owlFullConstruct(2005, "Untyped Ontology: " + ((Triple)triple).subject, culprit);
                }
                if (this.definitelyOntologies.contains(((Triple)triple).object)) continue;
                culprit = ((Triple)triple).subject;
                if (this.isAnonymousNode(culprit.toString())) {
                    culprit = null;
                }
                this.owlFullConstruct(2005, "Untyped Ontology: " + ((Triple)triple).object, culprit);
                continue;
            }
            this.createPropertyInstance(this.onto, ((Triple)triple).subject, ((Triple)triple).predicate, ((Triple)triple).object);
            if (!this.isAnonymousNode(((Triple)triple).subject.toString()) || !this.isAnonymousNode(((Triple)triple).object.toString())) continue;
            HashSet<URI> s = (HashSet<URI>)bNodeConnectedness.get(((Triple)triple).subject);
            if (s == null) {
                s = new HashSet<URI>();
                bNodeConnectedness.put(((Triple)triple).subject, s);
            }
            s.add(((Triple)triple).object);
        }
        Iterator bNodeIt = bNodeConnectedness.keySet().iterator();
        while (bNodeIt.hasNext()) {
            HashSet reachables;
            URI bNode = (URI)bNodeIt.next();
            Set newReachables = (Set)bNodeConnectedness.get(bNode);
            do {
                reachables = new HashSet(newReachables);
                Iterator reachIt = reachables.iterator();
                while (reachIt.hasNext()) {
                    Object reach = reachIt.next();
                    newReachables.add(reach);
                    Set reachReach = (Set)bNodeConnectedness.get(reach);
                    if (reachReach == null) continue;
                    newReachables.addAll(reachReach);
                }
            } while (reachables.size() != newReachables.size());
            if (!reachables.contains(bNode)) continue;
            this.owlFullConstruct(2012, "Cycle in bNodes! " + bNode);
        }
        remainingTriples = new HashSet();
        it = this.literalTriples.iterator();
        while (it.hasNext()) {
            Object t = it.next();
            if (this.usedTriples.contains(t)) continue;
            remainingTriples.add((Triple)t);
        }
        progressLogger.info((Object)(remainingTriples.size() + " Data Triples left"));
        this.tripleCount = 0;
        iter = remainingTriples.iterator();
        while (iter.hasNext()) {
            ++this.tripleCount;
            if (tripleLogger.isInfoEnabled() && this.tripleCount % tripleCountChunk == 0) {
                tripleLogger.info((Object)Integer.toString(this.tripleCount));
            }
            triple = (LiteralTriple)iter.next();
            URI subject = ((LiteralTriple)triple).subject;
            URI predicate = ((LiteralTriple)triple).predicate;
            String object = ((LiteralTriple)triple).object;
            String datatype = ((LiteralTriple)triple).dataType;
            String language = ((LiteralTriple)triple).language;
            if (language == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(subject + "-" + predicate + "-" + object + "^^" + datatype));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)(subject + "-" + predicate + "-" + object + "@" + language));
            }
            if (this.definitelyAnnotationProperties.contains(predicate)) {
                try {
                    URI dt = null;
                    String lang = null;
                    if (language != null) {
                        lang = language;
                    } else {
                        try {
                            if (datatype != null) {
                                dt = this.newURI(datatype);
                            }
                        }
                        catch (URISyntaxException e) {
                            // empty catch block
                        }
                    }
                    if (this.ignoreAnnotationContent) continue;
                    OWLDataValue dv = this.factory.getOWLConcreteData(dt, lang, (Object)object);
                    this.createAnnotationInstance(this.onto, subject, predicate, dv);
                }
                catch (OWLException ex) {
                    this.error(ex.getMessage());
                }
                continue;
            }
            if (this.owlOntologyProperties.contains(predicate)) continue;
            this.createDataPropertyInstance(this.onto, subject, predicate, datatype, language, object);
        }
        if (this.checkDefinitions) {
            this.checkForUndefinedOntologies();
            this.checkForUndefinedObjectProperties();
            this.checkForUndefinedDataProperties();
            this.checkForUndefinedClasses();
            this.checkForUntypedIndividuals();
            this.checkForRDFProperties();
            this.checkForRDFSClasses();
            this.checkForOneOfs();
            this.checkBooleans();
        }
        this.checkForMalformedLists();
        progressLogger.info((Object)"Parsing Complete");
        this.releaseTripleModel();
    }

    protected OWLDescription translateDescription(URI uri) throws SAXException {
        OWLDescription tryThis;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Translating: " + uri));
        }
        if (uri.toString().equals(OWLVocabularyAdapter.INSTANCE.getThing())) {
            try {
                return this.factory.getOWLThing();
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        if (uri.toString().equals(OWLVocabularyAdapter.INSTANCE.getNothing())) {
            try {
                return this.factory.getOWLNothing();
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Checking translations...");
        }
        if ((tryThis = (OWLDescription)this.translatedDescriptions.get(uri)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + tryThis));
            }
            return tryThis;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Not Found ");
        }
        if (this.pendingTranslations.contains(uri)) {
            this.owlFullConstruct(2011, "Cycle in descriptions! " + uri);
            OWLClass cl = this.getAndAssumeOWLClass(uri);
            this.translatedDescriptions.put(uri, cl);
            this.pendingTranslations.remove(uri);
            return cl;
        }
        this.pendingTranslations.add(uri);
        URI dataUri = null;
        try {
            dataUri = this.newURI("http://to.do.com/");
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        int count = 0;
        int selector = -1;
        Set s = this.getObjects(uri.toString(), this.v.getOneOf());
        if (!s.isEmpty()) {
            selector = 0;
            count += s.size();
        }
        if (!(s = this.getObjects(uri.toString(), this.v.getUnionOf())).isEmpty()) {
            selector = 1;
            count += s.size();
        }
        if (!(s = this.getObjects(uri.toString(), this.v.getIntersectionOf())).isEmpty()) {
            selector = 2;
            count += s.size();
        }
        if (!(s = this.getObjects(uri.toString(), this.v.getComplementOf())).isEmpty()) {
            selector = 3;
            count += s.size();
        }
        if (this.tripleExists(uri.toString(), this.v.getInstanceOf(), this.v.getRestriction())) {
            selector = 4;
            count = count++;
        }
        if (count > 1) {
            this.owlFullConstruct(2013, "Multiple definitions of an anonymous class " + uri + ". Further messages may be misleading....");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Translating " + uri + " " + selector));
        }
        block7 : switch (selector) {
            case -1: {
                break;
            }
            case 0: {
                Set oneofs = this.getObjects(uri.toString(), this.v.getOneOf());
                Triple ooTriple = (Triple)this.getSingletonObject(oneofs);
                this.usedTriples.add(ooTriple);
                URI listStart = ooTriple.object;
                HashSet uriSet = new HashSet();
                this.rdfListToSet(listStart, uriSet);
                Set individuals = this.uriToIndividualSet(uriSet);
                try {
                    OWLEnumeration desc = this.factory.getOWLEnumeration(individuals);
                    this.translatedDescriptions.put(uri, desc);
                    this.pendingTranslations.remove(uri);
                    this.definitelyClasses.add(uri);
                    return desc;
                }
                catch (OWLException e) {
                    this.error(e.getMessage());
                    break;
                }
            }
            case 1: {
                Set unions = this.getObjects(uri.toString(), this.v.getUnionOf());
                Triple uoTriple = (Triple)this.getSingletonObject(unions);
                this.usedTriples.add(uoTriple);
                URI listStart = uoTriple.object;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Union: " + uri));
                }
                HashSet uriSet = new HashSet();
                this.rdfListToSet(listStart, uriSet);
                Set classes = this.uriToClassSet(uriSet);
                try {
                    OWLOr desc = this.factory.getOWLOr(classes);
                    this.translatedDescriptions.put(uri, desc);
                    this.pendingTranslations.remove(uri);
                    this.definitelyClasses.add(uri);
                    return desc;
                }
                catch (OWLException e) {
                    this.error(e.getMessage());
                    break;
                }
            }
            case 2: {
                Set intersections = this.getObjects(uri.toString(), this.v.getIntersectionOf());
                Triple ioTriple = (Triple)this.getSingletonObject(intersections);
                this.usedTriples.add(ioTriple);
                URI listStart = ioTriple.object;
                HashSet uriSet = new HashSet();
                this.rdfListToSet(listStart, uriSet);
                Set classes = this.uriToClassSet(uriSet);
                try {
                    OWLAnd desc = this.factory.getOWLAnd(classes);
                    this.translatedDescriptions.put(uri, desc);
                    this.pendingTranslations.remove(uri);
                    this.definitelyClasses.add(uri);
                    return desc;
                }
                catch (OWLException e) {
                    this.error(e.getMessage());
                    break;
                }
            }
            case 3: {
                Set complements = this.getObjects(uri.toString(), this.v.getComplementOf());
                Triple coTriple = (Triple)this.getSingletonObject(complements);
                this.usedTriples.add(coTriple);
                URI argURI = coTriple.object;
                OWLDescription arg = this.translateDescription(argURI);
                this.checkAndConsumeBNode(argURI);
                try {
                    OWLNot desc = this.factory.getOWLNot(arg);
                    this.translatedDescriptions.put(uri, desc);
                    this.pendingTranslations.remove(uri);
                    this.definitelyClasses.add(uri);
                    return desc;
                }
                catch (OWLException e) {
                    this.error(e.getMessage());
                    break;
                }
            }
            case 4: {
                Set onProps;
                Triple resTriple = this.getTriple(uri.toString(), this.v.getInstanceOf(), this.v.getRestriction());
                if (resTriple != null) {
                    this.usedTriples.add(resTriple);
                }
                if ((onProps = this.getObjects(uri.toString(), this.v.getOnProperty())).size() == 0) {
                    this.owlFullConstruct(2014, "Restriction with no onProperty: " + uri);
                } else if (onProps.size() > 1) {
                    this.owlFullConstruct(2014, "Restriction with multiple onProperty: " + uri);
                }
                Triple opTriple = (Triple)this.getSingletonObject(onProps);
                this.usedTriples.add(opTriple);
                URI prop = opTriple.object;
                int restrictionCount = 0;
                int restrictionSelector = -1;
                Set rs = this.getObjects(uri.toString(), this.v.getAllValuesFrom());
                if (!rs.isEmpty()) {
                    restrictionSelector = 10;
                    restrictionCount += rs.size();
                }
                if (!(rs = this.getObjects(uri.toString(), this.v.getSomeValuesFrom())).isEmpty()) {
                    restrictionSelector = 11;
                    restrictionCount += rs.size();
                }
                if (!(rs = this.getObjects(uri.toString(), this.v.getHasValue())).isEmpty()) {
                    restrictionSelector = 12;
                    restrictionCount += rs.size();
                }
                if (!(rs = this.getLiterals(uri.toString(), this.v.getHasValue())).isEmpty()) {
                    restrictionSelector = 13;
                    restrictionCount += rs.size();
                }
                if (!(rs = this.getLiterals(uri.toString(), this.v.getMinCardinality())).isEmpty()) {
                    restrictionSelector = 14;
                    restrictionCount += rs.size();
                }
                if (!(rs = this.getLiterals(uri.toString(), this.v.getMaxCardinality())).isEmpty()) {
                    restrictionSelector = 15;
                    restrictionCount += rs.size();
                }
                if (!(rs = this.getLiterals(uri.toString(), this.v.getCardinality())).isEmpty()) {
                    restrictionSelector = 16;
                    restrictionCount += rs.size();
                }
                if (restrictionCount > 1) {
                    this.owlFullConstruct(2014, "Malformed Restriction (multiple types) " + uri);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Translating Restriction: " + uri + " " + restrictionSelector));
                }
                switch (restrictionSelector) {
                    case -1: {
                        this.owlFullConstruct(2014, "Unknown RestrictionType " + uri);
                        break block7;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        Set trips;
                        if (this.definitelyObjectProperties.contains(prop)) {
                            OWLDescription desc = this.translateRestriction(uri, prop, restrictionSelector, true);
                            this.pendingTranslations.remove(uri);
                            this.definitelyClasses.add(uri);
                            return desc;
                        }
                        if (this.definitelyDataProperties.contains(prop)) {
                            OWLDescription desc = this.translateRestriction(uri, prop, restrictionSelector, false);
                            this.pendingTranslations.remove(uri);
                            this.definitelyClasses.add(uri);
                            return desc;
                        }
                        boolean guessItsAnObject = true;
                        if (restrictionSelector == 12) {
                            guessItsAnObject = true;
                        } else if (restrictionSelector == 13) {
                            guessItsAnObject = false;
                        } else if (restrictionSelector == 11) {
                            trips = this.getObjects(uri.toString(), this.v.getSomeValuesFrom());
                            Triple trip = (Triple)this.getSingletonObject(trips);
                            if (this.definitelyClasses.contains(trip.object)) {
                                guessItsAnObject = true;
                            } else if (this.definitelyDatatypes.contains(trip.object)) {
                                guessItsAnObject = false;
                            }
                        } else if (restrictionSelector == 10) {
                            trips = this.getObjects(uri.toString(), this.v.getAllValuesFrom());
                            Triple trip = (Triple)this.getSingletonObject(trips);
                            if (this.definitelyClasses.contains(trip.object)) {
                                guessItsAnObject = true;
                            } else if (this.definitelyDatatypes.contains(trip.object)) {
                                guessItsAnObject = false;
                            }
                        }
                        OWLDescription desc = this.translateRestriction(uri, prop, restrictionSelector, guessItsAnObject);
                        this.pendingTranslations.remove(uri);
                        this.definitelyClasses.add(uri);
                        return desc;
                    }
                    case 14: 
                    case 15: 
                    case 16: {
                        if (this.definitelyObjectProperties.contains(prop)) {
                            this.pendingTranslations.remove(uri);
                            this.definitelyClasses.add(uri);
                            return this.translateCardinalityRestriction(uri, prop, restrictionSelector, true);
                        }
                        if (this.definitelyDataProperties.contains(prop)) {
                            this.pendingTranslations.remove(uri);
                            this.definitelyClasses.add(uri);
                            return this.translateCardinalityRestriction(uri, prop, restrictionSelector, false);
                        }
                        this.pendingTranslations.remove(uri);
                        this.definitelyClasses.add(uri);
                        return this.translateCardinalityRestriction(uri, prop, restrictionSelector, true);
                    }
                }
                this.error(" TODO (Restriction) " + restrictionSelector);
                break;
            }
            default: {
                this.error(" TODO (Translation) " + selector);
            }
        }
        OWLClass cl = this.getAndAssumeOWLClass(uri);
        this.translatedDescriptions.put(uri, cl);
        this.pendingTranslations.remove(uri);
        return cl;
    }

    protected OWLDescription translateRestriction(URI uri, URI propURI, int type, boolean obj) throws SAXException {
        OWLDataSomeRestriction desc;
        block28: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Translating Restriction: " + uri + " " + propURI + " " + type + " " + obj));
            }
            desc = null;
            try {
                OWLObjectProperty prop;
                if (obj) {
                    prop = this.onto.getObjectProperty(propURI);
                    if (prop == null) {
                        prop = this.createObjectProperty(this.onto, propURI);
                        if (!this.definitelyObjectProperties.contains(propURI)) {
                            this.assumedObjectProperties.add(propURI);
                        }
                    }
                    URI filler = null;
                    if (type == 11) {
                        Set someTrips = this.getObjects(uri.toString(), this.v.getSomeValuesFrom());
                        Triple someTrip = (Triple)this.getSingletonObject(someTrips);
                        this.usedTriples.add(someTrip);
                        filler = someTrip.object;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Filler: " + filler));
                        }
                        OWLDescription fillerDesc = this.translateDescription(filler);
                        this.checkAndConsumeBNode(filler);
                        desc = this.factory.getOWLObjectSomeRestriction(prop, fillerDesc);
                    } else if (type == 10) {
                        Set allTrips = this.getObjects(uri.toString(), this.v.getAllValuesFrom());
                        Triple allTrip = (Triple)this.getSingletonObject(allTrips);
                        this.usedTriples.add(allTrip);
                        filler = allTrip.object;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Filler: " + filler));
                        }
                        OWLDescription fillerDesc = this.translateDescription(filler);
                        this.checkAndConsumeBNode(filler);
                        desc = this.factory.getOWLObjectAllRestriction(prop, fillerDesc);
                    } else if (type == 12) {
                        Set fillerTrips = this.getObjects(uri.toString(), this.v.getHasValue());
                        Triple fillerTrip = (Triple)this.getSingletonObject(fillerTrips);
                        this.usedTriples.add(fillerTrip);
                        filler = fillerTrip.object;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Filler: " + filler));
                        }
                        OWLIndividual ind = this.translateIndividual(filler);
                        desc = this.factory.getOWLObjectValueRestriction(prop, ind);
                    }
                    break block28;
                }
                prop = this.onto.getDataProperty(propURI);
                if (prop == null) {
                    prop = this.createDataProperty(this.onto, propURI);
                    if (!this.definitelyDataProperties.contains(propURI)) {
                        this.assumedDataProperties.add(propURI);
                    }
                }
                URI filler = null;
                if (type == 11) {
                    Set fillerTrips = this.getObjects(uri.toString(), this.v.getSomeValuesFrom());
                    Triple fillerTrip = (Triple)this.getSingletonObject(fillerTrips);
                    this.usedTriples.add(fillerTrip);
                    filler = fillerTrip.object;
                    OWLDataRange fillerType = this.translateDataRange(filler);
                    desc = this.factory.getOWLDataSomeRestriction((OWLDataProperty)prop, fillerType);
                    break block28;
                }
                if (type == 10) {
                    Set fillerTrips = this.getObjects(uri.toString(), this.v.getAllValuesFrom());
                    Triple fillerTrip = (Triple)this.getSingletonObject(fillerTrips);
                    this.usedTriples.add(fillerTrip);
                    filler = fillerTrip.object;
                    OWLDataRange fillerType = this.translateDataRange(filler);
                    desc = this.factory.getOWLDataAllRestriction((OWLDataProperty)prop, fillerType);
                    break block28;
                }
                if (type != 13) break block28;
                Set fillerTrips = this.getLiterals(uri.toString(), this.v.getHasValue());
                LiteralTriple fillerTrip = (LiteralTriple)this.getSingletonObject(fillerTrips);
                this.usedTriples.add(fillerTrip);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Data HasValue: " + fillerTrip));
                }
                URI datatype = null;
                String lang = null;
                if (fillerTrip.language != null) {
                    lang = fillerTrip.language;
                } else {
                    try {
                        try {
                            datatype = this.newURI(fillerTrip.dataType);
                        }
                        catch (NullPointerException ex) {
                        }
                        catch (ClassCastException ex) {}
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                }
                OWLDataValue fillerType = this.factory.getOWLConcreteData(datatype, lang, (Object)fillerTrip.object);
                desc = this.factory.getOWLDataValueRestriction((OWLDataProperty)prop, fillerType);
            }
            catch (OWLException ex) {
                this.error(ex.getMessage());
            }
        }
        if (desc != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(uri + " ~> " + desc));
            }
            this.translatedDescriptions.put(uri, desc);
            return desc;
        }
        OWLClass cl = this.getAndAssumeOWLClass(uri);
        this.translatedDescriptions.put(uri, cl);
        return cl;
    }

    protected OWLDescription translateCardinalityRestriction(URI uri, URI propURI, int type, boolean obj) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Translating Restriction: " + uri + " " + propURI + " " + type + " " + obj));
        }
        OWLObjectCardinalityRestriction desc = null;
        try {
            OWLObjectProperty prop;
            if (obj) {
                prop = this.onto.getObjectProperty(propURI);
                if (prop == null) {
                    prop = this.createObjectProperty(this.onto, propURI);
                    if (!this.definitelyObjectProperties.contains(propURI)) {
                        this.assumedObjectProperties.add(propURI);
                    }
                }
                Object val = null;
                if (type == 14) {
                    int v;
                    Set valTrips = this.getLiterals(uri.toString(), this.v.getMinCardinality());
                    LiteralTriple valTrip = (LiteralTriple)this.getSingletonObject(valTrips);
                    this.usedTriples.add(valTrip);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("MIN: " + valTrip));
                    }
                    if ((v = this.parseInt(valTrip.object, valTrip.language)) < 0) {
                        this.owlFullConstruct(2014, "Bad value for mincardinality: " + valTrip);
                    }
                    desc = this.factory.getOWLObjectCardinalityAtLeastRestriction(prop, v);
                } else if (type == 15) {
                    int v;
                    Set valTrips = this.getLiterals(uri.toString(), this.v.getMaxCardinality());
                    LiteralTriple valTrip = (LiteralTriple)this.getSingletonObject(valTrips);
                    this.usedTriples.add(valTrip);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("MAX: " + valTrip));
                    }
                    if ((v = this.parseInt(valTrip.object, valTrip.language)) < 0) {
                        this.owlFullConstruct(2014, "Bad value for maxcardinality: " + valTrip);
                    }
                    desc = this.factory.getOWLObjectCardinalityAtMostRestriction(prop, v);
                } else {
                    int v;
                    Set valTrips = this.getLiterals(uri.toString(), this.v.getCardinality());
                    LiteralTriple valTrip = (LiteralTriple)this.getSingletonObject(valTrips);
                    this.usedTriples.add(valTrip);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CARD: " + valTrip));
                    }
                    if ((v = this.parseInt(valTrip.object, valTrip.dataType)) < 0) {
                        this.owlFullConstruct(2014, "Bad value for cardinality: " + valTrip);
                    }
                    desc = this.factory.getOWLObjectCardinalityRestriction(prop, v, v);
                }
            } else {
                prop = this.onto.getDataProperty(propURI);
                if (prop == null) {
                    prop = this.createDataProperty(this.onto, propURI);
                    if (!this.definitelyDataProperties.contains(propURI)) {
                        this.assumedDataProperties.add(propURI);
                    }
                }
                Object val = null;
                if (type == 14) {
                    int v;
                    Set valTrips = this.getLiterals(uri.toString(), this.v.getMinCardinality());
                    LiteralTriple valTrip = (LiteralTriple)this.getSingletonObject(valTrips);
                    this.usedTriples.add(valTrip);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("MIN: " + valTrip));
                    }
                    if ((v = this.parseInt(valTrip.object, valTrip.dataType)) < 0) {
                        this.owlFullConstruct(2014, "Bad value for mincardinality: " + valTrip);
                    }
                    desc = this.factory.getOWLDataCardinalityAtLeastRestriction((OWLDataProperty)prop, v);
                } else if (type == 15) {
                    int v;
                    Set valTrips = this.getLiterals(uri.toString(), this.v.getMaxCardinality());
                    LiteralTriple valTrip = (LiteralTriple)this.getSingletonObject(valTrips);
                    this.usedTriples.add(valTrip);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("MAX: " + valTrip));
                    }
                    if ((v = this.parseInt(valTrip.object, valTrip.language)) < 0) {
                        this.owlFullConstruct(2014, "Bad value for maxcardinality: " + valTrip);
                    }
                    desc = this.factory.getOWLDataCardinalityAtMostRestriction((OWLDataProperty)prop, v);
                } else {
                    int v;
                    Set valTrips = this.getLiterals(uri.toString(), this.v.getCardinality());
                    LiteralTriple valTrip = (LiteralTriple)this.getSingletonObject(valTrips);
                    this.usedTriples.add(valTrip);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("CARD: " + valTrip));
                    }
                    if ((v = this.parseInt(valTrip.object, valTrip.dataType)) < 0) {
                        this.owlFullConstruct(2014, "Bad value for cardinality: " + valTrip);
                    }
                    desc = this.factory.getOWLDataCardinalityRestriction((OWLDataProperty)prop, v, v);
                }
            }
        }
        catch (OWLException ex) {
            this.error(ex.getMessage());
        }
        if (desc != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(uri + " ~> " + desc));
            }
            this.translatedDescriptions.put(uri, desc);
            return desc;
        }
        OWLClass cl = this.getAndAssumeOWLClass(uri);
        this.translatedDescriptions.put(uri, cl);
        return cl;
    }

    protected OWLIndividual translateIndividual(URI uri) throws SAXException {
        OWLIndividual ind = (OWLIndividual)this.createdIndividuals.get(uri);
        if (ind != null) {
            return ind;
        }
        try {
            ind = this.isAnonymousNode(uri.toString()) ? this.factory.getAnonOWLIndividual(uri) : this.factory.getOWLIndividual(uri);
            if (!this.definitelyTypedIndividuals.contains(uri)) {
                this.untypedIndividuals.add(uri);
            }
            this.createdIndividuals.put(uri, ind);
            AddEntity ae = new AddEntity(this.onto, (OWLEntity)ind, null);
            this.applyChange((OntologyChange)ae);
            return ind;
        }
        catch (OWLException ex) {
            this.error(ex.getMessage());
            return null;
        }
    }

    protected OWLDataRange translateDataRange(URI range) throws OWLException, SAXException {
        Triple datatypeTriple;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" Translating Data Range: " + range));
            logger.debug((Object)"Checking translations (data)...");
        }
        OWLDataRange tryThis = null;
        try {
            tryThis = (OWLDataRange)this.translatedDescriptions.get(range);
        }
        catch (ClassCastException e) {
            logger.error((Object)(range + " is not a OWLDataRange"));
        }
        if (tryThis != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + tryThis));
            }
            return tryThis;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Not Found ");
        }
        if ((datatypeTriple = this.getTriple(range.toString(), this.v.getInstanceOf(), this.v.getDatatype())) != null) {
            OWLDataType dt = this.factory.getOWLConcreteDataType(range);
            return dt;
        }
        Triple dataRangeTriple = this.getTriple(range.toString(), this.v.getInstanceOf(), this.v.getDataRange());
        if (dataRangeTriple == null) {
            if (!(this.xsdDatatypes.contains(range.toString()) || range.equals(this.rdfLiteral) || this.definitelyDatatypes.contains(range))) {
                URI culprit = range;
                if (this.isAnonymousNode(culprit.toString())) {
                    culprit = null;
                }
                this.owlFullConstruct(2006, "Undefined Datatype: " + range, culprit);
            }
            OWLDataType dt = this.factory.getOWLConcreteDataType(range);
            return dt;
        }
        this.usedTriples.add(dataRangeTriple);
        Set oneofs = this.getObjects(range.toString(), this.v.getOneOf());
        if (oneofs.size() == 1) {
            Triple listStartTriple = (Triple)this.getSingletonObject(oneofs);
            this.usedTriples.add(listStartTriple);
            URI listStart = listStartTriple.object;
            HashSet vals = new HashSet();
            HashSet<OWLDataValue> dataValues = new HashSet<OWLDataValue>();
            this.rdfListToSet(listStart, vals);
            Iterator it = vals.iterator();
            while (it.hasNext()) {
                Object[] valueInformation = (Object[])it.next();
                URI datatype = null;
                String lang = null;
                if (valueInformation[1] != null) {
                    lang = (String)valueInformation[1];
                } else {
                    try {
                        try {
                            datatype = this.newURI((String)valueInformation[2]);
                        }
                        catch (NullPointerException ex) {
                        }
                        catch (ClassCastException ex) {}
                    }
                    catch (URISyntaxException e) {
                        // empty catch block
                    }
                }
                OWLDataValue fillerType = this.factory.getOWLConcreteData(datatype, lang, valueInformation[0]);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)fillerType);
                }
                dataValues.add(fillerType);
            }
            OWLDataEnumeration dr = this.factory.getOWLDataEnumeration(dataValues);
            this.translatedDescriptions.put(range, dr);
            return dr;
        }
        this.owlFullConstruct(2015, "Data Range with multiple oneOfs!: " + range);
        OWLDataType dt = this.factory.getOWLConcreteDataType(range);
        return dt;
    }

    public void statementWithResourceValue(String subj, String pred, String obj) throws SAXException {
        if (subj.endsWith("#")) {
            logger.debug((Object)("HASH: " + subj));
            subj = subj.substring(0, subj.length() - 1);
        }
        if (pred.endsWith("#")) {
            logger.debug((Object)("HASH: " + subj));
            pred = pred.substring(0, subj.length() - 1);
        }
        if (obj.endsWith("#")) {
            logger.debug((Object)("HASH: " + subj));
            obj = obj.substring(0, obj.length() - 1);
        }
        if (tripleLogger.isDebugEnabled()) {
            tripleLogger.debug((Object)("Triple [" + subj + "," + pred + "," + obj + "]"));
        }
        ++this.tripleCount;
        if (tripleLogger.isInfoEnabled() && this.tripleCount % tripleCountChunk == 0) {
            tripleLogger.info((Object)Integer.toString(this.tripleCount));
        }
        URI subj_uri = null;
        URI obj_uri = null;
        URI pred_uri = null;
        try {
            subj_uri = this.newURI(subj);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        try {
            obj_uri = this.newURI(obj);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        try {
            pred_uri = this.newURI(pred);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        this.addTriple(subj_uri, pred_uri, obj_uri);
        if (subj.equals(OWLVocabularyAdapter.INSTANCE.getThing()) || subj.equals(OWLVocabularyAdapter.INSTANCE.getThing())) {
            try {
                URI instanceOf = new URI(this.v.getInstanceOf());
                URI owlClass = new URI(this.v.getClass_());
                this.addTriple(subj_uri, instanceOf, owlClass);
            }
            catch (URISyntaxException ex) {
                this.error(ex.getMessage());
            }
        }
        if (this.isAnonymousNode(subj)) {
            this.bNodes.add(subj_uri);
        }
        if (this.isAnonymousNode(obj)) {
            this.bNodes.add(obj_uri);
        }
    }

    public void statementWithLiteralValue(String subject, String predicate, String object, String language, String datatype) throws SAXException {
        if (subject.endsWith("#")) {
            logger.debug((Object)("HASH: " + subject));
            subject = subject.substring(0, subject.length() - 1);
        }
        if (predicate.endsWith("#")) {
            logger.debug((Object)("HASH: " + predicate));
            predicate = predicate.substring(0, predicate.length() - 1);
        }
        Object value = null;
        if (tripleLogger.isDebugEnabled()) {
            tripleLogger.debug((Object)("[" + subject + "," + predicate + "," + object + ", lang: " + language + ", dt: " + datatype + "]"));
        }
        ++this.tripleCount;
        if (tripleLogger.isInfoEnabled() && this.tripleCount % tripleCountChunk == 0) {
            tripleLogger.info((Object)Integer.toString(this.tripleCount));
        }
        if (predicate.equals(this.rdfNodeID)) {
            this.warning("rdf:nodeID being used. Things may go wrong....");
        }
        URI subj_uri = null;
        URI pred_uri = null;
        try {
            subj_uri = this.newURI(subject);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        try {
            pred_uri = this.newURI(predicate);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        this.addLiteralTriple(subj_uri, pred_uri, object, language, datatype);
        if (this.isAnonymousNode(subject)) {
            this.bNodes.add(subj_uri);
        }
    }

    protected void createPropertyInstance(OWLOntology onto, URI subj, URI pred, URI obj) throws SAXException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PI: " + subj));
            }
            if (pred.toString().startsWith("http://www.w3.org/2002/07/owl#")) {
                this.owlFullConstruct(2016, "Unused triples using owl properties: [" + subj + "," + pred + "," + obj + ". Further messages may be misleading....");
            }
            OWLObjectProperty p = this.getOrCreateObjectProperty(pred);
            OWLIndividual s = this.translateIndividual(subj);
            OWLIndividual o = this.translateIndividual(obj);
            AddObjectPropertyInstance ae = new AddObjectPropertyInstance(onto, s, p, o, null);
            this.applyChange((OntologyChange)ae);
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
    }

    protected void createSameIndividualAs(OWLOntology onto, URI subj, URI obj) throws SAXException {
        try {
            URI culprit;
            if (this.definitelyClasses.contains(subj) && this.definitelyClasses.contains(obj)) {
                culprit = subj;
                if (this.isAnonymousNode(culprit.toString())) {
                    culprit = null;
                }
                if (this.fixSameAs) {
                    this.warning("Treating owl:sameAs applied to Classes as owl:equivalentClass");
                    this.createEquivalentClasses(onto, subj, obj);
                    return;
                }
                this.owlFullConstruct(2026, subj + " owl:sameAs " + obj + ".\n\tShould this be owl:equivalentClass?", null);
            } else if (this.definitelyObjectProperties.contains(subj) && this.definitelyObjectProperties.contains(obj)) {
                culprit = subj;
                if (this.isAnonymousNode(culprit.toString())) {
                    culprit = null;
                }
                this.owlFullConstruct(2027, subj + " owl:sameAs " + obj + ".\n\tShould this be owl:equivalentProperty?", null);
            } else if (this.definitelyDataProperties.contains(subj) && this.definitelyDataProperties.contains(obj)) {
                culprit = subj;
                if (this.isAnonymousNode(culprit.toString())) {
                    culprit = null;
                }
                this.owlFullConstruct(2028, subj + " owl:sameAs " + obj + ".\n\tShould this be owl:equivalentProperty?", null);
            }
            OWLIndividual s = this.translateIndividual(subj);
            OWLIndividual o = this.translateIndividual(obj);
            HashSet<OWLIndividual> set = new HashSet<OWLIndividual>(2, 1.0f);
            set.add(s);
            set.add(o);
            OWLSameIndividualsAxiom entity = this.factory.getOWLSameIndividualsAxiom(set);
            AddIndividualAxiom ae = new AddIndividualAxiom(onto, (OWLIndividualAxiom)entity, null);
            this.applyChange((OntologyChange)ae);
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
    }

    protected void createInverseOf(OWLOntology onto, URI subj, URI obj) throws SAXException {
        try {
            OWLObjectProperty s = null;
            OWLObjectProperty o = null;
            s = this.factory.getOWLObjectProperty(subj);
            if (!this.definitelyObjectProperties.contains(subj)) {
                this.assumedObjectProperties.add(subj);
            }
            o = this.factory.getOWLObjectProperty(obj);
            if (!this.definitelyObjectProperties.contains(obj)) {
                this.assumedObjectProperties.add(obj);
            }
            AddInverse ai = new AddInverse(onto, s, o, null);
            this.applyChange((OntologyChange)ai);
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
    }

    protected void createDifferentFrom(OWLOntology onto, URI subj, URI obj) throws SAXException {
        try {
            OWLIndividual s = this.translateIndividual(subj);
            OWLIndividual o = this.translateIndividual(obj);
            HashSet<OWLIndividual> set = new HashSet<OWLIndividual>(2, 1.0f);
            set.add(s);
            set.add(o);
            OWLDifferentIndividualsAxiom entity = this.factory.getOWLDifferentIndividualsAxiom(set);
            AddIndividualAxiom ae = new AddIndividualAxiom(onto, (OWLIndividualAxiom)entity, null);
            this.applyChange((OntologyChange)ae);
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
    }

    protected void createEquivalentProperty(OWLOntology onto, URI subj, URI obj) throws SAXException {
        int OK = 0;
        OWLObjectProperty o = null;
        OWLObjectProperty s = null;
        if (this.definitelyObjectProperties.contains(subj) && this.definitelyObjectProperties.contains(obj)) {
            OK = 1;
            o = this.getOrCreateObjectProperty(obj);
            s = this.getOrCreateObjectProperty(subj);
        } else if (this.definitelyDataProperties.contains(subj) && this.definitelyDataProperties.contains(obj)) {
            OK = 2;
            o = this.getOrCreateDataProperty(obj);
            s = this.getOrCreateDataProperty(subj);
        }
        if (OK > 0) {
            HashSet<OWLObjectProperty> set = new HashSet<OWLObjectProperty>(2, 1.0f);
            set.add(s);
            set.add(o);
            try {
                OWLEquivalentPropertiesAxiom axiom = this.factory.getOWLEquivalentPropertiesAxiom(set);
                AddPropertyAxiom event = new AddPropertyAxiom(onto, (OWLPropertyAxiom)axiom, null);
                this.applyChange((OntologyChange)event);
            }
            catch (OWLException e) {
                logger.warn((Object)e);
            }
        } else {
            URI culprit = subj;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2017, subj + " rdfs:subPropertyOf " + obj + ". Only allowed between two DatatypeProperties or ObjectProperties.", culprit);
        }
    }

    protected void createEquivalentClasses(OWLOntology onto, URI subj, URI obj) throws SAXException {
        OWLDescription d1 = null;
        OWLDescription d2 = null;
        if (this.definitelyClasses.contains(subj) && this.definitelyClasses.contains(obj)) {
            d1 = this.translateDescription(subj);
            d2 = this.translateDescription(obj);
            HashSet<OWLDescription> set = new HashSet<OWLDescription>(2, 1.0f);
            set.add(d1);
            set.add(d2);
            try {
                OWLEquivalentClassesAxiom axiom = this.factory.getOWLEquivalentClassesAxiom(set);
                AddClassAxiom ac = new AddClassAxiom(onto, (OWLClassAxiom)axiom, null);
                this.applyChange((OntologyChange)ac);
            }
            catch (OWLException e) {
                logger.warn((Object)e);
            }
        } else {
            this.error("Problems with sameAs");
        }
    }

    protected void createSubProperty(OWLOntology onto, URI subj, URI obj) throws SAXException {
        int OK = 0;
        OWLObjectProperty o = null;
        OWLObjectProperty s = null;
        if (this.definitelyObjectProperties.contains(subj) && this.definitelyObjectProperties.contains(obj)) {
            OK = 1;
            o = this.getOrCreateObjectProperty(obj);
            s = this.getOrCreateObjectProperty(subj);
        } else if (this.definitelyDataProperties.contains(subj) && this.definitelyDataProperties.contains(obj)) {
            OK = 2;
            o = this.getOrCreateDataProperty(obj);
            s = this.getOrCreateDataProperty(subj);
        }
        if (OK > 0) {
            try {
                OWLSubPropertyAxiom axiom = this.factory.getOWLSubPropertyAxiom(s, (OWLProperty)o);
                AddPropertyAxiom event = new AddPropertyAxiom(onto, (OWLPropertyAxiom)axiom, null);
                this.applyChange((OntologyChange)event);
            }
            catch (OWLException e) {
                logger.warn((Object)e);
            }
        } else {
            URI culprit = subj;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2017, subj + " rdfs:subPropertyOf " + obj + ". Only allowed between two DatatypeProperties or ObjectProperties.", culprit);
        }
    }

    protected void createRange(OWLOntology onto, URI property, URI range) throws SAXException {
        try {
            OWLProperty p = this.getProperty(property);
            if (p == null) {
                if (this.definitelyDatatypes.contains(range)) {
                    logger.warn((Object)("Need to know type of property " + property + " but it is missing, assuming DataProperty !"));
                    p = this.getOrCreateDataProperty(property);
                } else {
                    logger.warn((Object)("Need to know type of property " + property + " but it is missing, assuming ObjectProperty !"));
                    p = this.getOrCreateObjectProperty(property);
                }
            }
            AddDataPropertyRange change = null;
            if (p instanceof OWLDataProperty) {
                OWLDataRange dRange = this.translateDataRange(range);
                change = new AddDataPropertyRange(onto, (OWLDataProperty)p, dRange, null);
            } else {
                OWLDescription desc = this.translateDescription(range);
                this.checkAndConsumeBNode(range);
                change = new AddObjectPropertyRange(onto, (OWLObjectProperty)p, desc, null);
            }
            this.applyChange((OntologyChange)change);
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
    }

    protected void createDomain(OWLOntology onto, URI property, URI domain) throws SAXException {
        try {
            OWLProperty p = this.getProperty(property);
            if (p == null) {
                logger.warn((Object)("Need to know type of property " + property + " but it is missing, assuming ObjectProperty !"));
                p = this.factory.getOWLObjectProperty(property);
                this.assumedObjectProperties.add(property);
            } else {
                OWLDescription desc = this.translateDescription(domain);
                this.checkAndConsumeBNode(domain);
                if (desc == null) {
                    desc = this.getAndAssumeOWLClass(domain);
                }
                AddDomain ad = new AddDomain(onto, p, desc, null);
                this.applyChange((OntologyChange)ad);
            }
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
    }

    protected void importOntology(OWLOntology onto, URI subj, URI obj) throws SAXException {
        block20: {
            block19: {
                String oString = obj.toString();
                this.warning("Importing: " + obj);
                String oString2 = obj.toString() + "#";
                if (oString.equals("http://www.w3.org/2002/07/owl#")) break block19;
                if (oString.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) break block19;
                if (oString.equals("http://www.w3.org/2000/01/rdf-schema#")) break block19;
                if (oString2.equals("http://www.w3.org/2002/07/owl#")) break block19;
                if (oString2.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) break block19;
                if (!oString2.equals("http://www.w3.org/2000/01/rdf-schema#")) break block20;
            }
            if (this.ignoreSchemaImports) {
                this.warning("Ignoring import of: " + obj);
                return;
            }
        }
        if (!subj.equals(this.ontologyLogicalURI)) {
            this.warning("An imports statement:\n\t " + subj + " owl:imports " + obj + "\nhas been found that does not seem apply to the ontology being parsed.\nThis may be due to a missing owl:Ontology triple.\nThis parser isn't really able to resolve such situations and will just\nimport anyway.");
        }
        if (!this.definitelyOntologies.contains(subj)) {
            this.owlFullConstruct(2018, "An imports statement:\n\t " + subj + " owl:imports " + obj + "\nhas been found with a subject that is not an ontology.");
        }
        progressLogger.info((Object)("Importing: " + obj.toString()));
        if (!this.definitelyOntologies.contains(obj)) {
            this.assumedOntologies.add(obj);
        }
        OWLOntology importedOntology = null;
        try {
            importedOntology = onto.getOWLConnection().createOntology(obj, obj);
            OWLRDFParser parser = new OWLRDFParser();
            parser.setOptions(this.myParser.getOptions());
            OWLConsumer consumer = new OWLConsumer(importedOntology);
            consumer.setOWLRDFParser(parser);
            consumer.setOWLRDFErrorHandler(this.handler);
            consumer.setCheckDefinitions(false);
            HashSet[] assumptions = new HashSet[]{this.assumedClasses, this.assumedDataProperties, this.assumedObjectProperties, this.definitelyClasses, this.definitelyObjectProperties, this.definitelyDataProperties, this.untypedIndividuals, this.definitelyTypedIndividuals, this.parsedURIs, this.rdfsClasses, this.rdfProperties, this.definitelyAnnotationProperties, this.definitelyDatatypes, this.definitelyOntologies, this.assumedOntologies};
            consumer.setAssumptions(assumptions);
            parser.setConsumer(consumer);
            try {
                logger.info((Object)("Parsing: " + obj));
                parser.parseOntology(importedOntology, obj);
                logger.info((Object)("Finished import parse: " + obj));
                Iterator it = this.assumedClasses.iterator();
                while (it.hasNext()) {
                    logger.info(it.next());
                }
            }
            catch (ParserException e) {
                this.warning("Import parsing failed: " + e.getMessage());
            }
        }
        catch (OWLException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ontology: " + obj.toString() + " already exists"));
            }
            try {
                importedOntology = onto.getOWLConnection().getOntologyPhysical(obj);
            }
            catch (OWLException e2) {
                this.error(e2.getMessage());
                importedOntology = null;
            }
        }
        if (importedOntology != null) {
            AddImport ai = new AddImport(onto, importedOntology, null);
            try {
                this.applyChange((OntologyChange)ai);
            }
            catch (OWLException e) {
                this.error(e.getMessage());
            }
        }
        progressLogger.info((Object)("Done Importing: " + obj.toString()));
    }

    protected OWLObjectProperty createObjectProperty(OWLOntology onto, URI uri) {
        OWLObjectProperty entity = null;
        try {
            this.createdObjectProperties.add(uri);
            entity = this.factory.getOWLObjectProperty(uri);
            AddEntity ae = new AddEntity(onto, (OWLEntity)entity, null);
            this.applyChange((OntologyChange)ae);
        }
        catch (OWLException e) {
            logger.warn((Object)e);
        }
        return entity;
    }

    protected OWLAnnotationProperty createAnnotationProperty(OWLOntology onto, URI uri) {
        OWLAnnotationProperty entity = null;
        try {
            entity = this.factory.getOWLAnnotationProperty(uri);
            AddEntity ae = new AddEntity(onto, (OWLEntity)entity, null);
            this.applyChange((OntologyChange)ae);
        }
        catch (OWLException e) {
            logger.warn((Object)e);
        }
        return entity;
    }

    protected OWLDataProperty createDataProperty(OWLOntology onto, URI uri) throws SAXException {
        OWLDataProperty entity = null;
        try {
            this.createdDatatypeProperties.add(uri);
            entity = this.factory.getOWLDataProperty(uri);
            AddEntity ae = new AddEntity(onto, (OWLEntity)entity, null);
            this.applyChange((OntologyChange)ae);
        }
        catch (OWLException e) {
            logger.warn((Object)e);
        }
        return entity;
    }

    protected OWLObjectProperty getOrCreateObjectProperty(URI uri) throws SAXException {
        try {
            OWLObjectProperty p = this.onto.getObjectProperty(uri);
            if (p == null) {
                p = this.createObjectProperty(this.onto, uri);
                if (!this.definitelyObjectProperties.contains(uri)) {
                    this.assumedObjectProperties.add(uri);
                }
            }
            return p;
        }
        catch (OWLException e) {
            this.error(e.getMessage());
            return null;
        }
    }

    protected OWLAnnotationProperty getOrCreateAnnotationProperty(URI uri) throws SAXException {
        try {
            OWLAnnotationProperty p = this.onto.getAnnotationProperty(uri);
            if (p == null) {
                p = this.createAnnotationProperty(this.onto, uri);
                if (!this.definitelyAnnotationProperties.contains(uri)) {
                    this.definitelyAnnotationProperties.add(uri);
                }
            }
            return p;
        }
        catch (OWLException e) {
            this.error(e.getMessage());
            return null;
        }
    }

    protected OWLDataProperty getOrCreateDataProperty(URI uri) throws SAXException {
        try {
            OWLDataProperty p = this.onto.getDataProperty(uri);
            if (p == null) {
                p = this.createDataProperty(this.onto, uri);
                if (!this.definitelyDataProperties.contains(uri)) {
                    this.assumedDataProperties.add(uri);
                }
            }
            return p;
        }
        catch (OWLException e) {
            this.error(e.getMessage());
            return null;
        }
    }

    protected void createOntology(OWLOntology onto, String subj) throws SAXException {
        logger.warn((Object)"Need OntologyMetaDataInterface");
    }

    protected OWLClass createClass(OWLOntology onto, URI uri) throws SAXException {
        OWLClass entity = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating: " + uri));
            }
            entity = this.factory.getOWLClass(uri);
            AddEntity ae = new AddEntity(onto, (OWLEntity)entity, null);
            this.applyChange((OntologyChange)ae);
        }
        catch (OWLException e) {
            logger.warn((Object)e);
        }
        return entity;
    }

    protected OWLDataType createDatatype(OWLOntology onto, URI uri) throws SAXException {
        OWLDataType entity = null;
        try {
            entity = this.factory.getOWLConcreteDataType(uri);
            AddDataType ae = new AddDataType(onto, entity, null);
            this.applyChange((OntologyChange)ae);
            this.definitelyDatatypes.add(uri);
        }
        catch (OWLException e) {
            logger.warn((Object)e);
        }
        return entity;
    }

    protected void createDataPropertyInstance(OWLOntology onto, URI subject, URI predicate, String datatype, String language, String object) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DI: " + subject));
        }
        try {
            URI dt = null;
            String lang = null;
            if (language != null) {
                lang = language;
            } else {
                try {
                    if (datatype != null) {
                        dt = this.newURI(datatype);
                    }
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
            this.createDataProperty(onto, predicate);
            if (!this.definitelyDataProperties.contains(predicate)) {
                this.assumedDataProperties.add(predicate);
            }
            if (dt != null && !this.definitelyDatatypes.contains(dt) && !this.xsdDatatypes.contains(dt.toString())) {
                URI culprit = dt;
                if (this.isAnonymousNode(culprit.toString())) {
                    culprit = null;
                }
                this.owlFullConstruct(2006, "Undefined Datatype: " + dt, culprit);
            }
            OWLDataProperty p = this.factory.getOWLDataProperty(predicate);
            OWLIndividual s = this.translateIndividual(subject);
            OWLDataValue o = this.factory.getOWLConcreteData(dt, lang, (Object)object);
            AddDataPropertyInstance ae = new AddDataPropertyInstance(onto, s, p, o, null);
            this.applyChange((OntologyChange)ae);
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
    }

    protected void createAnnotationInstance(OWLOntology onto, URI subject, URI predicate, Object object) throws SAXException {
        OWLClass oo = null;
        try {
            OWLAnnotationProperty prop;
            if (this.definitelyOntologies.contains(subject)) {
                if (subject.equals(this.ontologyLogicalURI)) {
                    oo = onto;
                } else {
                    this.warning("Ignoring Annotation: " + subject + " - " + predicate + " - " + object);
                    return;
                }
            }
            if (oo == null) {
                oo = onto.getClass(subject);
            }
            if (oo == null) {
                oo = onto.getObjectProperty(subject);
            }
            if (oo == null) {
                oo = onto.getDataProperty(subject);
            }
            if (oo == null) {
                oo = onto.getAnnotationProperty(subject);
            }
            if (oo == null) {
                oo = onto.getIndividual(subject);
            }
            if (oo == null) {
                oo = onto.getDatatype(subject);
            }
            if (oo == null) {
                oo = this.isAnonymousNode(subject.toString()) ? this.factory.getAnonOWLIndividual(subject) : this.factory.getOWLIndividual(subject);
                if (!this.definitelyTypedIndividuals.contains(subject)) {
                    this.untypedIndividuals.add(subject);
                }
                this.createdIndividuals.put(subject, oo);
            }
            if ((prop = this.getOrCreateAnnotationProperty(predicate)) == null && OWLVocabularyAdapter.INSTANCE.getAnnotationProperties().contains(predicate.toString())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Use of: " + predicate));
                }
                prop = this.createAnnotationProperty(onto, predicate);
                this.definitelyAnnotationProperties.add(predicate);
            }
            AddAnnotationInstance aai = new AddAnnotationInstance(onto, (OWLObject)oo, prop, object, null);
            this.applyChange((OntologyChange)aai);
        }
        catch (OWLException e) {
            this.error(e.getMessage());
        }
    }

    public void logicalURI(String arg0) throws SAXException {
    }

    public void includeModel(String arg0, String arg1) throws SAXException {
    }

    public void addModelAttribte(String arg0, String arg1) throws SAXException {
    }

    protected void applyChange(OntologyChange oc) throws OWLException {
        oc.accept((ChangeVisitor)this.onto);
    }

    protected OWLClass getAndAssumeOWLClass(URI uri) throws SAXException {
        if (this.isAnonymousNode(uri.toString())) {
            this.owlFullConstruct(2022, "Anonymous Class being Created: " + uri);
        }
        try {
            OWLClass clazz = this.factory.getOWLClass(uri);
            if (!this.definitelyClasses.contains(uri)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Assuming Class: " + uri));
                }
                this.assumedClasses.add(uri);
            }
            return clazz;
        }
        catch (OWLException ex) {
            this.error(ex.getMessage());
            return null;
        }
    }

    protected boolean isAnonymousNode(String str) {
        return this.myParser.isAnonymousNodeURI(str);
    }

    protected void addToMap(Map map, Object key, Object value) {
        HashSet<Object> s = (HashSet<Object>)map.get(key);
        if (s == null) {
            s = new HashSet<Object>();
            map.put(key, s);
        }
        s.add(value);
    }

    protected Object getSingletonObject(Set s) {
        Iterator it = s.iterator();
        return it.next();
    }

    protected void checkForUntypedIndividuals() throws SAXException {
        Iterator iter = this.untypedIndividuals.iterator();
        while (iter.hasNext()) {
            URI uri = (URI)iter.next();
            URI culprit = uri;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2004, "Untyped Individual: " + uri, culprit);
        }
    }

    protected void checkForUndefinedOntologies() throws SAXException {
        Iterator iter = this.assumedOntologies.iterator();
        while (iter.hasNext()) {
            URI uri = (URI)iter.next();
            URI culprit = uri;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2005, "Imports applied to untyped Ontology: " + uri, culprit);
        }
    }

    protected void checkForUndefinedClasses() throws SAXException {
        Iterator iter = this.assumedClasses.iterator();
        while (iter.hasNext()) {
            URI uri = (URI)iter.next();
            URI culprit = uri;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2002, "Untyped Class: " + uri, culprit);
        }
    }

    protected void checkForUndefinedObjectProperties() throws SAXException {
        Iterator iter = this.assumedObjectProperties.iterator();
        while (iter.hasNext()) {
            URI uri = (URI)iter.next();
            URI culprit = uri;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2024, "Untyped Object Property: " + uri, culprit);
        }
    }

    protected void checkForUndefinedDataProperties() throws SAXException {
        Iterator iter = this.assumedDataProperties.iterator();
        while (iter.hasNext()) {
            URI uri = (URI)iter.next();
            URI culprit = uri;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2023, "Untyped Data Property: " + uri, culprit);
        }
    }

    protected void checkForRDFProperties() throws SAXException {
        Iterator iter = this.rdfProperties.iterator();
        while (iter.hasNext()) {
            URI uri = (URI)iter.next();
            if (this.definitelyObjectProperties.contains(uri) || this.definitelyDataProperties.contains(uri) || this.definitelyAnnotationProperties.contains(uri)) continue;
            URI culprit = uri;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2019, "rdf:Property used for: " + uri, culprit);
        }
    }

    protected void checkForRDFSClasses() throws SAXException {
        Iterator iter = this.rdfsClasses.iterator();
        while (iter.hasNext()) {
            URI uri = (URI)iter.next();
            if (this.definitelyClasses.contains(uri)) continue;
            URI culprit = uri;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2020, "rdfs:Class used for: " + uri, culprit);
        }
    }

    protected void checkForOneOfs() throws SAXException {
        Set workingTriples = null;
        workingTriples = this.getByPredicate(this.v.getOneOf());
        Iterator iter = workingTriples.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            if (this.tripleExists(triple.subject.toString(), this.v.getInstanceOf(), this.v.getClass_()) || this.tripleExists(triple.subject.toString(), this.v.getInstanceOf(), this.v.getDataRange()) || this.builtInClasses.contains(triple.subject)) continue;
            URI culprit = triple.subject;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2014, "oneOf without Class or DataRange: " + triple.subject, culprit);
        }
    }

    protected void checkBooleans() throws SAXException {
        URI culprit;
        Triple triple;
        Set workingTriples = null;
        workingTriples = this.getByPredicate(this.v.getComplementOf());
        Iterator iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            if (this.tripleExists(triple.subject.toString(), this.v.getInstanceOf(), this.v.getClass_()) || this.builtInClasses.contains(triple.subject)) continue;
            culprit = triple.subject;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2015, "complementOf without Class: " + triple.subject, culprit);
        }
        workingTriples = this.getByPredicate(this.v.getIntersectionOf());
        iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            if (this.tripleExists(triple.subject.toString(), this.v.getInstanceOf(), this.v.getClass_()) || this.builtInClasses.contains(triple.subject)) continue;
            culprit = triple.subject;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2015, "intersectionOf without Class: " + triple.subject, culprit);
        }
        workingTriples = this.getByPredicate(this.v.getUnionOf());
        iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            if (this.tripleExists(triple.subject.toString(), this.v.getInstanceOf(), this.v.getClass_()) || this.builtInClasses.contains(triple.subject)) continue;
            culprit = triple.subject;
            if (this.isAnonymousNode(culprit.toString())) {
                culprit = null;
            }
            this.owlFullConstruct(2015, "unionOf without Class: " + triple.subject, culprit);
        }
    }

    protected void checkForMalformedLists() throws SAXException {
        URI uri;
        Triple triple;
        HashSet<URI> allValidListSubjects = new HashSet<URI>();
        Set workingTriples = null;
        workingTriples = this.getByPredicate("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        Iterator iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            allValidListSubjects.add(triple.object);
        }
        workingTriples = this.getByPredicate(this.v.getIntersectionOf());
        iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            allValidListSubjects.add(triple.object);
        }
        workingTriples = this.getByPredicate(this.v.getUnionOf());
        iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            allValidListSubjects.add(triple.object);
        }
        workingTriples = this.getByPredicate(this.v.getOneOf());
        iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            allValidListSubjects.add(triple.object);
        }
        workingTriples = this.getByPredicate(this.v.getDistinctMembers());
        iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            allValidListSubjects.add(triple.object);
        }
        workingTriples = this.getByPredicate("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            uri = triple.subject;
            if (allValidListSubjects.contains(uri)) continue;
            this.owlFullConstruct(2008, "Bad list first/rest subject: " + uri + "\n\tNot an intersection/union/oneof");
        }
        workingTriples = this.getByPredicate("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        iter = workingTriples.iterator();
        while (iter.hasNext()) {
            triple = (Triple)iter.next();
            uri = triple.subject;
            if (allValidListSubjects.contains(uri)) continue;
            this.owlFullConstruct(2008, "Bad list first/rest subject: " + uri + "\n\tNot an intersection/union/oneof");
        }
    }

    protected void releaseTripleModel() {
        this.triples = null;
        this.usedTriples = null;
        this.literalTriples = null;
        this.triplesBySubject = null;
        this.triplesByObject = null;
        this.triplesByPredicateObject = null;
        this.triplesByPredicateSubject = null;
        this.triplesByPredicate = null;
        this.literalTriplesBySubject = null;
    }

    protected void addTriple(URI s, URI p, URI o) throws SAXException {
        if (!this.tripleExists(s, p, o)) {
            Set<Triple> set;
            Triple triple = new Triple(s, p, o);
            this.triples.add(triple);
            Map map = (HashMap<URI, HashSet<Triple>>)this.triplesBySubject.get(s);
            if (map == null) {
                map = new HashMap<URI, HashSet<Triple>>();
                this.triplesBySubject.put(s, map);
            }
            if ((set = (HashSet<Triple>)map.get(p)) == null) {
                set = new HashSet<Triple>();
                map.put(p, set);
            }
            set.add(triple);
            map = (Map)this.triplesByObject.get(o);
            if (map == null) {
                map = new HashMap();
                this.triplesByObject.put(o, map);
            }
            if ((set = (Set)map.get(p)) == null) {
                set = new HashSet();
                map.put(p, set);
            }
            set.add(triple);
            map = (Map)this.triplesByPredicateSubject.get(p);
            if (map == null) {
                map = new HashMap();
                this.triplesByPredicateSubject.put(p, map);
            }
            if ((set = (Set)map.get(s)) == null) {
                set = new HashSet();
                map.put(s, set);
            }
            set.add(triple);
            map = (Map)this.triplesByPredicateObject.get(p);
            if (map == null) {
                map = new HashMap();
                this.triplesByPredicateObject.put(p, map);
            }
            if ((set = (Set)map.get(o)) == null) {
                set = new HashSet();
                map.put(o, set);
            }
            set.add(triple);
            set = (Set)this.triplesByPredicate.get(p);
            if (set == null) {
                set = new HashSet();
                this.triplesByPredicate.put(p, set);
            }
            set.add(triple);
        }
    }

    protected void addLiteralTriple(URI s, URI p, String o, String l, String dt) {
        HashSet<LiteralTriple> set;
        LiteralTriple triple = new LiteralTriple(s, p, o, l, dt);
        this.literalTriples.add(triple);
        HashMap<URI, HashSet<LiteralTriple>> map = (HashMap<URI, HashSet<LiteralTriple>>)this.literalTriplesBySubject.get(s);
        if (map == null) {
            map = new HashMap<URI, HashSet<LiteralTriple>>();
            this.literalTriplesBySubject.put(s, map);
        }
        if ((set = (HashSet<LiteralTriple>)map.get(p)) == null) {
            set = new HashSet<LiteralTriple>();
            map.put(p, set);
        }
        set.add(triple);
    }

    protected Set getSubjects(String predicate, String object) throws SAXException {
        URI predicate_uri = null;
        URI object_uri = null;
        try {
            predicate_uri = this.newURI(predicate);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        try {
            object_uri = this.newURI(object);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        return this.getSubjects(predicate_uri, object_uri);
    }

    protected Set getSubjects(URI predicate, URI object) {
        Map map = (Map)this.triplesByPredicateObject.get(predicate);
        if (map == null) {
            return new HashSet();
        }
        Set set = (Set)map.get(object);
        if (set == null) {
            return new HashSet();
        }
        return set;
    }

    protected Set getObjects(String subject, String predicate) throws SAXException {
        URI predicate_uri = null;
        URI subject_uri = null;
        try {
            predicate_uri = this.newURI(predicate);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        try {
            subject_uri = this.newURI(subject);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        return this.getObjects(subject_uri, predicate_uri);
    }

    protected Set getObjects(URI subject, URI predicate) {
        Map map = (Map)this.triplesByPredicateSubject.get(predicate);
        if (map == null) {
            return new HashSet();
        }
        Set set = (Set)map.get(subject);
        if (set == null) {
            return new HashSet();
        }
        return set;
    }

    protected Set getLiterals(String subject, String predicate) throws SAXException {
        URI predicate_uri = null;
        URI subject_uri = null;
        try {
            predicate_uri = this.newURI(predicate);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        try {
            subject_uri = this.newURI(subject);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        return this.getLiterals(subject_uri, predicate_uri);
    }

    protected Set getLiterals(URI subject, URI predicate) {
        Map map = (Map)this.literalTriplesBySubject.get(subject);
        if (map == null) {
            return new HashSet();
        }
        Set set = (Set)map.get(predicate);
        if (set == null) {
            return new HashSet();
        }
        return set;
    }

    protected Set getByPredicate(URI predicate) {
        Set set = (Set)this.triplesByPredicate.get(predicate);
        if (set == null) {
            return new HashSet();
        }
        return set;
    }

    protected Set getByPredicate(String predicate) throws SAXException {
        URI predicate_uri = null;
        try {
            predicate_uri = this.newURI(predicate);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        return this.getByPredicate(predicate_uri);
    }

    protected boolean isObject(URI object) throws SAXException {
        Map map = (Map)this.triplesByObject.get(object);
        if (map != null) {
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                Set vals = (Set)it.next();
                if (vals.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean tripleExists(String subject, String predicate) throws SAXException {
        return !this.getObjects(subject, predicate).isEmpty() || !this.getLiterals(subject, predicate).isEmpty();
    }

    protected boolean tripleExists(URI subject, URI predicate) throws SAXException {
        return !this.getObjects(subject, predicate).isEmpty() || !this.getLiterals(subject, predicate).isEmpty();
    }

    protected boolean tripleExists(URI subject, URI predicate, URI object) throws SAXException {
        return this.getTriple(subject, predicate, object) != null;
    }

    protected boolean tripleExists(String subject, String predicate, String object) throws SAXException {
        return this.getTriple(subject, predicate, object) != null;
    }

    protected Triple getTriple(URI subject, URI predicate, URI object) throws SAXException {
        Map map = (Map)this.triplesBySubject.get(subject);
        if (map == null) {
            return null;
        }
        Set set = (Set)map.get(predicate);
        if (set == null) {
            return null;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Triple t = (Triple)it.next();
            if (!object.equals(t.object)) continue;
            return t;
        }
        return null;
    }

    protected Triple getTriple(String subject, String predicate, String object) throws SAXException {
        URI subject_uri = null;
        URI predicate_uri = null;
        URI object_uri = null;
        try {
            subject_uri = this.newURI(subject);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        try {
            predicate_uri = this.newURI(predicate);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        try {
            object_uri = this.newURI(object);
        }
        catch (URISyntaxException e) {
            this.warning(e.getMessage());
        }
        return this.getTriple(subject_uri, predicate_uri, object_uri);
    }

    protected String dumpTriples() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        pw.println("=======================================================");
        Iterator it = this.triples.iterator();
        while (it.hasNext()) {
            pw.println(it.next());
        }
        it = this.literalTriples.iterator();
        while (it.hasNext()) {
            pw.println(it.next());
        }
        pw.println("=======================================================");
        return sw.toString();
    }

    protected boolean languageMachineryType(URI uri) {
        String str = uri.toString();
        return str.equals(this.v.getClass_()) || str.equals("http://www.w3.org/2000/01/rdf-schema#Class") || str.equals(this.rdfsV.getProperty()) || str.equals(this.rdfsV.getDatatype()) || str.equals(this.v.getAllDifferent()) || str.equals(this.v.getRestriction()) || str.equals(this.v.getObjectProperty()) || str.equals(this.v.getAnnotationProperty()) || str.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#List") || str.equals(this.v.getDatatypeProperty()) || str.equals(this.v.getDataRange()) || str.equals(this.v.getTransitive()) || str.equals(this.v.getSymmetricProperty()) || str.equals(this.v.getFunctionalProperty()) || str.equals(this.v.getInverseFunctionalProperty()) || str.equals(this.v.getOntology()) || str.equals(this.v.getDeprecatedClass()) || str.equals(this.v.getDeprecatedProperty());
    }

    protected int parseInt(String str, String type) throws SAXException {
        try {
            BigInteger bigValue = new BigInteger(str.trim());
            if (bigValue.compareTo(MAXCARDASBIGINTEGER) > 0) {
                this.warning("Cardinality of " + bigValue + " is too big. Using " + Integer.MAX_VALUE + " instead!");
                return Integer.MAX_VALUE;
            }
            return bigValue.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected void checkAndConsumeBNode(URI bnode) throws SAXException {
        if (this.isAnonymousNode(bnode.toString())) {
            if (this.usedBNodes.contains(bnode)) {
                this.owlFullConstruct(2011, "Structure Sharing of: " + bnode);
            }
            this.usedBNodes.add(bnode);
        }
    }

    protected URI newURI(String u) throws URISyntaxException {
        if (this.stringsToURIs.containsKey(u)) {
            return (URI)this.stringsToURIs.get(u);
        }
        URI uri = new URI(u);
        this.stringsToURIs.put(u, uri);
        return uri;
    }

    protected void additionalParsingHook() throws SAXException {
        logger.info((Object)"Doing Extra Stuff");
    }

    protected void setImporting(boolean importing) {
        this.importing = importing;
    }

    protected class LiteralTriple {
        URI subject;
        URI predicate;
        String object;
        String language;
        String dataType;

        LiteralTriple(URI s, URI p, String o, String l, String dt) {
            this.subject = s;
            this.predicate = p;
            this.object = o;
            this.language = l;
            this.dataType = dt;
        }

        public String toString() {
            return "[" + this.subject + "," + this.predicate + "," + this.object + "," + this.language + "," + this.dataType + "]";
        }
    }

    protected class Triple {
        URI subject;
        URI predicate;
        URI object;

        Triple(URI s, URI p, URI o) {
            this.subject = s;
            this.predicate = p;
            this.object = o;
        }

        public String toString() {
            return "[" + this.subject + "," + this.predicate + "," + this.object + "]";
        }
    }
}

