/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Grep {
    private static Charset charset = Charset.forName("ISO-8859-15");
    private static CharsetDecoder decoder = charset.newDecoder();
    private static Pattern linePattern = Pattern.compile(".*\r?\n");
    private static Pattern pattern;
    private static CharBuffer indexFile;

    private static void compile(String pat) {
        try {
            pattern = Pattern.compile(pat);
        }
        catch (PatternSyntaxException x) {
            System.err.println(x.getMessage());
        }
    }

    private static List grep() {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher lm = linePattern.matcher(indexFile);
        Matcher pm = null;
        int lines = 0;
        while (lm.find()) {
            ++lines;
            String cs = lm.group();
            if (pm == null) {
                pm = pattern.matcher(cs);
            } else {
                pm.reset(cs);
            }
            if (pm.find()) {
                matches.add(cs.toString());
            }
            if (lm.end() == indexFile.limit()) break;
        }
        return matches;
    }

    public static void setFile(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        FileChannel fc = fis.getChannel();
        int sz = (int)fc.size();
        MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
        indexFile = decoder.decode(bb);
        fc.close();
    }

    public static List grep(String synsetOffset) throws IOException {
        Grep.compile(synsetOffset);
        List matches = Grep.grep();
        return matches;
    }

    public static String grep(String synsetOffset, String lemma) throws IOException {
        Grep.compile(synsetOffset);
        String m = "";
        List matches = Grep.grep();
        int i = 0;
        while (i < matches.size()) {
            String match = (String)matches.get(i);
            if (match.indexOf(lemma) != -1) {
                m = match;
            }
            ++i;
        }
        return m;
    }
}

