/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.lang.sparql.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql.SPARQLParser;
import com.hp.hpl.jena.sparql.lang.sparql.Token;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.StringReader;

public class NodeFactory {
    public static Node create(String nodeString) {
        try {
            Query query2 = QueryFactory.make();
            query2.setPrefixMapping(ARQConstants.getGlobalPrefixMap());
            StringReader in = new StringReader(nodeString);
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(query2);
            Node n = parser.GraphTerm();
            Token t = parser.getNextToken();
            if (t.kind != 0) {
                throw NodeFactory.makeException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
            }
            return n;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
    }

    private static QueryParseException makeException(String msg, int line, int column) {
        return new QueryParseException(msg, line, column);
    }

    public static Node createLiteralNode(String lex, String lang, String datatypeURI) {
        if (datatypeURI != null && datatypeURI.equals("")) {
            datatypeURI = null;
        }
        if (lang != null && lang.equals("")) {
            lang = null;
        }
        RDFDatatype dType = null;
        if (datatypeURI != null) {
            dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
        }
        Node n = Node.createLiteral((String)lex, (String)lang, (RDFDatatype)dType);
        return n;
    }

    public static int nodeToInt(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDinteger.isValidLiteral(lit)) {
            return Integer.MIN_VALUE;
        }
        int i = ((Number)lit.getValue()).intValue();
        return i;
    }

    public static long nodeToLong(Node node) {
        LiteralLabel lit = node.getLiteral();
        if (!XSDDatatype.XSDinteger.isValidLiteral(lit)) {
            return Long.MIN_VALUE;
        }
        long i = ((Number)lit.getValue()).longValue();
        return i;
    }

    public static Node intToNode(int integer) {
        return Node.createLiteral((String)Integer.toString(integer), (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static Node intToNode(long integer) {
        return Node.createLiteral((String)Long.toString(integer), (String)"", (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static Node floatToNode(float value) {
        return Node.createLiteral((String)Float.toString(value), (String)"", (RDFDatatype)XSDDatatype.XSDfloat);
    }

    public static Node nowAsDateTime() {
        String lex = Utils.nowAsXSDDateTimeString();
        return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdateTime);
    }

    public static Node todayAsDate() {
        String lex = Utils.todayAsXSDDateString();
        return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDdate);
    }
}

