/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.IndentedWriter;

public class FmtExpr {
    static final int INDENT = 2;
    FmtExprARQVisitor visitor;

    public FmtExpr(IndentedWriter writer, SerializationContext cxt) {
        this.visitor = new FmtExprARQVisitor(writer, cxt);
    }

    public void format(Expr expr) {
        expr.visit(this.visitor);
    }

    public static void format(IndentedWriter out, Expr expr) {
        FmtExpr.format(out, expr, null);
    }

    public static void format(IndentedWriter out, Expr expr, SerializationContext cxt) {
        FmtExpr fmt = new FmtExpr(out, cxt);
        fmt.format(expr);
    }

    private static class FmtExprARQVisitor
    implements ExprVisitor {
        IndentedWriter out;
        SerializationContext context;

        public FmtExprARQVisitor(IndentedWriter writer, PrefixMapping pmap) {
            this(writer, new SerializationContext(pmap, null));
        }

        public FmtExprARQVisitor(IndentedWriter writer, SerializationContext cxt) {
            this.out = writer;
            this.context = cxt;
            if (this.context == null) {
                this.context = new SerializationContext();
            }
        }

        public void startVisit() {
        }

        private void visitFunction1(ExprFunction1 expr) {
            this.out.print("( ");
            this.out.print(expr.getOpName());
            this.out.print(" ");
            expr.getArg().visit(this);
            this.out.print(" )");
        }

        private void visitFunction2(ExprFunction2 expr) {
            this.out.print("( ");
            expr.getArg1().visit(this);
            this.out.print(" ");
            this.out.print(expr.getOpName());
            this.out.print(" ");
            expr.getArg2().visit(this);
            this.out.print(" )");
        }

        public void visit(ExprFunction func) {
            Expr expr;
            if (func.getOpName() != null && func instanceof ExprFunction2) {
                this.visitFunction2((ExprFunction2)func);
                return;
            }
            if (func.getOpName() != null && func instanceof ExprFunction1) {
                this.visitFunction1((ExprFunction1)func);
                return;
            }
            this.out.print(func.getFunctionPrintName(this.context));
            this.out.print("(");
            int i = 1;
            while ((expr = func.getArg(i)) != null) {
                if (i != 1) {
                    this.out.print(", ");
                }
                expr.visit(this);
                ++i;
            }
            this.out.print(")");
        }

        public void visit(ExprFunctionOp funcOp) {
            FormatterElement fmtElt = new FormatterElement(this.out, this.context);
            this.out.print(funcOp.getFunctionName(this.context));
            this.out.print(" ");
            Element el = funcOp.getElement();
            if (el == null) {
                el = OpAsQuery.asQuery(funcOp.getOp()).getQueryPattern();
            }
            el.visit(fmtElt);
        }

        public void visit(NodeValue nv) {
            this.out.print(nv.asQuotedString(this.context));
        }

        public void visit(ExprVar nv) {
            String s = nv.getVarName();
            if (Var.isBlankNodeVarName(s)) {
                Var v = Var.alloc(s);
                this.out.print(this.context.getBNodeMap().asString((Node)v));
            } else {
                this.out.print(nv.asSparqlExpr());
            }
        }

        public void finishVisit() {
            this.out.flush();
        }
    }
}

