/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.sparql.util.ResultSetUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSCompare {
    public static boolean same(ResultSet rs1, ResultSet rs2) {
        return RSCompare.sameUnordered(rs1, rs2);
    }

    public static boolean sameUnordered(ResultSet rs1, ResultSet rs2) {
        return ResultSetUtils.equals(rs1, rs2);
    }

    public static boolean sameOrdered(ResultSet rs1, ResultSet rs2) {
        HashMap<Node, Node> bNodeMap = new HashMap<Node, Node>();
        while (rs1.hasNext()) {
            QuerySolution qs2;
            if (!rs2.hasNext()) {
                return false;
            }
            QuerySolution qs1 = rs1.nextSolution();
            if (RSCompare.sameQuerySolution(bNodeMap, qs1, qs2 = rs2.nextSolution())) continue;
            return false;
        }
        return !rs2.hasNext();
    }

    private static boolean sameQuerySolution(Map<Node, Node> bNodeMap, QuerySolution qs1, QuerySolution qs2) {
        Iterator<String> names1 = qs1.varNames();
        Iterator<String> names2 = qs2.varNames();
        while (names1.hasNext()) {
            Node n2;
            if (!names2.hasNext()) {
                return false;
            }
            names2.next();
            String vn = names1.next();
            RDFNode rn1 = qs1.get(vn);
            RDFNode rn2 = qs2.get(vn);
            if (rn2 == null) {
                return false;
            }
            Node n1 = rn1.asNode();
            if (n1.equals((Object)(n2 = rn2.asNode()))) {
                return true;
            }
            if (!n1.isBlank() || !n2.isBlank()) {
                return false;
            }
            if (!bNodeMap.containsKey(n1)) {
                bNodeMap.put(n1, n2);
                continue;
            }
            if (bNodeMap.get(n1).equals((Object)n2)) continue;
            return false;
        }
        return !names2.hasNext();
    }
}

