/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.path;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.sparql.path.P_Alt;
import com.hp.hpl.jena.sparql.path.P_Link;
import com.hp.hpl.jena.sparql.path.P_Mod;
import com.hp.hpl.jena.sparql.path.P_Reverse;
import com.hp.hpl.jena.sparql.path.P_Seq;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.PathVisitor;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.util.iterator.Map1Iterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathEval {
    private static Logger log = LoggerFactory.getLogger(PathEval.class);

    static NodeIterator convertGraphNodeToRDFNode(final Model model, Iterator<Node> iter) {
        Map1<Node, RDFNode> conv = new Map1<Node, RDFNode>(){

            public RDFNode map1(Node obj) {
                return ModelUtils.convertGraphNodeToRDFNode(obj, model);
            }
        };
        return new NodeIteratorImpl((Iterator)new Map1Iterator((Map1)conv, iter), null);
    }

    public static NodeIterator walkForwards(Model model, RDFNode rdfNode, Path path) {
        Iterator<Node> iter = PathEval.eval(model.getGraph(), rdfNode.asNode(), path);
        return PathEval.convertGraphNodeToRDFNode(model, iter);
    }

    public static NodeIterator walkBackwards(Model model, RDFNode rdfNode, Path path) {
        Iterator<Node> iter = PathEval.evalReverse(model.getGraph(), rdfNode.asNode(), path);
        return PathEval.convertGraphNodeToRDFNode(model, iter);
    }

    public static Iterator<Node> eval(Graph graph, Node node, Path path) {
        if (node == null) {
            ALog.fatal(PathEval.class, "PathEval.eval applied to a null node");
        }
        if (node.isVariable()) {
            ALog.warn(PathEval.class, "PathEval.eval applied to a variable: " + node);
        }
        return PathEval.eval(graph, node, path, true);
    }

    public static Iterator<Node> evalReverse(Graph g, Node node, Path path) {
        return PathEval.eval(g, node, path, false);
    }

    private static Iterator<Node> eval(Graph graph, Node node, Path path, boolean forward) {
        LinkedHashSet<Node> acc = new LinkedHashSet<Node>();
        PathEval.eval(graph, node, path, forward, acc);
        return acc.iterator();
    }

    private static Iterator<Node> eval(Graph graph, Iterator<Node> input, Path path, boolean forward) {
        LinkedHashSet<Node> acc = new LinkedHashSet<Node>();
        while (input.hasNext()) {
            Node node = input.next();
            PathEval.eval(graph, node, path, forward, acc);
        }
        return acc.iterator();
    }

    private static void eval(Graph graph, Node node, Path p, boolean forward, Collection<Node> acc) {
        PathEvaluator evaluator = new PathEvaluator(graph, node, acc, forward);
        p.visit(evaluator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathEvaluator
    implements PathVisitor {
        private final Graph graph;
        private final Node node;
        private final Collection<Node> output;
        private boolean forwardMode;
        private static Map1<Triple, Node> selectObject = new Map1<Triple, Node>(){

            public Node map1(Triple triple) {
                return triple.getObject();
            }
        };
        private static Map1<Triple, Node> selectSubject = new Map1<Triple, Node>(){

            public Node map1(Triple triple) {
                return triple.getSubject();
            }
        };

        public PathEvaluator(Graph g, Node n, Collection<Node> output, boolean forward) {
            this.graph = g;
            this.node = n;
            this.output = output;
            this.forwardMode = forward;
        }

        @Override
        public void visit(P_Link pathNode) {
            Iterator<Node> nodes = this.doOne(pathNode.getNode());
            this.fill(nodes);
        }

        @Override
        public void visit(P_Reverse reversePath) {
            this.forwardMode = !this.forwardMode;
            reversePath.getSubPath().visit(this);
            this.forwardMode = !this.forwardMode;
        }

        @Override
        public void visit(P_Alt pathAlt) {
            Iterator iter = PathEval.eval(this.graph, this.node, pathAlt.getLeft(), this.forwardMode);
            this.fill(iter);
            iter = PathEval.eval(this.graph, this.node, pathAlt.getRight(), this.forwardMode);
            this.fill(iter);
        }

        @Override
        public void visit(P_Seq pathSeq) {
            Path part1 = this.forwardMode ? pathSeq.getLeft() : pathSeq.getRight();
            Path part2 = this.forwardMode ? pathSeq.getRight() : pathSeq.getLeft();
            Iterator iter = PathEval.eval(this.graph, this.node, part1, this.forwardMode);
            iter = PathEval.eval(this.graph, iter, part2, this.forwardMode);
            this.fill(iter);
        }

        @Override
        public void visit(P_Mod pathMod) {
            if (pathMod.isZeroOrMore()) {
                this.doZeroOrMore(pathMod.getSubPath());
                return;
            }
            if (pathMod.isOneOrMore()) {
                this.doOneOrMore(pathMod.getSubPath());
                return;
            }
            if (pathMod.getMin() == 0L) {
                this.output.add(this.node);
            }
            if (pathMod.getMax() == 0L) {
                return;
            }
            Iterator iter = PathEval.eval(this.graph, this.node, pathMod.getSubPath(), this.forwardMode);
            long min2 = PathEvaluator.dec(pathMod.getMin());
            long max2 = PathEvaluator.dec(pathMod.getMax());
            P_Mod nextPath = new P_Mod(pathMod.getSubPath(), min2, max2);
            while (iter.hasNext()) {
                Node n2 = (Node)iter.next();
                Iterator iter2 = PathEval.eval(this.graph, n2, nextPath, this.forwardMode);
                this.fill(iter2);
            }
        }

        private void fill(Iterator<Node> iter) {
            while (iter.hasNext()) {
                this.output.add(iter.next());
            }
        }

        private final Iterator<Node> doOne(Node property) {
            Map1Iterator iter2 = null;
            if (this.forwardMode) {
                ExtendedIterator iter1 = this.graph.find(this.node, property, Node.ANY);
                iter2 = new Map1Iterator(selectObject, (Iterator)iter1);
            } else {
                ExtendedIterator iter1 = this.graph.find(Node.ANY, property, this.node);
                iter2 = new Map1Iterator(selectSubject, (Iterator)iter1);
            }
            return iter2;
        }

        private static long dec(long x) {
            return x <= 0L ? x : x - 1L;
        }

        private void doOneOrMore(Path path) {
            Iterator iter1 = PathEval.eval(this.graph, this.node, path, this.forwardMode);
            LinkedHashSet<Node> visited = new LinkedHashSet<Node>();
            while (iter1.hasNext()) {
                Node n1 = (Node)iter1.next();
                PathEvaluator.closure(this.graph, n1, path, visited, this.forwardMode);
            }
            this.output.addAll(visited);
        }

        private void doZeroOrMore(Path path) {
            LinkedHashSet<Node> visited = new LinkedHashSet<Node>();
            PathEvaluator.closure(this.graph, this.node, path, visited, this.forwardMode);
            this.output.addAll(visited);
        }

        private static void closure(Graph graph, Node node, Path path, Collection<Node> visited, boolean forward) {
            if (visited.contains(node)) {
                return;
            }
            visited.add(node);
            Iterator iter = PathEval.eval(graph, node, path, forward);
            while (iter.hasNext()) {
                Node n2 = (Node)iter.next();
                PathEvaluator.closure(graph, n2, path, visited, forward);
            }
        }
    }
}

