/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.modify;

import com.hp.hpl.jena.sparql.modify.UpdateProcessorFactory;
import com.hp.hpl.jena.sparql.modify.UpdateProcessorMain;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.UpdateRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateProcessorRegistry {
    List<UpdateProcessorFactory> factories = new ArrayList<UpdateProcessorFactory>();
    static UpdateProcessorRegistry registry;

    public static UpdateProcessorRegistry get() {
        if (registry == null) {
            UpdateProcessorRegistry.init();
        }
        return registry;
    }

    private UpdateProcessorRegistry() {
    }

    private static synchronized void init() {
        registry = new UpdateProcessorRegistry();
        registry.add(UpdateProcessorMain.getFactory());
    }

    public static UpdateProcessorFactory findFactory(UpdateRequest request, GraphStore graphStore) {
        return UpdateProcessorRegistry.get().find(request, graphStore);
    }

    public UpdateProcessorFactory find(UpdateRequest request, GraphStore graphStore) {
        ListIterator<UpdateProcessorFactory> iter = this.factories.listIterator();
        while (iter.hasNext()) {
            UpdateProcessorFactory f = (UpdateProcessorFactory)iter.next();
            if (!f.accept(request, graphStore)) continue;
            return f;
        }
        return null;
    }

    public static void addFactory(UpdateProcessorFactory f) {
        UpdateProcessorRegistry.get().add(f);
    }

    public void add(UpdateProcessorFactory f) {
        this.factories.add(0, f);
    }

    public static void removeFactory(UpdateProcessorFactory f) {
        UpdateProcessorRegistry.get().remove(f);
    }

    public void remove(UpdateProcessorFactory f) {
        this.factories.remove(f);
    }

    public List<UpdateProcessorFactory> factories() {
        return this.factories;
    }

    public static boolean containsFactory(UpdateProcessorFactory f) {
        return UpdateProcessorRegistry.get().contains(f);
    }

    public boolean contains(UpdateProcessorFactory f) {
        return this.factories.contains(f);
    }

    static {
        UpdateProcessorRegistry.init();
        registry = null;
    }
}

