/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.sparql.core.DataSourceGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.lib.iterator.NullIterator;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceGraphImpl
implements DataSourceGraph {
    Graph defaultGraph = null;
    Map<Node, Graph> namedGraphs = null;
    Lock lock = null;

    public DataSourceGraphImpl(Graph graph) {
        this.defaultGraph = graph;
        this.namedGraphs = new HashMap<Node, Graph>();
    }

    public DataSourceGraphImpl(Model model) {
        this(model.getGraph());
    }

    public DataSourceGraphImpl(Dataset dataset) {
        this.cloneDataset(dataset);
    }

    public DataSourceGraphImpl(DatasetGraph dataset) {
        this.cloneDatasetGraph(dataset);
    }

    public DataSourceGraphImpl() {
        this(GraphUtils.makeDefaultGraph());
    }

    @Override
    public Graph getDefaultGraph() {
        return this.defaultGraph;
    }

    @Override
    public void setDefaultGraph(Graph g) {
        this.defaultGraph = g;
    }

    @Override
    public Graph getGraph(Node graphName) {
        if (this.namedGraphs == null) {
            return null;
        }
        return this.namedGraphs.get(graphName);
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        if (this.namedGraphs == null) {
            this.namedGraphs = new HashMap<Node, Graph>();
        }
        this.namedGraphs.put(graphName, graph);
    }

    @Override
    public Graph removeGraph(Node graphName) {
        if (this.namedGraphs == null) {
            return null;
        }
        return this.namedGraphs.remove(graphName);
    }

    @Override
    public boolean containsGraph(Node graphName) {
        if (this.namedGraphs == null) {
            return false;
        }
        return this.namedGraphs.containsKey(graphName);
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        if (this.namedGraphs == null) {
            return new NullIterator<Node>();
        }
        return this.namedGraphs.keySet().iterator();
    }

    @Override
    public int size() {
        return this.namedGraphs.size();
    }

    @Override
    public Lock getLock() {
        if (this.lock == null) {
            this.lock = new LockMRSW();
        }
        return this.lock;
    }

    public void cloneDataset(Dataset dataset) {
        if (dataset == null) {
            return;
        }
        if (dataset.getDefaultModel() != null) {
            this.defaultGraph = dataset.getDefaultModel().getGraph();
        }
        Iterator<String> iter = dataset.listNames();
        while (iter.hasNext()) {
            String uri = iter.next();
            Node graphRef = Node.createURI((String)uri);
            Model m = dataset.getNamedModel(uri);
            if (m == null) continue;
            this.addGraph(graphRef, m.getGraph());
        }
    }

    public DatasetGraph copy() {
        DataSourceGraphImpl ds = new DataSourceGraphImpl();
        ds.setDefaultGraph(this.getDefaultGraph());
        ds.namedGraphs = new HashMap<Node, Graph>(this.namedGraphs);
        return ds;
    }

    private void cloneDatasetGraph(DatasetGraph dataset) {
        if (!(dataset instanceof DataSourceGraphImpl)) {
            this.defaultGraph = dataset.getDefaultGraph();
            this.namedGraphs = new HashMap<Node, Graph>();
            Iterator<Node> iter = dataset.listGraphNodes();
            while (iter.hasNext()) {
                Node name = iter.next();
                this.addGraph(name, dataset.getGraph(name));
            }
            return;
        }
        DataSourceGraphImpl ds = (DataSourceGraphImpl)dataset;
        this.namedGraphs = new HashMap<Node, Graph>(ds.namedGraphs);
        this.defaultGraph = ds.defaultGraph;
    }

    public String toString() {
        String s = "{";
        s = this.getDefaultGraph() == null ? s + "<null>" : s + "[" + this.getDefaultGraph().size() + "]";
        Iterator<Node> iter = this.listGraphNodes();
        while (iter.hasNext()) {
            Node graphName = iter.next();
            String x = FmtUtils.stringForNode(graphName);
            s = s + ", (" + x + ", [" + this.getGraph(graphName).size() + "])";
        }
        s = s + "}";
        return s;
    }

    @Override
    public void close() {
        if (this.getDefaultGraph() != null) {
            this.getDefaultGraph().close();
        }
        Iterator<Node> iter = this.listGraphNodes();
        while (iter.hasNext()) {
            Node graphName = iter.next();
            Graph g = this.getGraph(graphName);
            g.close();
        }
    }
}

