/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class OpProcedure
extends Op1 {
    private Node procId;
    private ExprList args = null;

    public OpProcedure(Node procId, ExprList args, Op op) {
        super(op);
        this.args = args;
        this.procId = procId;
    }

    public OpProcedure(String iri, ExprList args, Op op) {
        this(Node.createURI((String)iri), args, op);
    }

    public String getName() {
        return "proc";
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OpProcedure)) {
            return false;
        }
        OpProcedure proc = (OpProcedure)other;
        if (!this.procId.equals((Object)proc.procId)) {
            return false;
        }
        if (!this.args.equals(proc.args)) {
            return false;
        }
        return this.getSubOp().equalTo(proc.getSubOp(), labelMap);
    }

    public int hashCode() {
        int x = this.procId.hashCode();
        x ^= this.args.hashCode();
        return x ^= this.getSubOp().hashCode();
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    public Op copy(Op subOp) {
        return new OpProcedure(this.procId, this.args, this.getSubOp());
    }

    public Node getProcId() {
        return this.procId;
    }

    public String getURI() {
        return this.procId.getURI();
    }

    public ExprList getArgs() {
        return this.args;
    }
}

