/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModBase;
import com.hp.hpl.jena.sparql.engine.main.QueryEngineMain;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineRef;
import java.util.List;

public class ModEngine
extends ModBase {
    protected final ArgDecl engineDecl = new ArgDecl(true, "engine");
    protected final ArgDecl unEngineDecl = new ArgDecl(true, "unengine", "unEngine", "removeEngine", "removeengine");
    private boolean timing = false;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Query Engine");
        cmdLine.add(this.engineDecl, "--engine=EngineName", "Register another engine factory[ref]");
        cmdLine.add(this.unEngineDecl, "--unengine=EngineName", "Unregister an engine factory");
    }

    public void checkCommandLine(CmdGeneral cmdLine) {
    }

    public void processArgs(CmdArgModule cmdLine) {
        List<String> x = cmdLine.getValues(this.engineDecl);
        for (String engineName : x) {
            if (engineName.equalsIgnoreCase("ref") || engineName.equalsIgnoreCase("reference")) {
                QueryEngineRef.register();
                continue;
            }
            if (engineName.equalsIgnoreCase("main")) {
                QueryEngineMain.register();
                continue;
            }
            throw new CmdException("Engine name not recognized: " + engineName);
        }
        List<String> y = cmdLine.getValues(this.unEngineDecl);
        for (String engineName : y) {
            if (engineName.equalsIgnoreCase("ref") || engineName.equalsIgnoreCase("reference")) {
                QueryEngineRef.unregister();
                continue;
            }
            if (engineName.equalsIgnoreCase("main")) {
                QueryEngineMain.unregister();
                continue;
            }
            throw new CmdException("Engine name not recognized: " + engineName);
        }
    }
}

