/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.utils;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.impl.model.OWLClassImpl;
import org.semanticweb.owl.impl.model.OWLConcreteDataTypeImpl;
import org.semanticweb.owl.impl.model.OWLDataPropertyImpl;
import org.semanticweb.owl.impl.model.OWLIndividualImpl;
import org.semanticweb.owl.impl.model.OWLObjectPropertyImpl;
import org.semanticweb.owl.impl.model.OWLOrImpl;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;

public class OLATools {
    int nullVerticeUriId = 0;
    private String[] excludedURIs = null;

    public OLATools(Parameters parameters) {
        String string = (String)parameters.getParameter("excludeURIs");
        if (string != null && !string.equals("")) {
            this.excludedURIs = string.split("::");
        }
    }

    public String getName(URI uRI, String string, int n) {
        String string2 = "";
        if (uRI != null) {
            string2 = uRI.getFragment();
            if (string2 == null) {
                String string3 = uRI.getPath();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
            }
        } else if (n == 1) {
            string2 = string + String.valueOf(this.nullVerticeUriId);
            ++this.nullVerticeUriId;
        }
        return string2;
    }

    public String getType(OWLIndividualImpl oWLIndividualImpl, OWLOntology oWLOntology, int n) {
        String string = "";
        Set set = oWLIndividualImpl.getTypes(oWLOntology);
        Object[] objectArray = set.toArray();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            OWLClassImpl oWLClassImpl = (OWLClassImpl)objectArray[i];
            if (oWLClassImpl == null) continue;
            string = n == 0 ? string + oWLClassImpl.getURI().toString() : string + this.getName(oWLClassImpl.getURI(), "", 1);
        }
        return string;
    }

    public String getIdentification(OWLIndividualImpl oWLIndividualImpl, OWLOntology oWLOntology) {
        String string = "";
        if (oWLIndividualImpl.getURI() == null) {
            Object[] objectArray;
            Map map = oWLIndividualImpl.getDataPropertyValues(oWLOntology);
            Object[] objectArray2 = map.keySet().toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray = (Object[])objectArray2[i];
                HashSet hashSet = (HashSet)map.get(objectArray);
                for (Object object : hashSet) {
                    string = string + object.getValue().toString();
                }
            }
            Map map2 = oWLIndividualImpl.getObjectPropertyValues(oWLOntology);
            objectArray = map2.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                OWLObjectPropertyImpl oWLObjectPropertyImpl = (OWLObjectPropertyImpl)objectArray[i];
                object = (HashSet)map2.get(oWLObjectPropertyImpl);
                Iterator iterator = ((HashSet)object).iterator();
                while (iterator.hasNext()) {
                    OWLIndividualImpl oWLIndividualImpl2 = (OWLIndividualImpl)iterator.next();
                    string = string + this.getName(oWLIndividualImpl2.getURI(), "", 0);
                }
            }
        }
        return string;
    }

    public Object[] getOperand(Object object) {
        Object[] objectArray = null;
        if (object instanceof OWLOrImpl) {
            OWLOrImpl oWLOrImpl = (OWLOrImpl)object;
            objectArray = oWLOrImpl.getOperands().toArray();
        } else {
            objectArray = new Object[]{object};
        }
        return objectArray;
    }

    public String generateCardinalityString(int n, int n2) {
        String string = "";
        string = n >= 0 ? string + Integer.toString(n) : string + Integer.toString(0);
        if (n2 >= 0) {
            string = string + ":" + Integer.toString(n2);
        }
        return string;
    }

    public String getDataPropertyRange(OWLDataPropertyImpl oWLDataPropertyImpl, OWLOntology oWLOntology) {
        String string = null;
        Object[] objectArray = oWLDataPropertyImpl.getRanges(oWLOntology).toArray();
        URI uRI = null;
        if (objectArray.length > 0) {
            uRI = ((OWLConcreteDataTypeImpl)objectArray[0]).getURI();
        }
        string = uRI == null ? "null" : this.getName(uRI, "", 0);
        return string;
    }

    public String getObjectPropertyRange(OWLObjectPropertyImpl oWLObjectPropertyImpl, OWLOntology oWLOntology) {
        String string = null;
        Object[] objectArray = oWLObjectPropertyImpl.getRanges(oWLOntology).toArray();
        URI uRI = null;
        if (objectArray.length > 0) {
            uRI = ((OWLClassImpl)objectArray[0]).getURI();
        }
        string = uRI == null ? "null" : this.getName(uRI, "", 0);
        return string;
    }

    public boolean stringFilter(String string) {
        boolean bl = false;
        if (string != null) {
            int n = string.toLowerCase().indexOf("zimmermann");
            int n2 = string.toLowerCase().indexOf("euzenat");
            int n3 = string.toLowerCase().indexOf("knouf");
            int n4 = string.toUpperCase().indexOf(".rdf");
            if (n != -1 || n2 != -1 || n3 != -1 || n4 != -1) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean haveAuthorizedURI(OWLEntity oWLEntity, boolean bl) {
        String string = "";
        if (oWLEntity == null) {
            return false;
        }
        if (this.excludedURIs != null) {
            try {
                URI uRI = oWLEntity.getURI();
                if (uRI == null) {
                    return false;
                }
                string = uRI.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (string.indexOf(35) >= 0) {
                string = string.substring(0, string.indexOf(35));
            }
            for (int i = this.excludedURIs.length - 1; i >= 0; --i) {
                if (!string.startsWith(this.excludedURIs[i])) continue;
                boolean bl2 = string.startsWith("http://www.w3.org");
                return bl2 && !bl;
            }
        }
        return true;
    }
}

