/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.selection;

import ca.uqam.info.latece.sboa.impl.selection.AssignmentMethodsImpl;
import ca.uqam.info.latece.sboa.inter.selection.AlignPairs;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrix;
import org.semanticweb.owl.model.OWLEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignPairsImpl
implements AlignPairs {
    private ArrayList<ArrayList<Object>> pool = new ArrayList();
    private Hashtable<URI, HashSet<Integer>> LUris = new Hashtable();
    private Hashtable<URI, HashSet<Integer>> RUris = new Hashtable();
    private Hashtable<URI, Integer> LUPos = new Hashtable();
    private Hashtable<URI, Integer> RUPos = new Hashtable();
    private Hashtable<Double, HashSet<Integer>> Sim = new Hashtable();
    private Matrix refIds = null;
    private int poolSz = 0;

    @Override
    public void addPair(OWLEntity oWLEntity, OWLEntity oWLEntity2, double d) {
        Double d2 = new Double(d);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(oWLEntity);
        arrayList.add(oWLEntity2);
        arrayList.add(d2);
        this.pool.add(arrayList);
        try {
            URI uRI = oWLEntity.getURI();
            URI uRI2 = oWLEntity2.getURI();
            this.LUris = this.insertURI(this.LUris, uRI, this.poolSz);
            this.RUris = this.insertURI(this.RUris, uRI2, this.poolSz);
            this.Sim = this.insertSim(this.Sim, new Double(d), this.poolSz);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ++this.poolSz;
    }

    private Hashtable<URI, HashSet<Integer>> insertURI(Hashtable<URI, HashSet<Integer>> hashtable, URI uRI, int n) {
        if (!hashtable.containsKey(uRI)) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(new Integer(n));
            hashtable.put(uRI, hashSet);
        } else {
            HashSet<Integer> hashSet = hashtable.get(uRI);
            hashSet.add(new Integer(n));
            hashtable.remove(uRI);
            hashtable.put(uRI, hashSet);
        }
        return hashtable;
    }

    private Hashtable<Double, HashSet<Integer>> insertSim(Hashtable<Double, HashSet<Integer>> hashtable, Double d, int n) {
        if (!hashtable.containsKey(d)) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(new Integer(n));
            hashtable.put(d, hashSet);
        } else {
            HashSet<Integer> hashSet = hashtable.get(d);
            hashSet.add(new Integer(n));
            hashtable.remove(d);
            hashtable.put(d, hashSet);
        }
        return hashtable;
    }

    private Hashtable<ArrayList<OWLEntity>, Double> insertCouple(Hashtable<ArrayList<OWLEntity>, Double> hashtable, HashSet<Integer> hashSet, boolean bl) {
        Object[] objectArray = hashSet.toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = (Integer)objectArray[i];
            ArrayList<Object> arrayList = this.pool.get(n2);
            double d = (Double)arrayList.get(2);
            ArrayList<OWLEntity> arrayList2 = new ArrayList<OWLEntity>();
            arrayList2.add((OWLEntity)arrayList.get(0));
            arrayList2.add((OWLEntity)arrayList.get(1));
            if (hashtable.contains(arrayList2)) {
                double d2 = hashtable.get(arrayList2);
                if (!(d2 < d)) continue;
                hashtable.remove(arrayList2);
                hashtable.put(arrayList2, new Double(d));
                continue;
            }
            if (bl && (!bl || d == 1.0)) continue;
            hashtable.put(arrayList2, new Double(d));
        }
        return hashtable;
    }

    @Override
    public Hashtable<ArrayList<OWLEntity>, Double> thresholdSelect(double d, boolean bl) {
        Hashtable<ArrayList<OWLEntity>, Double> hashtable = new Hashtable<ArrayList<OWLEntity>, Double>();
        Object[] objectArray = this.Sim.keySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Double d2 = (Double)objectArray[i];
            if (!(d2 >= d)) continue;
            HashSet<Integer> hashSet = this.Sim.get(objectArray[i]);
            hashtable = this.insertCouple(hashtable, hashSet, bl);
        }
        return hashtable;
    }

    @Override
    public Hashtable<ArrayList<OWLEntity>, Double> maxSelect(boolean bl, boolean bl2) {
        Hashtable<ArrayList<OWLEntity>, Double> hashtable = new Hashtable<ArrayList<OWLEntity>, Double>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(this.getMaxScores(this.LUris, bl2));
        hashSet.addAll(this.getMaxScores(this.RUris, bl2));
        hashtable = this.insertCouple(hashtable, hashSet, bl);
        return hashtable;
    }

    private HashSet<Integer> getMaxScores(Hashtable<URI, HashSet<Integer>> hashtable, boolean bl) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        double[] dArray = this.getMaxSim(hashtable);
        Object[] objectArray = hashtable.keySet().toArray();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object[] objectArray2 = hashtable.get(objectArray[i]).toArray();
            int n2 = objectArray2.length;
            boolean bl2 = false;
            for (int j = 0; j < n2; ++j) {
                int n3 = (Integer)objectArray2[j];
                ArrayList<Object> arrayList = this.pool.get(n3);
                double d = (Double)arrayList.get(2);
                if (!(d >= dArray[i]) || bl2) continue;
                hashSet.add(new Integer(n3));
                if (bl) continue;
                bl2 = true;
            }
        }
        return hashSet;
    }

    private double[] getMaxSim(Hashtable<URI, HashSet<Integer>> hashtable) {
        int n;
        Object[] objectArray = hashtable.keySet().toArray();
        int n2 = objectArray.length;
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            Object[] objectArray2 = hashtable.get(objectArray[n]).toArray();
            int n3 = objectArray2.length;
            for (int i = 0; i < n3; ++i) {
                int n4 = (Integer)objectArray2[i];
                ArrayList<Object> arrayList = this.pool.get(n4);
                double d = (Double)arrayList.get(2);
                if (!(d > dArray[n])) continue;
                dArray[n] = d;
            }
        }
        return dArray;
    }

    @Override
    public Hashtable<ArrayList<OWLEntity>, Double> hungarianSelect(boolean bl) {
        Hashtable<ArrayList<OWLEntity>, Double> hashtable = new Hashtable<ArrayList<OWLEntity>, Double>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = Math.max(this.LUris.size(), this.RUris.size());
        this.refIds = new DenseMatrix(n, n);
        Matrix matrix = new DenseMatrix(n, n);
        matrix = this.buildSelectionMatrix(matrix, this.LUris, this.RUris, this.LUPos, this.RUPos);
        System.err.println("Matrix built [" + matrix.numRows() + "," + matrix.numColumns() + "]");
        AssignmentMethodsImpl assignmentMethodsImpl = new AssignmentMethodsImpl();
        Matrix matrix2 = assignmentMethodsImpl.hungarian(matrix);
        System.err.println("Selection done [" + matrix2.numRows() + "," + matrix2.numColumns() + "]");
        int n2 = matrix2.numRows();
        for (int i = 0; i < n2; ++i) {
            int n3 = (int)matrix2.get(i, 0);
            int n4 = (int)matrix2.get(i, 1);
            Integer n5 = new Integer((int)this.refIds.get(n3, n4));
            hashSet.add(n5);
        }
        hashtable = this.insertCouple(hashtable, hashSet, bl);
        return hashtable;
    }

    private Matrix buildSelectionMatrix(Matrix matrix, Hashtable<URI, HashSet<Integer>> hashtable, Hashtable<URI, HashSet<Integer>> hashtable2, Hashtable<URI, Integer> hashtable3, Hashtable<URI, Integer> hashtable4) {
        int n;
        Object[] objectArray = hashtable.keySet().toArray();
        Object[] objectArray2 = hashtable2.keySet().toArray();
        int n2 = hashtable.size();
        int n3 = hashtable2.size();
        for (n = 0; n < n2; ++n) {
            hashtable3.put((URI)objectArray[n], n);
        }
        for (n = 0; n < n3; ++n) {
            hashtable4.put((URI)objectArray2[n], n);
        }
        for (n = 0; n < n2; ++n) {
            URI uRI = (URI)objectArray[n];
            int n4 = hashtable3.get(uRI);
            Object[] objectArray3 = hashtable.get(objectArray[n]).toArray();
            int n5 = objectArray3.length;
            for (int i = 0; i < n5; ++i) {
                int n6 = (Integer)objectArray3[i];
                ArrayList<Object> arrayList = this.pool.get(n6);
                double d = (Double)arrayList.get(2);
                try {
                    URI uRI2 = ((OWLEntity)arrayList.get(1)).getURI();
                    int n7 = hashtable4.get(uRI2);
                    double d2 = matrix.get(n4, n7);
                    if (!(d2 < d)) continue;
                    matrix.set(n4, n7, d);
                    this.refIds.set(n4, n7, n6);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return matrix;
    }
}

