/*
 * Decompiled with CFR 0.152.
 */
package ca.uqam.info.latece.sboa.impl.algorithms;

import ca.uqam.info.latece.sboa.impl.amatrix.OLAMatrixUpdateImpl;
import ca.uqam.info.latece.sboa.impl.encodings.OLAOntologyGraphImpl;
import ca.uqam.info.latece.sboa.impl.mgraph.MatchGraphsImpl;
import ca.uqam.info.latece.sboa.impl.selection.AlignPairsImpl;
import ca.uqam.info.latece.sboa.impl.utils.OLATools;
import ca.uqam.info.latece.sboa.impl.weights.OLAWeightCapture;
import ca.uqam.info.latece.sboa.inter.algorithms.StructureBasedAlignment;
import ca.uqam.info.latece.sboa.inter.amatrix.AdjacencyMatrix;
import ca.uqam.info.latece.sboa.inter.amatrix.OLAMatrixUpdate;
import ca.uqam.info.latece.sboa.inter.encodings.OLAOntologyGraph;
import ca.uqam.info.latece.sboa.inter.ograph.OntologyGraph;
import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import ca.uqam.info.latece.sboa.inter.ograph.VerticesPool;
import fr.inrialpes.exmo.align.impl.BasicRelation;
import fr.inrialpes.exmo.align.impl.DistanceAlignment;
import fr.inrialpes.exmo.align.impl.ObjectCell;
import fr.inrialpes.exmo.align.impl.method.StringDistances;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Hashtable;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentProcess;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;

public class OLAlignment
extends DistanceAlignment
implements StructureBasedAlignment,
AlignmentProcess {
    private Parameters par = null;
    private OntologyGraph oGraph1 = null;
    private OntologyGraph oGraph2 = null;
    private OntologyGraph mGraph = null;
    private String[] rootLab = new String[]{"Property", "PropertyInstance", "Relation"};
    private String[] rEdgeLab = new String[]{"subsumption", "restriction"};
    private String[] remVer = new String[]{"Class", "Object", "DataType", "DataValue", "Token", "Cardinality"};
    private String[] remEdg = new String[]{"subsumption", "instantiation", "attribution", "domain", "range", "valuation", "all", "card", "name"};
    private Hashtable<Integer, Integer> leftCorr = null;
    private Hashtable<Integer, Integer> rightCorr = null;
    private VerticesPool leftPool = null;
    private VerticesPool rightPool = null;
    private OLAOntologyGraph oog = null;
    private OLAWeightCapture owg = null;
    private OLAMatrixUpdate omu = null;
    private OLATools ot = null;
    private long time = 0L;
    private long newtime = 0L;
    private boolean defaultInit = false;
    private String methodName = "levenshteinDistance";
    private String distanceClass = "fr.inrialpes.exmo.align.impl.method.StringDistances";
    private Hashtable<ArrayList<OWLEntity>, Double> alignRes = new Hashtable();

    public void align(Alignment alignment, Parameters parameters) throws AlignmentException {
        this.time = System.currentTimeMillis();
        this.par = parameters;
        this.defaultInit = false;
        this.owg = new OLAWeightCapture(this.par);
        this.oog = new OLAOntologyGraphImpl(this.par);
        this.ot = new OLATools(this.par);
        this.buildOGraph((OWLOntology)this.onto1.getOntology(), (OWLOntology)this.onto2.getOntology());
        this.buildMGraph(this.distanceClass, this.methodName);
        AdjacencyMatrix adjacencyMatrix = this.mGraph.getCategoryMatrix();
        int[] nArray = adjacencyMatrix.getLineVerticeIds();
        int n = adjacencyMatrix.getNumberOfColums();
        Vector vector = this.mGraph.getInitialVector(nArray, n);
        this.leftPool = (VerticesPool)this.oGraph1.getVerticePool();
        this.rightPool = (VerticesPool)this.oGraph2.getVerticePool();
        this.prepareToCompute();
        Vector vector2 = this.computeCBSimilarity(this.mGraph, adjacencyMatrix, vector);
        this.extractResults(this.mGraph, vector2, nArray, n);
        this.clearMemory();
    }

    public void buildOGraph(OWLOntology oWLOntology, OWLOntology oWLOntology2) {
        String string;
        this.oGraph1 = this.oog.build(oWLOntology);
        this.oGraph2 = this.oog.build(oWLOntology2);
        String string2 = this.oGraph1.concactLabels("Class") + this.oGraph1.concactLabels("Relation");
        double d = StringDistances.levenshteinDistance((String)string2, (String)(string = this.oGraph2.concactLabels("Class") + this.oGraph2.concactLabels("Relation")));
        double d2 = 1.0 - d;
        if (d2 <= 0.17) {
            this.defaultInit = true;
            String[] stringArray = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i"};
            String[] stringArray2 = new String[]{"j", "k", "l", "m", "n", "o", "p", "q", "r", "s"};
            this.oGraph1.setRepresentatives(stringArray, stringArray2);
            this.oGraph2.setRepresentatives(stringArray, stringArray2);
            this.oGraph1.buildAllDefaultNames(this.rootLab, this.rEdgeLab, this.remVer, this.remEdg);
            this.oGraph2.buildAllDefaultNames(this.rootLab, this.rEdgeLab, this.remVer, this.remEdg);
            this.updateOGraphs(false);
            this.methodName = "equalDistance";
        } else {
            this.updateOGraphs(true);
        }
    }

    public void buildMGraph(String string, String string2) {
        String[] stringArray = this.oGraph1.getEdgePool().getPartsNames();
        String[] stringArray2 = this.oGraph1.getVerticePool().getPartsNames();
        MatchGraphsImpl matchGraphsImpl = new MatchGraphsImpl(this.oGraph1, this.oGraph2);
        matchGraphsImpl.categoricalProduct(stringArray, stringArray2, string, string2, this.defaultInit);
        this.mGraph = matchGraphsImpl.getOntologyGraph();
        this.leftCorr = matchGraphsImpl.getLeftCorrespondences();
        this.rightCorr = matchGraphsImpl.getRightCorrespondences();
        matchGraphsImpl.clearAll();
    }

    public void prepareToCompute() {
        this.clearOntologyGraphs();
        System.gc();
    }

    public void viewMemoryUsage(String string) {
        this.newtime = System.currentTimeMillis();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        System.err.println(string + ": " + memoryMXBean.getHeapMemoryUsage());
        System.err.println("\t>>>> ELAPSED TIME = " + (this.newtime - this.time) + " <<<<");
        this.time = System.currentTimeMillis();
    }

    public Vector computeCBSimilarity(OntologyGraph ontologyGraph, AdjacencyMatrix adjacencyMatrix, Vector vector) {
        String[] stringArray = new String[]{"DataType", "DataValue", "Token", "Cardinality"};
        int[] nArray = ontologyGraph.getStaticWeightVertices(stringArray, 4);
        int n = ontologyGraph.getNumberOfStaticWeightVertices();
        int[] nArray2 = adjacencyMatrix.getStaticLineVerticeIds(nArray, n);
        int[] nArray3 = adjacencyMatrix.getLineVerticeIds();
        int n2 = adjacencyMatrix.getNumberOfLines();
        Matrix matrix = adjacencyMatrix.getMatrix();
        matrix = this.setMatrixEntries(matrix, nArray2, n);
        adjacencyMatrix.setMatrix(matrix);
        this.omu = new OLAMatrixUpdateImpl(nArray3, nArray2, matrix.numColumns(), this.leftCorr, this.rightCorr, this.leftPool, this.rightPool);
        boolean bl = true;
        Vector vector2 = new DenseVector(n2);
        while (bl) {
            matrix = this.omu.matrixUpdate(ontologyGraph, adjacencyMatrix, vector, true, true);
            vector2 = matrix.mult(vector, vector2);
            bl = this.convergenceNotObtained(vector2, vector, n2);
            vector = vector2.copy();
        }
        return vector2;
    }

    public boolean convergenceNotObtained(Vector vector, Vector vector2, int n) {
        boolean bl = false;
        double d = this.owg.getWeight(1);
        for (int i = 0; i < n; ++i) {
            double d2 = vector.get(i) - vector2.get(i);
            if (!(d2 > d)) continue;
            return true;
        }
        return bl;
    }

    public Alignment extractResults(OntologyGraph ontologyGraph, Vector vector, int[] nArray, int n) {
        Object object;
        AlignPairsImpl alignPairsImpl = new AlignPairsImpl();
        VerticesPool verticesPool = (VerticesPool)ontologyGraph.getVerticePool();
        BasicRelation basicRelation = new BasicRelation("=");
        this.alignRes.clear();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Vertice vertice = (Vertice)verticesPool.get(nArray[i]);
            OWLEntity oWLEntity = vertice.getFirstEntity();
            object = vertice.getSecondEntity();
            double d = vector.get(i);
            boolean bl2 = this.ot.haveAuthorizedURI(oWLEntity, true);
            boolean bl3 = this.ot.haveAuthorizedURI((OWLEntity)object, true);
            boolean bl4 = bl = vertice.getCategory().equalsIgnoreCase("Object") || vertice.getCategory().equalsIgnoreCase("PropertyInstance") || vertice.getCategory().equalsIgnoreCase("DataType") || vertice.getCategory().equalsIgnoreCase("DataValue") || vertice.getCategory().equalsIgnoreCase("Token") || vertice.getCategory().equalsIgnoreCase("Cardinality");
            if (!bl2 || !bl3 || bl) continue;
            alignPairsImpl.addPair(oWLEntity, (OWLEntity)object, d);
        }
        this.alignRes = alignPairsImpl.hungarianSelect(false);
        Object[] objectArray = this.alignRes.keySet().toArray();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            object = (ArrayList)objectArray[i];
            OWLEntity oWLEntity = (OWLEntity)((ArrayList)object).get(0);
            OWLEntity oWLEntity2 = (OWLEntity)((ArrayList)object).get(1);
            Double d = this.alignRes.get(objectArray[i]);
            try {
                this.addCell((Cell)new ObjectCell((String)null, (Object)oWLEntity, (Object)oWLEntity2, (Relation)basicRelation, d.doubleValue()));
                continue;
            }
            catch (AlignmentException alignmentException) {
                alignmentException.printStackTrace();
            }
        }
        return this;
    }

    public void buildLabelMatrices(OntologyGraph ontologyGraph, OntologyGraph ontologyGraph2) {
    }

    public Vector computeFBSimilarity(OntologyGraph ontologyGraph, AdjacencyMatrix adjacencyMatrix, Vector vector) {
        return null;
    }

    private void updateOGraphs(boolean bl) {
        OLAOntologyGraphImpl oLAOntologyGraphImpl = new OLAOntologyGraphImpl(this.par);
        Object[] objectArray = this.oGraph1.getVerticePool().getAll();
        this.oGraph1 = oLAOntologyGraphImpl.completeOntologyGraph(this.oGraph1, objectArray, bl);
        OLAOntologyGraphImpl oLAOntologyGraphImpl2 = new OLAOntologyGraphImpl(this.par);
        Object[] objectArray2 = this.oGraph2.getVerticePool().getAll();
        this.oGraph2 = oLAOntologyGraphImpl2.completeOntologyGraph(this.oGraph2, objectArray2, bl);
    }

    private Matrix setMatrixEntries(Matrix matrix, int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            matrix.set(n2, n2, 1.0);
        }
        return matrix;
    }

    private void clearOntologyGraphs() {
        this.oGraph1.clearAll();
        this.oGraph1 = null;
        this.oGraph2.clearAll();
        this.oGraph2 = null;
    }

    private void clearMemory() {
        this.par = null;
        this.oGraph1 = null;
        this.oGraph2 = null;
        this.mGraph = null;
        this.leftCorr = null;
        this.rightCorr = null;
        this.leftPool = null;
        this.rightPool = null;
        this.oog = null;
        this.owg = null;
        this.omu = null;
        this.ot = null;
        this.time = 0L;
        this.newtime = 0L;
        this.defaultInit = false;
    }
}

