/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.vector.model;

import fr.inrialpes.exmo.ontosim.vector.model.Document;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;

public class DocumentCollection
extends HashSet<Document>
implements Observer {
    private static final long serialVersionUID = 1L;
    private TreeMap<String, Set<Document>> terms = new TreeMap();

    private void indexTermsOf(Document doc) {
        for (String term : doc.getTerms()) {
            this.addTermOcc(doc, term);
        }
    }

    private void addTermOcc(Document doc, String term) {
        if (!this.terms.containsKey(term)) {
            this.terms.put(term, new HashSet());
        }
        this.terms.get(term).add(doc);
    }

    public Set<String> getTerms() {
        return this.terms.keySet();
    }

    public String[] getDimensions() {
        String[] v = new String[this.terms.keySet().size()];
        return this.terms.keySet().toArray(v);
    }

    public double[] getTFIDFDocVector(Document doc) {
        if (!this.contains(doc)) {
            return null;
        }
        double[] tfVector = new double[this.terms.size()];
        int i = 0;
        for (String term : this.terms.keySet()) {
            tfVector[i] = Math.sqrt(doc.getTF(term)) * (1.0 + Math.log((double)this.size() / (double)(1 + this.terms.get(term).size())));
            ++i;
        }
        return tfVector;
    }

    public double[] getDocVector(Document doc, WEIGHT vectorType) {
        switch (vectorType) {
            case TF: {
                return this.getTFDocVector(doc);
            }
            case TFIDF: {
                return this.getTFIDFDocVector(doc);
            }
        }
        return this.getTFDocVector(doc);
    }

    public double[] getTFDocVector(Document doc) {
        if (!this.contains(doc)) {
            return null;
        }
        double[] tfVector = new double[this.terms.size()];
        int i = 0;
        for (String term : this.terms.keySet()) {
            tfVector[i] = Math.sqrt(doc.getTF(term));
            ++i;
        }
        return tfVector;
    }

    @Override
    public boolean add(Document o) {
        if (super.add(o)) {
            this.indexTermsOf(o);
            o.addObserver(this);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        super.clear();
        this.terms.clear();
    }

    public boolean remove(Document o) {
        boolean ok = true;
        super.remove(o);
        o.deleteObserver(this);
        for (String term : o.getTerms()) {
            ok = this.terms.get(term).remove(o);
        }
        return ok;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (Document.class.isInstance(o)) {
            this.addTermOcc((Document)o, (String)arg);
        }
    }

    public static enum WEIGHT {
        TF,
        TFIDF;

    }
}

