/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.vector.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

public class Document
extends Observable {
    private String name;
    private int cardDoc = 0;
    private Map<String, Integer> termsOcc = new HashMap<String, Integer>();

    public Document(String name) {
        this.name = name;
    }

    public void addOccTerm(String term) {
        ++this.cardDoc;
        if (!this.termsOcc.containsKey(term)) {
            this.termsOcc.put(term, new Integer(0));
        }
        int nbOcc = this.termsOcc.get(term) + 1;
        this.termsOcc.put(term, new Integer(nbOcc));
        this.setChanged();
        this.notifyObservers(term);
    }

    public void addOccTerms(Collection<String> terms) {
        for (String term : terms) {
            this.addOccTerm(term);
        }
    }

    public int getCardinality() {
        return this.cardDoc;
    }

    public int getNbOcc(String term) {
        if (!this.termsOcc.containsKey(term)) {
            return 0;
        }
        return this.termsOcc.get(term);
    }

    public String[] getTerms() {
        String[] terms = new String[this.termsOcc.keySet().size()];
        return this.termsOcc.keySet().toArray(terms);
    }

    public boolean contains(String term) {
        return this.termsOcc.containsKey(term);
    }

    public double getTF(String term) {
        return (double)this.getNbOcc(term) / (double)this.cardDoc;
    }

    public String getName() {
        return this.name;
    }
}

