/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.vector;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.vector.VectorMeasure;

public final class CosineVM
extends VectorMeasure {
    @Override
    public double getMeasureValue(double[] v1, double[] v2) {
        double sum = 0.0;
        double normeV1 = 0.0;
        double normeV2 = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            if (Double.isNaN(v1[i]) || Double.isNaN(v2[i])) continue;
            sum += v1[i] * v2[i];
            normeV1 += v1[i] * v1[i];
            normeV2 += v2[i] * v2[i];
        }
        if (normeV1 == 0.0 || normeV2 == 0.0) {
            return 0.0;
        }
        return sum / (Math.sqrt(normeV1) * Math.sqrt(normeV2));
    }

    @Override
    public double getDissim(double[] o1, double[] o2) {
        return 1.0 - this.getMeasureValue(o1, o2);
    }

    @Override
    public double getSim(double[] o1, double[] o2) {
        return this.getMeasureValue(o1, o2);
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.similarity;
    }
}

