/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.util.measures;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.util.matrix.HalfMatrixDouble;
import fr.inrialpes.exmo.ontosim.util.matrix.Matrix;
import fr.inrialpes.exmo.ontosim.util.matrix.MatrixDouble;
import java.lang.ref.SoftReference;

public class MeasureCache<O>
implements Measure<O> {
    protected Matrix<O, O> mValues;
    protected Measure<O> m;
    protected boolean fullMatrix;

    public MeasureCache(Measure<O> m) {
        this(m, false);
    }

    public MeasureCache(Measure<O> m, boolean fullMatrix) {
        this.m = m;
        this.fullMatrix = fullMatrix;
    }

    protected void createMatrix() {
        SoftReference sr = this.fullMatrix ? new SoftReference(new MatrixDouble()) : new SoftReference(new HalfMatrixDouble());
        this.mValues = sr.get();
    }

    @Override
    public double getDissim(O o1, O o2) {
        if (this.getMType() == Measure.TYPES.dissimilarity) {
            return this.getMeasureValue(o1, o2);
        }
        return this.m.getDissim(o1, o2);
    }

    @Override
    public Measure.TYPES getMType() {
        return this.m.getMType();
    }

    @Override
    public double getMeasureValue(O o1, O o2) {
        double val;
        if (this.mValues == null) {
            this.createMatrix();
        }
        if (Double.isNaN(val = this.mValues.get(o1, o2))) {
            val = this.m.getMeasureValue(o1, o2);
            this.mValues.put(o1, o2, val);
        }
        return val;
    }

    @Override
    public double getSim(O o1, O o2) {
        if (this.getMType() == Measure.TYPES.similarity) {
            return this.getMeasureValue(o1, o2);
        }
        return this.m.getSim(o1, o2);
    }
}

