/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.util.measures;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.util.matrix.Matrix;
import fr.inrialpes.exmo.ontosim.util.matrix.MatrixDouble;

public class CachedMeasure<O>
implements Measure<O> {
    protected Matrix<O, O> mValues;
    protected Measure.TYPES type;

    public CachedMeasure(Matrix<O, O> mValues, Measure.TYPES typeM) {
        this.mValues = mValues;
        this.type = typeM;
    }

    protected CachedMeasure(Measure.TYPES typeM) {
        this.mValues = new MatrixDouble<O, O>();
        this.type = typeM;
    }

    @Override
    public double getDissim(O o1, O o2) {
        if (this.type == Measure.TYPES.dissimilarity) {
            return this.getMeasureValue(o1, o2);
        }
        if (this.type == Measure.TYPES.similarity) {
            return 1.0 - this.getMeasureValue(o1, o2);
        }
        throw new OntoSimException("Cannot be convert into dissimilarity value");
    }

    @Override
    public Measure.TYPES getMType() {
        return this.type;
    }

    @Override
    public double getMeasureValue(O o1, O o2) {
        if (this.mValues.containsRdim(o1)) {
            return this.mValues.get(o1, o2);
        }
        if (this.mValues.containsCdim(o1)) {
            return this.mValues.get(o2, o1);
        }
        return Double.NaN;
    }

    @Override
    public double getSim(O o1, O o2) {
        if (this.type == Measure.TYPES.similarity) {
            return this.getMeasureValue(o1, o2);
        }
        if (this.type == Measure.TYPES.dissimilarity) {
            return 1.0 - this.getMeasureValue(o1, o2);
        }
        throw new OntoSimException("Cannot be convert into similarity value");
    }
}

