/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.util.matrix;

import fr.inrialpes.exmo.ontosim.util.matrix.Matrix;
import fr.inrialpes.exmo.ontosim.util.matrix.MatrixDoubleArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MatrixDouble<R, C>
implements Matrix<R, C> {
    private Map<C, Integer> col = new HashMap<C, Integer>();
    private Map<R, List<double[]>> rowVal = new HashMap<R, List<double[]>>();
    private int currentCidx = -1;
    private int cVsize = 128;

    @Override
    public synchronized void put(R r, C c, double value) {
        Integer colIdx;
        List<double[]> vals = this.rowVal.get(r);
        if (vals == null) {
            vals = new ArrayList<double[]>();
            this.rowVal.put(r, vals);
        }
        if ((colIdx = this.col.get(c)) == null) {
            ++this.currentCidx;
            colIdx = this.currentCidx;
            this.col.put(c, colIdx);
        }
        int divCidx = colIdx / this.cVsize;
        while (vals.size() <= divCidx) {
            vals.add(null);
        }
        double[] valTab = vals.get(divCidx);
        if (valTab == null) {
            valTab = new double[this.cVsize];
            Arrays.fill(valTab, Double.NaN);
            vals.set(divCidx, valTab);
        }
        valTab[colIdx.intValue() % this.cVsize] = value;
    }

    @Override
    public double get(R r, C c) {
        try {
            if (this.rowVal.containsKey(r) && this.col.containsKey(c)) {
                int cIdx = this.col.get(c);
                double[] tabRes = this.rowVal.get(r).get(cIdx / this.cVsize);
                if (tabRes != null) {
                    return tabRes[cIdx % this.cVsize];
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return Double.NaN;
    }

    @Override
    public synchronized void putAll(Matrix<R, C> m) {
        for (R r : m.getDimR()) {
            for (C c : m.getDimC()) {
                double newVal = m.get(r, c);
                if (Double.isNaN(newVal)) continue;
                this.put(r, c, newVal);
            }
        }
    }

    @Override
    public Set<R> getDimR() {
        return Collections.unmodifiableSet(this.rowVal.keySet());
    }

    @Override
    public Set<C> getDimC() {
        return Collections.unmodifiableSet(this.col.keySet());
    }

    @Override
    public Set<?> keySet() {
        HashSet<Object> keySet = new HashSet<Object>();
        keySet.addAll(this.col.keySet());
        keySet.addAll(this.rowVal.keySet());
        return keySet;
    }

    @Override
    public boolean containsRdim(R r) {
        return this.rowVal.containsKey(r);
    }

    @Override
    public boolean containsCdim(C c) {
        return this.col.containsKey(c);
    }

    public boolean containsKey(R r, C c) {
        return this.rowVal.containsKey(r) && this.col.containsKey(c) && !Double.isNaN(this.get(r, c));
    }

    @Override
    public MatrixDoubleArray<C, R> toArrayT() {
        ArrayList<R> rowL = new ArrayList<R>(this.rowVal.keySet());
        ArrayList<C> colL = new ArrayList<C>(this.col.keySet());
        double[][] vals = new double[colL.size()][rowL.size()];
        int i = 0;
        for (Object aCol : colL) {
            int j = 0;
            for (Object aRow : rowL) {
                double v = this.get(aRow, aCol);
                vals[i][j] = Double.isNaN(v) ? 0.0 : v;
                ++j;
            }
            ++i;
        }
        return new MatrixDoubleArray<C, R>(colL, rowL, vals);
    }

    @Override
    public MatrixDoubleArray<R, C> toArray() {
        ArrayList<R> rowL = new ArrayList<R>(this.rowVal.keySet());
        ArrayList<C> colL = new ArrayList<C>(this.col.keySet());
        double[][] vals = new double[rowL.size()][colL.size()];
        int i = 0;
        for (Object aRow : rowL) {
            int j = 0;
            for (Object aCol : colL) {
                double v = this.get(aRow, aCol);
                vals[i][j] = Double.isNaN(v) ? 0.0 : v;
                ++j;
            }
            ++i;
        }
        return new MatrixDoubleArray<R, C>(rowL, colL, vals);
    }
}

