/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.util.matrix;

import fr.inrialpes.exmo.ontosim.util.matrix.Matrix;
import fr.inrialpes.exmo.ontosim.util.matrix.MatrixDoubleArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HalfMatrixDouble<T>
implements Matrix<T, T> {
    public List<double[]> values = new ArrayList<double[]>();
    private Map<T, Integer> keys = new HashMap<T, Integer>();
    private int newIdx = 0;

    @Override
    public void put(T key1, T key2, double value) {
        int k2idx;
        int k1idx = this.getKeyIdx(key1);
        int maxIdx = Math.max(k1idx, k2idx = this.getKeyIdx(key2));
        double[] tabRow = this.values.get(maxIdx);
        if (tabRow == null) {
            tabRow = new double[maxIdx + 1];
            Arrays.fill(tabRow, Double.NaN);
            this.values.set(maxIdx, tabRow);
        }
        tabRow[Math.min((int)k1idx, (int)k2idx)] = value;
    }

    @Override
    public double get(T key1, T key2) {
        double[] tabRow;
        Integer k1idx = this.keys.get(key1);
        Integer k2idx = this.keys.get(key2);
        if (k1idx != null && k2idx != null && (tabRow = this.values.get(Math.max(k1idx, k2idx))) != null) {
            return tabRow[Math.min(k1idx, k2idx)];
        }
        return Double.NaN;
    }

    @Override
    public Set<T> keySet() {
        return Collections.unmodifiableSet(this.keys.keySet());
    }

    protected int getKeyIdx(T key) {
        Integer idx = this.keys.get(key);
        if (idx == null) {
            idx = new Integer(this.newIdx);
            this.keys.put(key, idx);
            this.values.add(null);
            ++this.newIdx;
        }
        return idx;
    }

    @Override
    public Set<T> getDimC() {
        return this.keySet();
    }

    @Override
    public Set<T> getDimR() {
        return this.keySet();
    }

    @Override
    public MatrixDoubleArray<T, T> toArray() {
        ArrayList<T> rowL = new ArrayList<T>(this.keySet());
        double[][] vals = new double[rowL.size()][rowL.size()];
        int i = 0;
        for (Object aRow : rowL) {
            int j = 0;
            for (Object aCol : rowL) {
                double v = this.get((T)aRow, (T)aCol);
                vals[i][j] = Double.isNaN(v) ? 0.0 : v;
                ++j;
            }
            ++i;
        }
        return new MatrixDoubleArray<T, T>(rowL, rowL, vals);
    }

    @Override
    public MatrixDoubleArray<T, T> toArrayT() {
        return this.toArray();
    }

    @Override
    public boolean containsCdim(T c) {
        return this.keys.containsKey(c);
    }

    @Override
    public boolean containsRdim(T r) {
        return this.keys.containsKey(r);
    }

    @Override
    public void putAll(Matrix<T, T> m) {
        for (T r : m.getDimR()) {
            for (T c : m.getDimC()) {
                double newVal = m.get(r, c);
                if (Double.isNaN(newVal)) continue;
                this.put(r, c, newVal);
            }
        }
    }
}

