/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.util;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MeasureFactory {
    private Map<Node, Object> mCache;

    public MeasureFactory(boolean useCache) {
        if (useCache) {
            this.mCache = new HashMap<Node, Object>();
        }
    }

    public Object getInstance(String name, Node current, String basePackage) {
        int idx;
        for (idx = 0; idx < name.length() && name.charAt(idx) != '(' && name.charAt(idx) != ')' && name.charAt(idx) != ','; ++idx) {
        }
        Node n = null;
        if (idx > 0) {
            n = new Node();
            n.name = basePackage + name.substring(0, idx);
            current.addChild(n);
            String[] args = n.name.split("=");
            try {
                n.classe = Class.forName(args[0]);
            }
            catch (ClassNotFoundException e) {
                throw new OntoSimException(args[0] + " does not exist", e);
            }
            if (args.length > 1) {
                n.instance = Enum.valueOf(n.classe, args[1]);
            }
        }
        if (idx < name.length()) {
            if (name.charAt(idx) == '(') {
                current = n;
            } else if (name.charAt(idx) == ')') {
                current = current.parent;
            }
            this.getInstance(name.substring(idx + 1), current, basePackage);
        }
        if (n != null && n.classe != null && n.instance == null) {
            this.newInstance(n);
        }
        if (current == Node.ROOT && n != null) {
            return n.instance;
        }
        return current.instance;
    }

    private Object newInstance(Node current) {
        int nbParam;
        if (this.mCache != null && this.mCache.containsKey(current)) {
            return this.mCache.get(current);
        }
        int n = nbParam = current.children == null ? 0 : current.children.size();
        if (nbParam == 0) {
            try {
                current.instance = current.classe.newInstance();
            }
            catch (Exception e) {
                throw new OntoSimException("Cannot instanciate measure " + current.name, e);
            }
        }
        Class[] cs = new Class[nbParam];
        Object[] params = new Object[nbParam];
        for (int i = 0; i < nbParam; ++i) {
            cs[i] = current.children.get((int)i).classe;
            params[i] = current.children.get((int)i).instance;
        }
        for (Constructor<?> cst : current.classe.getConstructors()) {
            Class<?>[] types = cst.getParameterTypes();
            if (types.length != nbParam) continue;
            try {
                for (int i = 0; i < nbParam; ++i) {
                    cs[i].asSubclass(types[i]);
                }
                current.instance = cst.newInstance(params);
            }
            catch (ClassCastException e) {
            }
            catch (Exception e) {
                throw new OntoSimException("Cannot instanciate measure " + current.name, e);
            }
        }
        if (current.instance == null) {
            StringBuffer sb = new StringBuffer();
            sb.append('(');
            for (Class c : cs) {
                sb.append(c.getCanonicalName());
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(')');
            throw new OntoSimException("No Constructor " + current.classe.getSimpleName() + sb.toString() + " for class " + current.classe.getCanonicalName());
        }
        if (this.mCache != null) {
            this.mCache.put(current, current.instance);
        }
        return current.instance;
    }

    public Measure<LoadedOntology<?>> getOntologyMeasure(String measureName) {
        return (Measure)this.getInstance(measureName, Node.ROOT, "");
    }

    public Measure<LoadedOntology<?>> getOntologyMeasure(String measureName, String basePackage) {
        return (Measure)this.getInstance(measureName, Node.ROOT, basePackage);
    }

    public void clearCache() {
        if (this.mCache == null) {
            return;
        }
        this.mCache.clear();
    }

    private void remove(Node n, boolean recursive) {
        this.mCache.remove(n);
        if (recursive) {
            for (Node c : n.children) {
                this.remove(c, recursive);
            }
        }
    }

    public void clearCache(Object o, boolean recursive) {
        if (this.mCache == null) {
            return;
        }
        Node node = null;
        for (Map.Entry<Node, Object> e : this.mCache.entrySet()) {
            if (e.getValue() != o) continue;
            node = e.getKey();
            break;
        }
        if (node != null) {
            this.remove(node, recursive);
        }
    }

    public static class Node {
        public static final Node ROOT = new Node();
        public String name;
        public Node parent;
        public List<Node> children;
        public Class<?> classe;
        public Object instance;

        public void addChild(Node c) {
            if (this.children == null) {
                this.children = new Vector<Node>();
            }
            this.children.add(c);
            c.parent = this;
        }

        public boolean equals(Object o) {
            if (o instanceof Node && ((Node)o).name.equals(this.name)) {
                Iterator<Node> thisChildren = this.children.iterator();
                Iterator<Node> otherChildren = ((Node)o).children.iterator();
                while (thisChildren.hasNext() && otherChildren.hasNext()) {
                    if (thisChildren.next().equals(otherChildren.next())) continue;
                    return false;
                }
                return !otherChildren.hasNext() && !thisChildren.hasNext();
            }
            return false;
        }
    }
}

