/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.util;

import fr.inrialpes.exmo.align.impl.BasicOntologyNetwork;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import fr.inrialpes.exmo.align.util.OntologyNetworkWeakener;
import fr.inrialpes.exmo.ontosim.AlignmentSpaceMeasure;
import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.VectorSpaceMeasure;
import fr.inrialpes.exmo.ontosim.util.MeasureFactory;
import fr.inrialpes.exmo.ontosim.util.REFilenameFilter;
import fr.inrialpes.exmo.ontosim.vector.model.DocumentCollection;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.OntologyNetwork;

public class BatchMeasures {
    private static final String SEP = " & ";
    public static final REFilenameFilter filter = new REFilenameFilter(".*\\.((rdf)|(owl))");

    public static void main(String[] args) throws Exception {
        String line;
        int c;
        boolean weakenT = false;
        int weaken = -1;
        int drop = -1;
        boolean invert = false;
        boolean close_matrix = false;
        boolean robustness = false;
        double max_sim = 0.0;
        double current_sim = 0.0;
        BufferedWriter logAppend = null;
        double threshold = 0.0;
        String basePackage = "fr.inrialpes.exmo.ontosim.";
        File alignDir = null;
        PrintStream out = System.out;
        LongOpt[] longopts = new LongOpt[]{new LongOpt("help", 0, null, 104), new LongOpt("outputfile", 1, null, 111), new LongOpt("aligndir", 1, null, 97), new LongOpt("factory", 1, null, 102), new LongOpt("weaken", 1, null, 119), new LongOpt("threshold", 0, null, 116), new LongOpt("invert", 0, null, 105), new LongOpt("drop", 1, null, 100), new LongOpt("close_matrix", 0, null, 99), new LongOpt("robustness", 0, null, 114)};
        Getopt opts = new Getopt(BatchMeasures.class.getCanonicalName(), args, "rcihf:a:o:w:d:t", longopts);
        block20: while ((c = opts.getopt()) != -1) {
            switch (c) {
                case 104: {
                    BatchMeasures.printUsage();
                    return;
                }
                case 102: {
                    if (opts.getOptarg().equals("JENA")) {
                        OntologyFactory.setDefaultFactory("fr.inrialpes.exmo.ontowrap.jena25.JENAOntologyFactory");
                        break;
                    }
                    if (opts.getOptarg().equals("OWLAPI1")) {
                        OntologyFactory.setDefaultFactory("fr.inrialpes.exmo.ontowrap.owlapi10.OWLAPIOntologyFactory");
                        break;
                    }
                    try {
                        OntologyFactory.setDefaultFactory(opts.getOptarg());
                    }
                    catch (Exception e) {
                        System.err.println("No such ontology factory available, it will use " + OntologyFactory.getDefaultFactory() + " instead");
                    }
                    break;
                }
                case 97: {
                    alignDir = new File(opts.getOptarg());
                    if (alignDir.isDirectory()) break;
                    System.err.println(opts.getOptarg() + " is not a directory");
                    break;
                }
                case 111: {
                    out = new PrintStream(new File(opts.getOptarg()));
                    break;
                }
                case 105: {
                    invert = true;
                    break;
                }
                case 99: {
                    close_matrix = true;
                    break;
                }
                case 114: {
                    robustness = true;
                    close_matrix = true;
                    break;
                }
                case 119: {
                    try {
                        weaken = Integer.parseInt(opts.getOptarg());
                        if (weaken >= 0 && weaken <= 100) continue block20;
                        System.err.println(opts.getOptarg() + " value must be between 0 and 100, it will not weaken alignment network");
                        weaken = -1;
                    }
                    catch (NumberFormatException e) {
                        System.err.println(opts.getOptarg() + " is not a valid number, it will not weaken alignment network");
                    }
                    break;
                }
                case 100: {
                    try {
                        drop = Integer.parseInt(opts.getOptarg());
                        if (drop >= 0 && drop <= 100) continue block20;
                        System.err.println(opts.getOptarg() + " value must be between 0 and 100, it will not weaken alignment network");
                        drop = -1;
                    }
                    catch (NumberFormatException e) {
                        System.err.println(opts.getOptarg() + " is not a valid number, it will not weaken alignment network");
                    }
                    break;
                }
                case 116: {
                    weakenT = true;
                }
            }
        }
        int a = opts.getOptind();
        if (args.length < a + 1) {
            BatchMeasures.printUsage();
            System.exit(-1);
        }
        File ontDir = new File(args[a]);
        File mFile = new File(args[a + 1]);
        OntologyFactory ontoFactory = OntologyFactory.getFactory();
        File[] ontFiles = ontDir.listFiles(filter);
        File[] alignFiles = null;
        AlignmentParser ap = null;
        Object on = null;
        if (alignDir != null) {
            alignFiles = alignDir.listFiles(filter);
            ap = new AlignmentParser(0);
            on = new BasicOntologyNetwork();
            for (File af : alignFiles) {
                ap.initAlignment(null);
                Alignment al = ap.parse(af.toURI().toString());
                on.addAlignment(al);
            }
            if (invert) {
                on.invert();
            }
            if (weaken > 0) {
                threshold = (double)weaken / 100.0;
                on = OntologyNetworkWeakener.weakenAlignments((OntologyNetwork)on, (double)threshold, (boolean)weakenT);
            }
            if (drop > 0) {
                threshold = (double)drop / 100.0;
                on = OntologyNetworkWeakener.dropAlignments((OntologyNetwork)on, (double)threshold);
            }
        }
        MeasureFactory mf = new MeasureFactory(true);
        ArrayList measures = new ArrayList();
        BufferedReader br = new BufferedReader(new FileReader(mFile));
        if (!close_matrix) {
            out.print(SEP);
        }
        while ((line = br.readLine()) != null) {
            if (line.charAt(0) == '#') continue;
            try {
                if (!close_matrix) {
                    out.print(SEP + line);
                }
                Measure<LoadedOntology<?>> m = mf.getOntologyMeasure(line, basePackage);
                measures.add(m);
                if (m instanceof VectorSpaceMeasure && ((VectorSpaceMeasure)m).getVectorType() == DocumentCollection.WEIGHT.TFIDF) {
                    for (File of : ontFiles) {
                        ((VectorSpaceMeasure)m).addOntology(ontoFactory.loadOntology(of.toURI()));
                    }
                }
                if (!(m instanceof AlignmentSpaceMeasure) || alignFiles == null) continue;
                ((AlignmentSpaceMeasure)m).setAlignmentSpace((OntologyNetwork)on);
            }
            catch (OntoSimException e) {
                e.printStackTrace();
            }
        }
        if (!close_matrix) {
            out.println();
        }
        br.close();
        if (!close_matrix) {
            for (int i = 0; i < ontFiles.length; ++i) {
                LoadedOntology loadedOntology = ontoFactory.loadOntology(ontFiles[i].toURI());
                for (int j = i; j < ontFiles.length; ++j) {
                    LoadedOntology o2 = ontoFactory.loadOntology(ontFiles[j].toURI());
                    out.print(loadedOntology.getURI() + SEP + o2.getURI());
                    for (Measure measure : measures) {
                        if (measure != null) {
                            out.print(SEP + measure.getSim(loadedOntology, o2));
                            continue;
                        }
                        out.print(" & err");
                    }
                    out.println();
                }
            }
            out.close();
        } else {
            for (Measure measure : measures) {
                if (robustness) {
                    logAppend = new BufferedWriter(new FileWriter(measure.getClass().toString().substring(measure.getClass().toString().lastIndexOf(".") + 1) + ".cls", true));
                    logAppend.write(new Double(threshold).toString());
                    logAppend.write(SEP);
                } else {
                    out.print(measure.getClass().toString().substring(measure.getClass().toString().lastIndexOf(".") + 1) + SEP);
                }
                for (int i = 0; i < ontFiles.length; ++i) {
                    max_sim = 0.0;
                    ArrayList<String> closest_ontologies = new ArrayList<String>();
                    LoadedOntology o1 = ontoFactory.loadOntology(ontFiles[i].toURI());
                    for (int j = 0; j < ontFiles.length; ++j) {
                        if (i == j) continue;
                        LoadedOntology loadedOntology = ontoFactory.loadOntology(ontFiles[j].toURI());
                        if (measure != null) {
                            current_sim = measure.getSim(o1, loadedOntology);
                            if (current_sim == 0.0) continue;
                            if (max_sim == current_sim) {
                                closest_ontologies.add(loadedOntology.getURI().toString());
                                continue;
                            }
                            if (!(max_sim < current_sim)) continue;
                            closest_ontologies.clear();
                            closest_ontologies.add(loadedOntology.getURI().toString());
                            max_sim = current_sim;
                            continue;
                        }
                        if (robustness) {
                            logAppend.write(" & err");
                            continue;
                        }
                        out.print(" & err");
                    }
                    for (String string : closest_ontologies) {
                        if (robustness) {
                            logAppend.write(string + " ");
                            continue;
                        }
                        out.print(string + " ");
                    }
                    if (robustness) {
                        if (i == ontFiles.length - 1) continue;
                        logAppend.write(SEP);
                        continue;
                    }
                    if (i == ontFiles.length - 1) continue;
                    out.print(SEP);
                }
                if (robustness) {
                    logAppend.write("\\\\ \n");
                } else {
                    out.println("\\\\");
                }
                if (!robustness) continue;
                logAppend.close();
            }
            out.close();
        }
    }

    public static final void printUsage() {
        System.err.println("java " + BatchMeasures.class.getCanonicalName() + " [options] ontodir measurefile");
        System.err.println("where the options are:");
        System.err.println("\t--aligndir=dirname -a dirname Use alignments contained in this directory (load all .rdf or .owl files)");
        System.err.println("\t--output=filename -o filename Output the results in filename (stdout by default)");
        System.err.println("\t--factory=[OWL|JENA|OntologyFactory subclass] -f [OWL|JENA|OntologyFactory subclass] Use the specified factory for loading ontologies");
        System.err.println("\t--weaken=n -w n Suppress n% of the correspondences at random in all alignments");
        System.err.println("\t--threshold -t Tells if the correspondences are suppressed at random of by suppressing the n% of lower confidence");
        System.err.println("\t--drop=n -d n Suppress n% of the alignments at random in the network");
        System.err.println("\t--close_matrix -c It will generate closeness_matrix for assessing degree of agreement");
        System.err.println("\t--robustness -r It will generate several (degradated) closeness_matrixes for each measure (in combination with -d or -w), robustness");
        System.err.println("\t--invert -i Use the reflexive closure of the network");
        System.err.println("\t--help -h                       Print this message");
        System.err.println("ontodir is a directory which contains only the ontologies to compare (ontologies filename must finish by extension .owl or .rdf)");
        System.err.println("measurefile is a text file where each line is the name of a measure to compute. examples : \n\t VectorSpaceMeasure(fr.inrialpes.exmo.ontosim.vector.CosineVM,vector.model.DocumentCollection$WEIGHT=TFIDF) \n\t OntologySpaceMeasure(set.MaxCoupling(entity.EntityLexicalMeasure))");
    }
}

