/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.string;

import com.wcohen.ss.AbstractStringDistance;
import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.OntoSimException;

public class StringMeasureSS
implements Measure<String> {
    private AbstractStringDistance sd;

    public StringMeasureSS(AbstractStringDistance d) {
        this.sd = d;
    }

    @Override
    public double getMeasureValue(String o1, String o2) {
        if (o1.equals(o2)) {
            return 1.0;
        }
        double sim = this.sd.score(o1, o2);
        if (Double.isNaN(sim)) {
            return 0.0;
        }
        return sim;
    }

    @Override
    public double getDissim(String o1, String o2) {
        return 1.0 - this.getMeasureValue(o1, o2);
    }

    @Override
    public double getSim(String o1, String o2) {
        double val = this.getMeasureValue(o1, o2);
        if (val > 1.0) {
            throw new OntoSimException("Similarity value greater than 1, " + this.sd.getClass().getName() + " seems not to be a similarity measure");
        }
        return val;
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.similarity;
    }
}

