/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.string;

import java.util.Vector;
import org.ivml.alimo.ISub;

public class StringDistances {
    public static double subStringDistance(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 1.0;
        }
        int l1 = s1.length();
        int l2 = s2.length();
        if (l1 == 0 && l2 == 0) {
            return 0.0;
        }
        if (l1 == 0 || l2 == 0) {
            return 1.0;
        }
        int best = 0;
        int i = 0;
        int j = 0;
        for (i = 0; i < l1 && l1 - i > best; ++i) {
            j = 0;
            while (l2 - j > best) {
                int k = i;
                while (j < l2 && s1.charAt(k) != s2.charAt(j)) {
                    ++j;
                }
                if (j == l2) continue;
                ++j;
                ++k;
                while (j < l2 && k < l1 && s1.charAt(k) == s2.charAt(j)) {
                    ++j;
                    ++k;
                }
                best = Math.max(best, k - i);
            }
        }
        return 1.0 - 2.0 * (double)best / (double)(l1 + l2);
    }

    public static double equalDistance(String s, String t) {
        if (s == null || t == null) {
            return 1.0;
        }
        if (s.equals(t)) {
            return 0.0;
        }
        return 1.0;
    }

    public static double hammingDistance(String s, String t) {
        int max;
        if (s == null || t == null) {
            return 1.0;
        }
        int l1 = s.length();
        int l2 = t.length();
        int min = Math.min(l1, l2);
        int score = max = Math.max(l1, l2);
        for (int i = 0; i < min; ++i) {
            if (s.charAt(i) != t.charAt(i)) continue;
            --score;
        }
        return (double)score / (double)max;
    }

    public static double jaroMeasure(String s, String t) {
        if (s == null || t == null) {
            return 1.0;
        }
        int l1 = s.length();
        int l2 = t.length();
        int span = Math.min(l1, l2) / 2;
        int i = 0;
        int j = 0;
        int comps = 0;
        int compt = 0;
        int transp = 0;
        char lastchars = '\u0000';
        while (i < l1 || j < l2) {
            int k;
            if (j < l2 && comps > compt || i > l1) {
                for (k = Math.max(0, j - span); k < Math.min(l1, j + span); ++k) {
                    if (t.charAt(j) != s.charAt(k)) continue;
                    ++compt;
                    if (t.charAt(j) == lastchars) {
                        ++transp;
                    }
                    k = l1;
                }
                ++j;
                continue;
            }
            if (i == l1) {
                lastchars = '\u0000';
                i = l1 + 1;
                continue;
            }
            for (k = Math.max(0, i - span); k < Math.min(l2, i + span); ++k) {
                if (t.charAt(k) != s.charAt(i)) continue;
                ++comps;
                lastchars = s.charAt(i);
                k = l2;
            }
            ++i;
        }
        if ((double)comps == 0.0) {
            return 1.0;
        }
        return 1.0 - ((double)comps / (double)l1 + (double)compt / (double)l2 + (double)transp / (double)comps) / 3.0;
    }

    public static double jaroWinklerMeasure(String s, String t) {
        int PREFIX = 4;
        double jaro = StringDistances.jaroMeasure(s, t);
        return jaro + (double)PREFIX * (1.0 - jaro) / 10.0;
    }

    public static double ngramDistance(String s, String t) {
        int n = 3;
        if (s == null || t == null) {
            return 1.0;
        }
        int l1 = s.length() - n + 1;
        int l2 = t.length() - n + 1;
        int found = 0;
        for (int i = 0; i < l1; ++i) {
            for (int j = 0; j < l2; ++j) {
                int k;
                for (k = 0; k < n && s.charAt(i + k) == t.charAt(j + k); ++k) {
                }
                if (k != n) continue;
                ++found;
            }
        }
        return 1.0 - 2.0 * (double)found / (double)(l1 + l2);
    }

    public static double levenshteinDistance(String s, String t) {
        return StringDistances.needlemanWunschDistance(s, t, 1);
    }

    public static double needlemanWunsch2Distance(String s, String t) {
        return StringDistances.needlemanWunschDistance(s, t, 2);
    }

    public static double needlemanWunschDistance(String s, String t, int gap) {
        int i;
        if (s == null || t == null) {
            return 1.0;
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return 1.0;
        }
        if (m == 0) {
            return 1.0;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i * gap;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j * gap;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + gap, p[i] + gap), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        int min = Math.min(n, m);
        int diff = Math.max(n, m) - min;
        return (double)p[n] / (double)(min + diff * gap);
    }

    public static double smoaDistance(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return 1.0;
        }
        ISub metrics = new ISub();
        return 1.0 - metrics.score(s1, s2);
    }

    public static String stripQuotations(String s) {
        int sStart;
        int sLength = s.length();
        String result = "";
        int sEnd = sStart = 0;
        while (sStart < sLength) {
            while (sEnd < sLength && s.charAt(sStart) != '\"') {
                ++sEnd;
            }
            if (sEnd < sLength) {
                result = result + s.substring(sStart, sEnd);
            }
            while (sEnd < sLength && s.charAt(sStart) != '\"') {
                ++sEnd;
            }
            sStart = sEnd;
        }
        return result;
    }

    public static Vector<String> tokenize(String s) {
        int tkStart;
        String str1 = s;
        int sLength = s.length();
        Vector<String> vTokens = new Vector<String>();
        int tkEnd = 0;
        for (tkStart = 0; tkStart < sLength && StringDistances.isAlphaNum(str1.charAt(tkStart)); ++tkStart) {
        }
        if (tkStart < sLength) {
            for (tkStart = 0; tkStart < sLength && !StringDistances.isAlphaNum(str1.charAt(tkStart)); ++tkStart) {
            }
            tkEnd = tkStart;
            while (tkStart < sLength) {
                if (StringDistances.isAlpha(str1.charAt(tkEnd))) {
                    while (tkEnd < sLength && StringDistances.isAlpha(str1.charAt(tkEnd))) {
                        ++tkEnd;
                    }
                } else {
                    while (tkEnd < sLength && StringDistances.isNum(str1.charAt(tkEnd))) {
                        ++tkEnd;
                    }
                }
                vTokens.add(str1.substring(tkStart, tkEnd));
                while (tkEnd < sLength && !StringDistances.isAlphaNum(str1.charAt(tkEnd))) {
                    ++tkEnd;
                }
                tkStart = tkEnd;
            }
        } else {
            tkEnd = tkStart = 0;
            while (tkStart < sLength) {
                if (StringDistances.isAlpha(str1.charAt(tkEnd))) {
                    if (StringDistances.isAlphaCap(str1.charAt(tkEnd))) {
                        while (tkEnd < sLength && StringDistances.isAlphaCap(str1.charAt(tkEnd))) {
                            ++tkEnd;
                        }
                        if (tkEnd == sLength || StringDistances.isNum(str1.charAt(tkEnd))) {
                            vTokens.add(str1.substring(tkStart, tkEnd));
                            tkStart = tkEnd;
                            continue;
                        }
                        if (tkEnd - tkStart <= 2) continue;
                        vTokens.add(str1.substring(tkStart, tkEnd - 1));
                        tkStart = tkEnd - 1;
                        continue;
                    }
                    while (tkEnd < sLength && StringDistances.isAlphaSmall(str1.charAt(tkEnd))) {
                        ++tkEnd;
                    }
                    vTokens.add(str1.substring(tkStart, tkEnd));
                    tkStart = tkEnd;
                    continue;
                }
                while (tkEnd < sLength && StringDistances.isNum(str1.charAt(tkEnd))) {
                    ++tkEnd;
                }
                vTokens.add(str1.substring(tkStart, tkEnd));
                tkStart = tkEnd;
            }
        }
        return vTokens;
    }

    public Vector<String> tokenizeDep(String s) {
        int start;
        Vector<String> sTokens = new Vector<String>();
        String str1 = s;
        for (start = 0; start < str1.length() && (str1.charAt(start) < 'A' || str1.charAt(start) > 'z') || str1.charAt(start) < 'a' && str1.charAt(start) > 'Z'; ++start) {
        }
        int car = start + 1;
        while (car < str1.length()) {
            while (car < str1.length() && str1.charAt(car) >= 'a' && str1.charAt(car) <= 'z') {
                ++car;
            }
            if (car < str1.length() && str1.charAt(car) >= 'A' && str1.charAt(car) <= 'Z') {
                if (car < str1.length() - 1 && (str1.charAt(car + 1) < 'a' || str1.charAt(car + 1) > 'z')) {
                    ++car;
                } else if (car == str1.length() - 1) {
                    ++car;
                }
            }
            sTokens.add(str1.substring(start, car));
            for (start = car; start < str1.length() && (str1.charAt(start) < 'A' || str1.charAt(start) > 'z' || str1.charAt(start) < 'a' && str1.charAt(start) > 'Z'); ++start) {
            }
            car = start + 1;
        }
        return sTokens;
    }

    public static boolean isAlphaNum(char c) {
        return StringDistances.isAlpha(c) || StringDistances.isNum(c);
    }

    public static boolean isAlpha(char c) {
        return StringDistances.isAlphaCap(c) || StringDistances.isAlphaSmall(c);
    }

    public static boolean isAlphaCap(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isAlphaSmall(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isNum(char c) {
        return c >= '0' && c <= '9';
    }
}

