/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.string;

import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.string.StringDistances;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.dictionary.Dictionary;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JWNLDistances {
    public static final double NOUN_WEIGHT = 0.6;
    public static final double ADJ_WEIGHT = 0.25;
    public static final double VERB_WEIGHT = 0.15;
    private static final double MINIMUM_DISTANCE = 0.05;
    double[][] nounsResults;
    double[][] verbsResults;
    double[][] adjectivesResults;
    double[][] nounsMasks;
    double[][] verbsMasks;
    double[][] adjectivesMasks;
    private Hashtable nouns1 = new Hashtable();
    private Hashtable adjectives1 = new Hashtable();
    private Hashtable verbs1 = new Hashtable();
    private Hashtable nouns2 = new Hashtable();
    private Hashtable adjectives2 = new Hashtable();
    private Hashtable verbs2 = new Hashtable();

    public void Initialize() throws OntoSimException {
        this.Initialize(null, null);
    }

    public void Initialize(String wordnetdir, String wordnetversion) throws OntoSimException {
        if (!JWNL.isInitialized()) {
            InputStream pptySource = null;
            if (wordnetdir == null) {
                try {
                    pptySource = new FileInputStream("./file_properties.xml");
                }
                catch (FileNotFoundException e) {
                    throw new OntoSimException("Cannot find WordNet dictionary: use -Dwndict or file_property.xml");
                }
            } else {
                String properties = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
                properties = properties + "<jwnl_properties language=\"en\">";
                properties = properties + "  <resource class=\"PrincetonResource\"/>";
                properties = properties + "  <version publisher=\"Princeton\" number=\"" + wordnetversion + "\" language=\"en\"/>";
                properties = properties + "  <dictionary class=\"net.didion.jwnl.dictionary.FileBackedDictionary\">";
                properties = properties + "     <param name=\"dictionary_element_factory\" value=\"net.didion.jwnl.princeton.data.PrincetonWN17FileDictionaryElementFactory\"/>";
                properties = properties + "     <param name=\"file_manager\" value=\"net.didion.jwnl.dictionary.file_manager.FileManagerImpl\">";
                properties = properties + "       <param name=\"file_type\" value=\"net.didion.jwnl.princeton.file.PrincetonRandomAccessDictionaryFile\"/>";
                properties = properties + "       <param name=\"dictionary_path\" value=\"" + wordnetdir + "\"/>";
                properties = properties + "     </param>";
                properties = properties + "  </dictionary>";
                properties = properties + "</jwnl_properties>";
                pptySource = new ByteArrayInputStream(properties.getBytes());
            }
            try {
                Logger.getLogger((String)"net.didion.jwnl").setLevel(Level.ERROR);
                JWNL.initialize((InputStream)pptySource);
            }
            catch (JWNLException e) {
                throw new OntoSimException("Cannot initialize JWNL (WordNet)", (Exception)((Object)e));
            }
        }
    }

    public double basicSynonymDistance(String s1, String s2) {
        Dictionary dictionary = Dictionary.getInstance();
        double Dist = 0.0;
        int k = 0;
        int synonymNb = 0;
        int besti = 0;
        int bestj = 0;
        IndexWord index = null;
        Synset[] Syno = null;
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        double Dists1s2 = StringDistances.subStringDistance(s1, s2);
        try {
            index = dictionary.lookupIndexWord(POS.NOUN, s1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        if (index != null) {
            try {
                Syno = index.getSenses();
            }
            catch (JWNLException e) {
                e.printStackTrace();
            }
            synonymNb = index.getSenseCount();
            double[] DistTab = new double[synonymNb];
            for (k = 0; k < synonymNb; ++k) {
                for (int j = 0; j < Syno[k].getWordsSize(); ++j) {
                    Dist = StringDistances.subStringDistance(Syno[k].getWord(j).getLemma(), s2);
                    if (!(Dist < Dists1s2)) continue;
                    Dists1s2 = Dist;
                    besti = k;
                    bestj = j;
                }
            }
        }
        return Dists1s2;
    }

    Set<Synset> getAllSenses(String term) throws OntoSimException {
        int nbpos;
        HashSet<Synset> res = null;
        IndexWord[] iws = null;
        try {
            iws = Dictionary.getInstance().lookupAllIndexWords(term).getIndexWordArray();
        }
        catch (JWNLException ex) {
            throw new OntoSimException("Wordnet exception", (Exception)((Object)ex));
        }
        if (iws != null && (nbpos = iws.length) != 0) {
            res = new HashSet<Synset>();
            for (int i = 0; i < nbpos; ++i) {
                int nb = iws[i].getSenseCount();
                Synset[] Senses = null;
                try {
                    Senses = iws[i].getSenses();
                }
                catch (JWNLException ex) {
                    throw new OntoSimException("Wordnet exception", (Exception)((Object)ex));
                }
                for (int j = 0; j < nb; ++j) {
                    res.add(Senses[j]);
                }
            }
        }
        return res;
    }

    public double cosynonymySimilarity(String s1, String s2) throws OntoSimException {
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        Set<Synset> sense1 = this.getAllSenses(s1);
        Set<Synset> sense2 = this.getAllSenses(s2);
        if (sense1 != null && sense2 != null) {
            int union = sense1.size();
            int inter = 0;
            for (Synset s : sense2) {
                if (s.containsWord(s1)) {
                    ++inter;
                    continue;
                }
                ++union;
            }
            return (double)inter / (double)union;
        }
        return 1.0 - StringDistances.equalDistance(s1, s2);
    }

    public double basicSynonymySimilarity(String s1, String s2) throws OntoSimException {
        if ((s1 = s1.toLowerCase()).equals(s2 = s2.toLowerCase())) {
            return 1.0;
        }
        Set<Synset> sense1 = this.getAllSenses(s1);
        for (Synset s : sense1) {
            if (!s.containsWord(s2)) continue;
            return 1.0;
        }
        return 0.0;
    }

    public double basicGlossOverlap(String s1, String s2) throws OntoSimException {
        Dictionary dictionary = Dictionary.getInstance();
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        Set<Synset> sense1 = this.getAllSenses(s1);
        Set<Synset> sense2 = this.getAllSenses(s2);
        if (sense1 != null && sense2 != null) {
            String gloss1 = "" + s1;
            for (Synset s : sense1) {
                gloss1 = gloss1 + " " + StringDistances.stripQuotations(s.getGloss());
            }
            String gloss2 = "" + s2;
            for (Synset s : sense2) {
                gloss2 = gloss2 + " " + StringDistances.stripQuotations(s.getGloss());
            }
            Vector<String> t1 = StringDistances.tokenize(gloss1);
            Vector<String> t2 = StringDistances.tokenize(gloss2);
            int union = t1.size() + t2.size();
            int inter = 0;
            return inter / union;
        }
        return 1.0 - StringDistances.subStringDistance(s1, s2);
    }

    public double wuPalmerSimilarity(String s1, String s2) throws OntoSimException {
        Synset current;
        Dictionary dictionary = Dictionary.getInstance();
        Hashtable<Synset, int[]> depth = new Hashtable<Synset, int[]>();
        if ((s1 = s1.toLowerCase()).equals(s2 = s2.toLowerCase())) {
            return 1.0;
        }
        Set<Synset> sense1 = this.getAllSenses(s1);
        Set<Synset> sense2 = this.getAllSenses(s2);
        Stack<Synset> queue = new Stack<Synset>();
        for (Synset s : sense1) {
            int[] v = new int[]{0, -1, -1};
            depth.put(s, v);
            queue.push(s);
        }
        Stack<Synset> passed = new Stack<Synset>();
        while (!queue.empty()) {
            Synset curnode = (Synset)queue.pop();
            int[] curval = (int[])depth.get(curnode);
            int curdepth = curval[0];
            try {
                PointerTarget[] hyps = curnode.getTargets(PointerType.HYPERNYM);
                if (hyps.length == 0) {
                    int level;
                    curval[2] = level = 0;
                    boolean firstmark = false;
                    for (int i = passed.size() - 1; i >= 0; --i) {
                        Synset current2 = (Synset)passed.get(i);
                        if (!firstmark) {
                            passed.pop();
                        }
                        if (current2 != null) {
                            int[] val = (int[])depth.get(current2);
                            if (val[2] != -1 && val[2] <= ++level) continue;
                            val[2] = level;
                            continue;
                        }
                        firstmark = true;
                    }
                    continue;
                }
                passed.push(curnode);
                PointerTarget[] arr$ = hyps;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    PointerTarget s = arr$[i$];
                    if (!(s instanceof Synset)) continue;
                    current = (Synset)s;
                    int[] val = (int[])depth.get(current);
                    if (val == null) {
                        int[] v = new int[]{curdepth + 1, -1, -1};
                        depth.put(current, v);
                        queue.push(current);
                        passed.push(null);
                        continue;
                    }
                    if (val[0] > curdepth + 1) {
                        val[0] = curdepth + 1;
                        queue.push(current);
                        passed.push(null);
                        continue;
                    }
                    int level = val[0];
                    for (int i = passed.size() - 1; i >= 0; --i) {
                        int[] v;
                        Synset n = (Synset)passed.get(i);
                        if (n == null || (v = (int[])depth.get(n))[2] != -1 && v[2] <= ++level) continue;
                        v[2] = level;
                    }
                }
                passed.pop();
            }
            catch (JWNLException ex) {}
        }
        double bestvalue = 0.0;
        for (Synset s : sense2) {
            queue.push(s);
            int[] val = (int[])depth.get(s);
            if (val == null) {
                int[] v = new int[]{-1, 0, -1};
                depth.put(s, v);
                continue;
            }
            val[1] = 0;
            double newvalue = (double)(2 * val[2]) / (double)(val[0] + 2 * val[2]);
            if (!(newvalue > bestvalue)) continue;
            bestvalue = newvalue;
        }
        while (!queue.empty()) {
            Synset s = (Synset)queue.pop();
            int i = ((int[])depth.get(s))[1];
            try {
                for (PointerTarget h : s.getTargets(PointerType.HYPERNYM)) {
                    if (!(h instanceof Synset)) continue;
                    current = (Synset)h;
                    int[] level = (int[])depth.get(current);
                    if (level == null) {
                        int[] v = new int[]{-1, i + 1, -1};
                        depth.put(current, v);
                        queue.push(current);
                        continue;
                    }
                    if (level[0] != -1) {
                        level[1] = i + 1;
                        double newvalue = (double)(2 * level[2]) / (double)(level[0] + i + 1 + 2 * level[2]);
                        if (!(newvalue > bestvalue)) continue;
                        bestvalue = newvalue;
                        continue;
                    }
                    if (level[1] <= i + 1) continue;
                    level[1] = i + 1;
                    queue.push(current);
                }
            }
            catch (JWNLException ex) {
            }
        }
        return bestvalue;
    }

    public double computeSimilarity(String s1, String s2) {
        Dictionary dictionary = Dictionary.getInstance();
        double sim = 0.0;
        IndexWord index = null;
        double dists1s2 = StringDistances.subStringDistance(s1, s2);
        if (dists1s2 < 0.05) {
            return 1.0 - dists1s2;
        }
        if (s1.equals(s2) || s1.toLowerCase().equals(s2.toLowerCase())) {
            return 1.0;
        }
        if (s1.equals(s1.toUpperCase()) || s1.equals(s1.toLowerCase())) {
            try {
                index = dictionary.lookupIndexWord(POS.NOUN, s1);
                if (index == null) {
                    index = dictionary.lookupIndexWord(POS.ADJECTIVE, s1);
                }
                if (index == null) {
                    index = dictionary.lookupIndexWord(POS.VERB, s1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(-1);
            }
            if (index == null) {
                return 1.0 - dists1s2;
            }
            sim = this.compareComponentNames(s1, s2);
        } else {
            sim = this.compareComponentNames(s1, s2);
        }
        return Math.max(sim, 1.0 - dists1s2);
    }

    public double compareComponentNames(String s1, String s2) {
        Dictionary dictionary = Dictionary.getInstance();
        Vector<String> s1Tokens = StringDistances.tokenize(s1);
        Vector<String> s2Tokens = StringDistances.tokenize(s2);
        Vector<String> vg = s1Tokens.size() >= s2Tokens.size() ? s1Tokens : s2Tokens;
        Vector<String> vp = s1Tokens.size() >= s2Tokens.size() ? s2Tokens : s1Tokens;
        double[][] simMatrix = new double[vg.size()][vp.size()];
        int i = 0;
        Iterator<String> gIt = vg.iterator();
        try {
            while (gIt.hasNext()) {
                String token1 = gIt.next();
                IndexWord indexNoun1 = dictionary.lookupIndexWord(POS.NOUN, token1);
                IndexWord indexAdj1 = dictionary.lookupIndexWord(POS.ADJECTIVE, token1);
                IndexWord indexVerb1 = dictionary.lookupIndexWord(POS.VERB, token1);
                int j = 0;
                for (String token2 : vp) {
                    double simAsAdj;
                    IndexWord indexNoun2 = dictionary.lookupIndexWord(POS.NOUN, token2);
                    IndexWord indexAdj2 = dictionary.lookupIndexWord(POS.ADJECTIVE, token2);
                    IndexWord indexVerb2 = dictionary.lookupIndexWord(POS.VERB, token2);
                    double maxSim = simAsAdj = this.computeTokenSimilarity(indexAdj1, indexAdj2);
                    double simAsNoun = this.computeTokenSimilarity(indexNoun1, indexNoun2);
                    maxSim = simAsNoun > maxSim ? simAsNoun : maxSim;
                    double simAsVerb = this.computeTokenSimilarity(indexVerb1, indexVerb2);
                    simMatrix[i][j] = maxSim = simAsVerb > maxSim ? simAsVerb : maxSim;
                    ++j;
                }
                ++i;
            }
        }
        catch (JWNLException ex) {
            ex.printStackTrace();
        }
        return this.bestMatch(simMatrix);
    }

    public double computeTokenSimilarity(IndexWord index1, IndexWord index2) {
        double maxCommon = 0.0;
        PointerTargetNodeList best1 = new PointerTargetNodeList();
        PointerTargetNodeList best2 = new PointerTargetNodeList();
        PointerTargetNodeList ptnl12 = new PointerTargetNodeList();
        PointerTargetNodeList ptnl22 = new PointerTargetNodeList();
        if (index1 != null && index2 != null) {
            try {
                int maxBetweenLists = 0;
                Synset[] Syno1 = index1.getSenses();
                Synset[] Syno2 = index2.getSenses();
                for (int i = 0; i < index1.getSenseCount(); ++i) {
                    Synset synset1 = Syno1[i];
                    for (int k = 0; k < index2.getSenseCount(); ++k) {
                        Synset synset2 = Syno2[k];
                        List hypernymList1 = PointerUtils.getInstance().getHypernymTree(synset1).toList();
                        List hypernymList2 = PointerUtils.getInstance().getHypernymTree(synset2).toList();
                        for (PointerTargetNodeList ptnl12 : hypernymList1) {
                            for (PointerTargetNodeList ptnl22 : hypernymList2) {
                                int cc = this.getCommonConcepts(ptnl12, ptnl22);
                                if (cc <= maxBetweenLists) continue;
                                maxBetweenLists = cc;
                                best1 = ptnl12;
                                best2 = ptnl22;
                            }
                        }
                        if (!((double)maxBetweenLists > maxCommon)) continue;
                        maxCommon = maxBetweenLists;
                    }
                }
                if (best1.isEmpty() && best2.isEmpty()) {
                    return 0.0;
                }
                return 2.0 * maxCommon / (double)(best1.size() + best2.size());
            }
            catch (JWNLException je) {
                je.printStackTrace();
                System.exit(-1);
            }
        }
        return 0.0;
    }

    public double findMatchForAdj(IndexWord index1, IndexWord index2) {
        double value = 0.0;
        if (index1 != null && index2 != null) {
            try {
                Synset[] Syno1 = index1.getSenses();
                Synset[] Syno2 = index2.getSenses();
                for (int i = 0; i < index1.getSenseCount(); ++i) {
                    Synset synset1 = Syno1[i];
                    for (int k = 0; k < index2.getSenseCount(); ++k) {
                        Synset synset2 = Syno2[k];
                        PointerTargetNodeList adjSynonymList = PointerUtils.getInstance().getSynonyms(synset1);
                        for (PointerTargetNode ptn : adjSynonymList) {
                            if (ptn.getSynset() != synset2) continue;
                            value = 1.0;
                        }
                    }
                }
                return value;
            }
            catch (JWNLException je) {
                je.printStackTrace();
                System.exit(-1);
            }
        }
        return 0.0;
    }

    public void lookUpWord(String word, Hashtable<String, IndexWord> nouns, Hashtable<String, IndexWord> adjectives, Hashtable<String, IndexWord> verbs) {
        Dictionary dictionary = Dictionary.getInstance();
        IndexWord index = null;
        try {
            index = dictionary.lookupIndexWord(POS.ADJECTIVE, word);
            if (index != null) {
                adjectives.put(word, index);
            }
            if ((index = dictionary.lookupIndexWord(POS.NOUN, word)) != null) {
                nouns.put(word, index);
            }
            if ((index = dictionary.lookupIndexWord(POS.VERB, word)) != null) {
                verbs.put(word, index);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    public void display(Synset syn) {
        String str = "";
        for (int s = 0; s < syn.getWordsSize(); ++s) {
            str = str + syn.getWord(s);
        }
    }

    public int getCommonConcepts(PointerTargetNodeList list1, PointerTargetNodeList list2) {
        int cc = 0;
        for (int i = 1; i <= Math.min(list1.size(), list2.size()) && ((PointerTargetNode)list1.get(list1.size() - i)).getSynset() == ((PointerTargetNode)list2.get(list2.size() - i)).getSynset(); ++i) {
            ++cc;
        }
        return cc;
    }

    private double bestMatch(double[][] matrix) {
        int minSize;
        int nbrLines = matrix.length;
        if (nbrLines == 0) {
            return 0.0;
        }
        int nbrColumns = matrix[0].length;
        double sim = 0.0;
        int n = minSize = nbrLines >= nbrColumns ? nbrColumns : nbrLines;
        if (minSize == 0) {
            return 0.0;
        }
        for (int k = 0; k < minSize; ++k) {
            int i;
            double max_val = 0.0;
            int max_i = 0;
            int max_j = 0;
            for (i = 0; i < nbrLines; ++i) {
                for (int j = 0; j < nbrColumns; ++j) {
                    if (!(max_val < matrix[i][j])) continue;
                    max_val = matrix[i][j];
                    max_val = matrix[i][j];
                    max_i = i;
                    max_j = j;
                }
            }
            for (i = 0; i < nbrLines; ++i) {
                matrix[i][max_j] = 0.0;
            }
            for (int j = 0; j < nbrColumns; ++j) {
                matrix[max_i][j] = 0.0;
            }
            sim += max_val;
        }
        return sim / (double)(nbrLines + nbrColumns - minSize);
    }

    public int getNumberOfOccurences(String token, int n) {
        switch (n) {
            case 1: {
                return this.getNumberOfOccurences(token, this.nouns1, this.adjectives1, this.verbs1);
            }
            case 2: {
                return this.getNumberOfOccurences(token, this.nouns2, this.adjectives2, this.verbs2);
            }
        }
        return 0;
    }

    public int getNumberOfOccurences(String token, Hashtable nouns, Hashtable adj, Hashtable verbs) {
        int nb = 0;
        if (nouns.containsKey(token)) {
            ++nb;
        }
        if (adj.containsKey(token)) {
            ++nb;
        }
        if (verbs.containsKey(token)) {
            ++nb;
        }
        return nb;
    }

    public void displayMatrix(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                System.out.println("[" + matrix[i][j] + "]");
            }
        }
    }

    public void fillWithOnes(double[][] matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = 1.0;
            }
        }
    }

    public double[][] getAdjectivesResults() {
        return this.adjectivesResults;
    }

    public double[][] getNounsResults() {
        return this.nounsResults;
    }

    public double[][] getVerbsResults() {
        return this.verbsResults;
    }
}

