/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.string;

import fr.inrialpes.exmo.ontosim.Measure;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;

public class CommonWords
implements Measure<String> {
    private Analyzer analyzer = new SnowballAnalyzer("English", StopAnalyzer.ENGLISH_STOP_WORDS);
    private Map<String, Set<String>> map = Collections.synchronizedMap(new HashMap());

    @Override
    public double getDissim(String o1, String o2) {
        return 1.0 - this.getMeasureValue(o1, o2);
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.similarity;
    }

    @Override
    public double getMeasureValue(String o1, String o2) {
        if (!this.map.containsKey(o1)) {
            this.extractTerms(o1);
        }
        if (!this.map.containsKey(o2)) {
            this.extractTerms(o2);
        }
        Set<String> s1 = this.map.get(o1);
        Set<String> s2 = this.map.get(o2);
        if (s1.size() == 0 || s2.size() == 0) {
            return 0.0;
        }
        int i = 0;
        for (String s : s1) {
            if (!s2.contains(s)) continue;
            ++i;
        }
        return (double)i / (double)Math.max(s1.size(), s2.size());
    }

    @Override
    public double getSim(String o1, String o2) {
        return this.getMeasureValue(o1, o2);
    }

    private void extractTerms(String e) {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        TokenStream ts = this.analyzer.tokenStream("", (Reader)new StringReader(e));
        try {
            Token token;
            while ((token = ts.next()) != null) {
                s.add(token.termText());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.map.put(e, s);
    }
}

