/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.set;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.set.SetMeasure;
import java.util.Set;

public class WeightedMaxSum<S>
extends SetMeasure<S> {
    public WeightedMaxSum(Measure<S> m) {
        super(m, null, null);
    }

    @Override
    public double getDissim(Set<? extends S> o1, Set<? extends S> o2) {
        return 1.0 - this.getMeasureValue(o1, o2);
    }

    @Override
    public double getMeasureValue(Set<? extends S> o1, Set<? extends S> o2) {
        if (o1.size() > o2.size()) {
            return this.getMeasureValue(o2, o1);
        }
        double sum = 0.0;
        double squares = 0.0;
        for (S x : o1) {
            double max = 0.0;
            for (S y : o2) {
                double v = this.localMeasure.getSim(x, y);
                if (!(v > max)) continue;
                max = v;
            }
            sum += max;
            squares += max * max;
        }
        if (sum == 0.0) {
            return 0.0;
        }
        return squares / sum;
    }

    @Override
    public double getSim(Set<? extends S> o1, Set<? extends S> o2) {
        return this.getMeasureValue(o1, o2);
    }
}

