/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.set;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.aggregation.AggregationScheme;
import fr.inrialpes.exmo.ontosim.aggregation.GenericMean;
import fr.inrialpes.exmo.ontosim.extractor.Extractor;
import fr.inrialpes.exmo.ontosim.util.measures.CachedMeasure;
import fr.inrialpes.exmo.ontosim.util.measures.DissimilarityUtility;
import fr.inrialpes.exmo.ontosim.util.measures.MeasureCache;
import fr.inrialpes.exmo.ontosim.util.measures.SimilarityUtility;
import java.util.Set;

public class SetMeasure<S>
implements Measure<Set<? extends S>> {
    protected Measure<S> localMeasure;
    protected Measure<S> lmAsSim;
    protected Measure<S> lmAsDissim;
    protected Extractor extractor;
    protected AggregationScheme as;

    public SetMeasure(Measure<S> lm, Extractor e) {
        this(lm, e, AggregationScheme.getInstance(GenericMean.class));
    }

    public SetMeasure(Measure<S> lm, Extractor e, AggregationScheme as) {
        this.localMeasure = lm instanceof CachedMeasure || lm instanceof MeasureCache ? lm : new MeasureCache<S>(lm);
        this.lmAsSim = SimilarityUtility.convert(this.localMeasure);
        this.lmAsDissim = DissimilarityUtility.convert(this.localMeasure);
        this.as = as;
        this.extractor = e;
    }

    public Measure<S> getLocalMeasure() {
        return this.localMeasure;
    }

    @Override
    public Measure.TYPES getMType() {
        return this.localMeasure.getMType();
    }

    @Override
    public double getDissim(Set<? extends S> o1, Set<? extends S> o2) {
        return this.as.getValue(this.lmAsDissim, this.extractor.extract(this.localMeasure, o1, o2));
    }

    @Override
    public double getMeasureValue(Set<? extends S> o1, Set<? extends S> o2) {
        return this.as.getValue(this.localMeasure, this.extractor.extract(this.localMeasure, o1, o2));
    }

    @Override
    public double getSim(Set<? extends S> o1, Set<? extends S> o2) {
        return this.as.getValue(this.lmAsSim, this.extractor.extract(this.localMeasure, o1, o2));
    }
}

