/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.set;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.set.SetMeasure;
import fr.inrialpes.exmo.ontosim.util.measures.MalphaMeasure;
import java.util.Set;

public class MaxCoupling<S>
extends SetMeasure<S> {
    MalphaMeasure<S> malpha;

    public MaxCoupling(Measure<S> m) {
        this(m, Double.POSITIVE_INFINITY);
    }

    public MaxCoupling(Measure<S> m, double alpha) {
        super(m, new fr.inrialpes.exmo.ontosim.extractor.MaxCoupling());
        this.malpha = new MalphaMeasure(alpha);
    }

    @Override
    public double getMeasureValue(Set<? extends S> o1, Set<? extends S> o2) {
        return super.getMeasureValue(o1, o2) * (double)Math.min(o1.size(), o2.size()) / this.malpha.getMeasureValue(o1, o2);
    }

    @Override
    public double getDissim(Set<? extends S> o1, Set<? extends S> o2) {
        return super.getDissim(o1, o2) * (double)Math.min(o1.size(), o2.size()) / this.malpha.getMeasureValue(o1, o2);
    }

    @Override
    public double getSim(Set<? extends S> o1, Set<? extends S> o2) {
        return super.getSim(o1, o2) * (double)Math.min(o1.size(), o2.size()) / this.malpha.getMeasureValue(o1, o2);
    }
}

