/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.extractor;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.extractor.AbstractExtractor;
import fr.inrialpes.exmo.ontosim.extractor.matching.BasicMatching;
import fr.inrialpes.exmo.ontosim.extractor.matching.Matching;
import fr.inrialpes.exmo.ontosim.util.HungarianAlgorithm;
import fr.inrialpes.exmo.ontosim.util.measures.SimilarityUtility;
import java.util.Set;

public class MaxCoupling
extends AbstractExtractor {
    @Override
    public <O> Matching<O> extract(Measure<O> m, Set<? extends O> src, Set<? extends O> trg) {
        Object[] s1 = null;
        Object[] s2 = null;
        boolean transpose = false;
        if (src.size() > trg.size()) {
            transpose = true;
            s2 = new Object[src.size()];
            s1 = new Object[trg.size()];
            src.toArray(s2);
            trg.toArray(s1);
        } else {
            s1 = new Object[src.size()];
            s2 = new Object[trg.size()];
            src.toArray(s1);
            trg.toArray(s2);
        }
        double[][] values = SimilarityUtility.getVals(m, s1, s2);
        int[][] assignment = HungarianAlgorithm.hgAlgorithm(values, "max");
        BasicMatching ma = new BasicMatching();
        Matching<Object> ma2add = ma;
        if (transpose) {
            ma2add = ma.transposeView();
        }
        for (int i = 0; i < assignment.length; ++i) {
            ma2add.add(s1[assignment[i][0]], s2[assignment[i][1]]);
        }
        return ma;
    }
}

