/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.extractor;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.extractor.AbstractExtractor;
import fr.inrialpes.exmo.ontosim.extractor.matching.BasicMatching;
import fr.inrialpes.exmo.ontosim.extractor.matching.Matching;
import fr.inrialpes.exmo.ontosim.util.measures.DissimilarityUtility;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Hausdorff
extends AbstractExtractor {
    @Override
    public final <O> Matching<O> extract(Measure<O> m, Set<? extends O> src, Set<? extends O> trg) {
        Measure<O> m2 = m;
        if (m2.getMType() == Measure.TYPES.similarity) {
            m2 = DissimilarityUtility.convert(m);
        }
        HashMap mins1 = new HashMap();
        HashMap mins2 = new HashMap();
        HashMap<O, Double> vals = new HashMap<O, Double>();
        double max = 0.0;
        for (O t : trg) {
            mins2.put(t, new HashSet());
            vals.put(t, Double.POSITIVE_INFINITY);
        }
        for (O s : src) {
            double vs = Double.POSITIVE_INFINITY;
            HashSet<O> minS = new HashSet<O>();
            for (O t : trg) {
                double vt;
                double v = m2.getMeasureValue(s, t);
                if (vs > v) {
                    minS.clear();
                    minS.add(t);
                    vs = v;
                } else if (vs == v) {
                    minS.add(t);
                }
                if (!((vt = ((Double)vals.get(t)).doubleValue()) >= v)) continue;
                Set minT = (Set)mins2.get(t);
                if (vt > v) {
                    minT.clear();
                    vals.put(t, v);
                }
                minT.add(s);
            }
            if (!(max <= vs)) continue;
            max = vs;
            if (max < vs) {
                mins1.clear();
            }
            mins1.put(s, minS);
            vals.put(s, vs);
        }
        boolean removeall = false;
        for (O t : trg) {
            double v = (Double)vals.get(t);
            if (max > v) {
                mins2.remove(t);
                continue;
            }
            if (!(v > max)) continue;
            max = v;
            removeall = true;
        }
        BasicMatching<Object> matching = new BasicMatching<Object>();
        if (!removeall) {
            for (Object e : mins1.keySet()) {
                if ((Double)vals.get(e) != max) continue;
                for (Object f : (Set)mins1.get(e)) {
                    matching.add(e, f);
                }
            }
        }
        for (Object e : mins2.keySet()) {
            if ((Double)vals.get(e) != max) continue;
            for (Object f : (Set)mins2.get(e)) {
                matching.add(f, e);
            }
        }
        return matching;
    }
}

