/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.entity.triplebased;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import fr.inrialpes.exmo.ontosim.Measure;

public class TripleSimS
implements Measure<Triple> {
    private Measure<Node> intialSim;

    public TripleSimS(Measure<Node> intialSim) {
        this.intialSim = intialSim;
    }

    @Override
    public double getDissim(Triple o1, Triple o2) {
        return 1.0 - this.getMeasureValue(o1, o2);
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.similarity;
    }

    @Override
    public double getMeasureValue(Triple o1, Triple o2) {
        double simP = 0.0;
        if (o1.getPredicate().equals((Object)o2.getPredicate())) {
            simP = 1.0;
        } else {
            double iSim = this.intialSim.getSim(o1.getPredicate(), o2.getPredicate());
            if (!Double.isNaN(iSim)) {
                simP = iSim;
            }
        }
        if (simP == 0.0) {
            return 0.0;
        }
        double simS = 0.0;
        if (o1.getSubject().equals((Object)o2.getSubject())) {
            simS = 1.0;
        } else {
            double iSim = this.intialSim.getSim(o1.getSubject(), o2.getSubject());
            if (!Double.isNaN(iSim)) {
                simS = iSim;
            }
        }
        double simO = 0.0;
        if (o1.getObject().equals((Object)o2.getObject())) {
            simO = 1.0;
        } else {
            double iSim = this.intialSim.getSim(o1.getObject(), o2.getObject());
            if (!Double.isNaN(iSim)) {
                simO = iSim;
            }
        }
        return (simS + simP + simO) / 3.0;
    }

    @Override
    public double getSim(Triple o1, Triple o2) {
        return this.getMeasureValue(o1, o2);
    }
}

