/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.entity.triplebased;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.entity.triplebased.TripleSimS;
import fr.inrialpes.exmo.ontosim.set.SetMeasure;
import fr.inrialpes.exmo.ontosim.set.WeightedMaxSum;
import fr.inrialpes.exmo.ontosim.util.URI2Triples;
import fr.inrialpes.exmo.ontosim.util.matrix.Matrix;
import fr.inrialpes.exmo.ontosim.util.matrix.MatrixDouble;
import fr.inrialpes.exmo.ontosim.util.measures.CachedMeasure;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class IterativeNodeSim
extends CachedMeasure<Node> {
    private Model m1;
    private Model m2;
    public URI2Triples o1Triples = new URI2Triples();
    public URI2Triples o2Triples = new URI2Triples();
    public URI2Triples o1BTriples = new URI2Triples();
    public URI2Triples o2BTriples = new URI2Triples();
    public Set<Node> extNodes1 = new HashSet<Node>();
    public Set<Node> extNodes2 = new HashSet<Node>();
    public Set<Node> litNodes1 = new HashSet<Node>();
    public Set<Node> litNodes2 = new HashSet<Node>();
    private double diff;
    private Measure<Node> intialSim;

    public IterativeNodeSim(final Model m1, final String prefix1, final Set<String> uris1, final Model m2, final String prefix2, final Set<String> uris2, Measure<String> ssim, double epsilon) {
        super(Measure.TYPES.similarity);
        this.m1 = m1;
        this.m2 = m2;
        Thread t1 = new Thread(){

            @Override
            public void run() {
                IterativeNodeSim.loadTriples(m1, prefix1, uris1, IterativeNodeSim.this.o1Triples, IterativeNodeSim.this.o1BTriples, IterativeNodeSim.this.extNodes1, IterativeNodeSim.this.litNodes1);
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                IterativeNodeSim.loadTriples(m2, prefix2, uris2, IterativeNodeSim.this.o2Triples, IterativeNodeSim.this.o2BTriples, IterativeNodeSim.this.extNodes2, IterativeNodeSim.this.litNodes2);
            }
        };
        t1.start();
        t2.start();
        try {
            t1.join();
            t2.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.compute(ssim, epsilon);
    }

    public IterativeNodeSim(Model m1, Set<String> uris1, Model m2, Set<String> uris2, Measure<String> ssim, double epsilon) {
        this(m1, null, uris1, m2, null, uris2, ssim, epsilon);
    }

    public IterativeNodeSim(Model m1, String prefix1, Model m2, String prefix2, Measure<String> ssim, double epsilon) {
        this(m1, prefix1, null, m2, prefix2, null, ssim, epsilon);
    }

    private void compute(Measure<String> ssim, double epsilon) {
        this.mValues = new MatrixDouble();
        this.computeInitialSim(ssim, this.mValues);
        this.intialSim = new CachedMeasure<Node>(this.mValues, ssim.getMType());
        System.out.println("initial sim computed");
        TripleSimS tsS = new TripleSimS(this.intialSim);
        WeightedMaxSum<Triple> setM = new WeightedMaxSum<Triple>(tsS);
        this.diff = Double.POSITIVE_INFINITY;
        int nbIt = 0;
        while (this.diff > epsilon) {
            System.out.println("Iteration " + ++nbIt + " - " + this.diff);
            this.diff = 0.0;
            MatrixDouble<Node, Node> newSims = this.updateSim(this.o1BTriples, this.o2BTriples, setM);
            this.mValues.putAll(newSims);
            newSims = this.updateSim(this.o1Triples, this.o2Triples, setM);
            this.mValues.putAll(newSims);
        }
    }

    protected MatrixDouble<Node, Node> updateSim(URI2Triples set1, URI2Triples set2, SetMeasure<Triple> setM) {
        MatrixDouble<Node, Node> newSims = new MatrixDouble<Node, Node>();
        for (Node n1 : set1.uri2triples.keySet()) {
            for (Node n2 : set2.uri2triples.keySet()) {
                double sim = 0.0;
                int n = 0;
                for (int i = 0; i < 3; ++i) {
                    if (set1.uri2triples.get(n1)[i].size() <= 0 || set2.uri2triples.get(n2)[i].size() <= 0) continue;
                    int size = Math.min(set1.uri2triples.get(n1)[i].size(), set2.uri2triples.get(n2)[i].size());
                    sim += setM.getSim(set1.uri2triples.get(n1)[i], set2.uri2triples.get(n2)[i]) * (double)size;
                    n += size;
                }
                if (n <= 0) continue;
                double oldSim = this.mValues.get(n1, n2);
                this.diff = !Double.isNaN(oldSim) ? (this.diff += Math.abs(oldSim - sim)) : (this.diff += (sim /= (double)n));
                if (sim == oldSim) continue;
                newSims.put(n1, n2, sim);
            }
        }
        return newSims;
    }

    public void computeInitialSim(final Measure<String> ssim, final Matrix<Node, Node> simMD) {
        Thread t1 = new Thread(){

            @Override
            public void run() {
                for (Node n1 : IterativeNodeSim.this.litNodes1) {
                    for (Node n2 : IterativeNodeSim.this.litNodes2) {
                        double s = ssim.getSim(n1.getLiteralLexicalForm(), n2.getLiteralLexicalForm());
                        if (!(s > 0.0)) continue;
                        simMD.put(n1, n2, s);
                    }
                }
                IterativeNodeSim.this.litNodes1 = null;
                IterativeNodeSim.this.litNodes2 = null;
                System.out.println("finish with lit nodes");
            }
        };
        Thread t2 = new Thread(){

            @Override
            public void run() {
                for (Node n1 : IterativeNodeSim.this.extNodes1) {
                    for (Node n2 : IterativeNodeSim.this.extNodes2) {
                        if (!n1.getURI().equals(n2.getURI())) continue;
                        simMD.put(n1, n2, 1.0);
                    }
                }
                IterativeNodeSim.this.extNodes1 = null;
                IterativeNodeSim.this.extNodes2 = null;
                System.out.println("finish with ext nodes");
            }
        };
        Thread t3 = new Thread(){

            @Override
            public void run() {
                for (Node n1 : IterativeNodeSim.this.o1Triples.uri2triples.keySet()) {
                    for (Node n2 : IterativeNodeSim.this.o2Triples.uri2triples.keySet()) {
                        double s = ssim.getSim(n1.getLocalName(), n2.getLocalName());
                        if (!(s > 0.0)) continue;
                        simMD.put(n1, n2, s);
                    }
                }
                System.out.println("finish with local nodes");
            }
        };
        t1.start();
        t2.start();
        t3.start();
        try {
            t1.join();
            t2.join();
            t3.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static boolean isLocal(Node n, String prefix, Set<String> uris) {
        return n.isURI() && (prefix != null && n.getURI().startsWith(prefix) || uris != null && uris.contains(n.getURI()));
    }

    public static void loadTriples(Model m, String prefix, Set<String> objects, URI2Triples uri2triples, URI2Triples blanck2triples, Set<Node> extNodes, Set<Node> litNodes) {
        StmtIterator i = m.listStatements();
        int nb = 0;
        while (i.hasNext()) {
            Statement stmt1 = (Statement)i.next();
            Triple current = stmt1.asTriple();
            if (current.getSubject().isBlank()) {
                blanck2triples.addTripleSubject(current.getSubject(), current);
            } else if (IterativeNodeSim.isLocal(current.getSubject(), prefix, objects)) {
                uri2triples.addTripleSubject(current.getSubject(), current);
            } else {
                extNodes.add(current.getSubject());
            }
            if (current.getPredicate().isBlank()) {
                blanck2triples.addTriplePredicate(current.getPredicate(), current);
            } else if (IterativeNodeSim.isLocal(current.getPredicate(), prefix, objects)) {
                uri2triples.addTriplePredicate(current.getPredicate(), current);
            } else {
                extNodes.add(current.getPredicate());
            }
            if (current.getObject().isBlank()) {
                blanck2triples.addTripleObject(current.getObject(), current);
            } else if (IterativeNodeSim.isLocal(current.getObject(), prefix, objects)) {
                uri2triples.addTripleObject(current.getObject(), current);
            } else if (current.getObject().isLiteral()) {
                litNodes.add(current.getObject());
            } else {
                extNodes.add(current.getObject());
            }
            ++nb;
        }
    }

    public Collection<Model> getModels() {
        Vector<Model> models = new Vector<Model>(2);
        Collections.addAll(models, this.m1, this.m2);
        return models;
    }

    public Matrix<Node, Node> getmatrix() {
        return this.mValues;
    }
}

