/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.entity.model;

import fr.inrialpes.exmo.ontosim.entity.model.HLClassImpl;
import fr.inrialpes.exmo.ontosim.entity.model.HLEntity;
import fr.inrialpes.exmo.ontosim.entity.model.HLEntityImpl;
import fr.inrialpes.exmo.ontosim.entity.model.HLIndividualImpl;
import fr.inrialpes.exmo.ontosim.entity.model.HLPropertyImpl;
import fr.inrialpes.exmo.ontowrap.HeavyLoadedOntology;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class HLEntityFactory<E> {
    public static final Map<HeavyLoadedOntology<?>, HLEntityFactory<?>> FACTORIES = new HashMap();
    private final Map<E, Reference<HLEntity<E>>> cache = new WeakHashMap<E, Reference<HLEntity<E>>>();
    private HeavyLoadedOntology<E> onto;

    private HLEntityFactory(HeavyLoadedOntology<E> onto) {
        this.onto = onto;
    }

    public static <T> HLEntityFactory<T> getInstance(HeavyLoadedOntology<T> ont) {
        HLEntityFactory<Object> fact = FACTORIES.get(ont);
        if (fact == null) {
            fact = new HLEntityFactory<T>(ont);
            FACTORIES.put(ont, fact);
        }
        return fact;
    }

    public final HLEntity<E> createHLEntity(E obj) {
        HLEntityImpl e = null;
        if (this.onto.isClass(obj)) {
            e = new HLClassImpl<E>(this.onto, obj);
        } else if (this.onto.isProperty(obj)) {
            e = new HLPropertyImpl<E>(this.onto, obj);
        } else if (this.onto.isIndividual(obj)) {
            e = new HLIndividualImpl<E>(this.onto, obj);
        }
        if (e != null) {
            this.cache.put(obj, new SoftReference<HLClassImpl<E>>(e));
        }
        return e;
    }

    protected Set<? extends HLEntity<E>> getFrom(Set<E> entities) {
        HashSet<HLEntity<E>> s = new HashSet<HLEntity<E>>();
        for (E e : entities) {
            Reference<HLEntity<E>> hle = this.cache.get(e);
            if (hle == null || hle.get() == null) {
                s.add(this.createHLEntity(e));
                continue;
            }
            s.add(hle.get());
        }
        return s;
    }
}

