/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.entity.model;

import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.entity.model.Entity;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.net.URI;
import java.util.Set;

public class EntityImpl<E>
implements Entity<E> {
    private LoadedOntology<E> onto;
    private E obj;

    public EntityImpl(LoadedOntology<E> ont, E e) {
        this.onto = ont;
        this.obj = e;
    }

    @Override
    public Set<String> getAnnotations(String lang) {
        try {
            return this.onto.getEntityAnnotations(this.obj);
        }
        catch (OntowrapException e) {
            throw new OntoSimException(e);
        }
    }

    @Override
    public Set<String> getComments(String lang) {
        try {
            return this.onto.getEntityComments(this.obj, lang);
        }
        catch (OntowrapException e) {
            throw new OntoSimException(e);
        }
    }

    @Override
    public Set<String> getLabels(String lang) {
        try {
            return this.onto.getEntityNames(this.obj, lang);
        }
        catch (OntowrapException e) {
            throw new OntoSimException(e);
        }
    }

    @Override
    public E getObject() {
        return this.obj;
    }

    @Override
    public LoadedOntology<E> getOntology() {
        return this.onto;
    }

    @Override
    public URI getURI() {
        try {
            return this.onto.getEntityURI(this.obj);
        }
        catch (OntowrapException e) {
            throw new OntoSimException(e);
        }
    }

    @Override
    public boolean isClass() {
        return this.onto.isClass(this.obj);
    }

    @Override
    public boolean isDataProperty() {
        return this.onto.isDataProperty(this.obj);
    }

    @Override
    public boolean isIndividual() {
        return this.onto.isIndividual(this.obj);
    }

    @Override
    public boolean isObjectProperty() {
        return this.onto.isObjectProperty(this.obj);
    }

    @Override
    public boolean isProperty() {
        return this.onto.isProperty(this.obj);
    }
}

