/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.entity;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Model;
import com.wcohen.ss.AbstractStringDistance;
import com.wcohen.ss.Jaccard;
import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.entity.model.Entity;
import fr.inrialpes.exmo.ontosim.entity.triplebased.IterativeNodeSim;
import fr.inrialpes.exmo.ontosim.string.StringMeasureSS;
import fr.inrialpes.exmo.ontowrap.LoadedOntology;
import fr.inrialpes.exmo.ontowrap.OntowrapException;
import java.util.Collection;
import java.util.HashSet;

public class TripleBasedEntitySim
implements Measure<Entity<OntResource>> {
    IterativeNodeSim currentSim;
    Collection<Model> currentModels;
    Measure<String> ssim = new StringMeasureSS((AbstractStringDistance)new Jaccard());

    public TripleBasedEntitySim() {
    }

    public TripleBasedEntitySim(Measure<String> ssim) {
        this.ssim = ssim;
    }

    @Override
    public double getDissim(Entity<OntResource> e1, Entity<OntResource> e2) {
        return 1.0 - this.getMeasureValue(e1, e2);
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.similarity;
    }

    @Override
    public double getMeasureValue(Entity<OntResource> e1, Entity<OntResource> e2) {
        double val;
        OntModel e1Model = e1.getObject().getOntModel();
        OntModel e2Model = e2.getObject().getOntModel();
        if (this.currentModels == null || !this.currentModels.contains(e1Model) || !this.currentModels.contains(e2Model)) {
            LoadedOntology<OntResource> o1 = e1.getOntology();
            LoadedOntology<OntResource> o2 = e2.getOntology();
            HashSet<String> o1URIS = new HashSet<String>();
            HashSet<String> o2URIS = new HashSet<String>();
            for (Object o : o1.getEntities()) {
                try {
                    o1URIS.add(o1.getEntityURI(o).toString());
                }
                catch (OntowrapException e) {
                    e.printStackTrace();
                }
            }
            for (Object o : o2.getEntities()) {
                try {
                    o2URIS.add(o2.getEntityURI(o).toString());
                }
                catch (OntowrapException e) {
                    e.printStackTrace();
                }
            }
            this.currentSim = new IterativeNodeSim((Model)e1Model, o1URIS, (Model)e2Model, o2URIS, this.ssim, 1.0);
            this.currentModels = this.currentSim.getModels();
        }
        return Double.isNaN(val = this.currentSim.getMeasureValue(e1.getObject().asNode(), e2.getObject().asNode())) ? 0.0 : val;
    }

    @Override
    public double getSim(Entity<OntResource> e1, Entity<OntResource> e2) {
        return this.getMeasureValue(e1, e2);
    }
}

