/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.entity;

import ca.uqam.info.latece.sboa.impl.algorithms.OLAlignment;
import ca.uqam.info.latece.sboa.inter.ograph.OntologyGraph;
import ca.uqam.info.latece.sboa.inter.ograph.Vertice;
import ca.uqam.info.latece.sboa.inter.ograph.VerticesPool;
import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.entity.model.Entity;
import fr.inrialpes.exmo.ontosim.util.AlignPairsSimple;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import no.uib.cipr.matrix.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;

public class OLAEntitySim
extends OLAlignment
implements Measure<Entity<OWLEntity>> {
    private Map<OWLOntology, Set<OWLOntology>> alignedOnto;
    private AlignPairsSimple aps = new AlignPairsSimple();

    public OLAEntitySim() {
        this.alignedOnto = new HashMap<OWLOntology, Set<OWLOntology>>();
    }

    public Alignment extractResults(OntologyGraph mGraph, Vector simVect, int[] indVect, int sz) {
        VerticesPool vPool = (VerticesPool)mGraph.getVerticePool();
        for (int i = 0; i < sz; ++i) {
            boolean noInst;
            Vertice ver = (Vertice)vPool.get(indVect[i]);
            OWLEntity ent1 = ver.getFirstEntity();
            OWLEntity ent2 = ver.getSecondEntity();
            double val = simVect.get(i);
            boolean bl = noInst = ver.getCategory().equalsIgnoreCase("PropertyInstance") || ver.getCategory().equalsIgnoreCase("DataType") || ver.getCategory().equalsIgnoreCase("DataValue") || ver.getCategory().equalsIgnoreCase("Token") || ver.getCategory().equalsIgnoreCase("Cardinality");
            if (noInst) continue;
            this.aps.addPair(ent1, ent2, val);
        }
        return this;
    }

    private void computeSims(OWLOntology o1, OWLOntology o2) {
        try {
            if (this.alignedOnto.containsKey(o2)) {
                this.onto1.setOntology(o2);
                this.onto2.setOntology(o1);
            } else {
                this.onto1.setOntology(o1);
                this.onto2.setOntology(o2);
            }
            BasicParameters bp = new BasicParameters();
            this.align(null, (Properties)bp);
            Set<OWLOntology> ontsMapped = this.alignedOnto.get(this.onto1.getOntology());
            if (ontsMapped == null) {
                ontsMapped = new HashSet<OWLOntology>();
                this.alignedOnto.put((OWLOntology)this.onto1.getOntology(), ontsMapped);
            }
            ontsMapped.add((OWLOntology)this.onto2.getOntology());
        }
        catch (AlignmentException e) {
            e.printStackTrace();
        }
    }

    public void resetSim() {
        this.aps = new AlignPairsSimple();
        this.alignedOnto.clear();
    }

    @Override
    public double getMeasureValue(Entity<OWLEntity> e1, Entity<OWLEntity> e2) {
        OWLOntology o1 = (OWLOntology)e1.getOntology().getOntology();
        OWLOntology o2 = (OWLOntology)e2.getOntology().getOntology();
        if (!(this.alignedOnto.containsKey(o1) && this.alignedOnto.get(o1).contains(o2) || this.alignedOnto.containsKey(o2) && this.alignedOnto.get(o2).contains(o1))) {
            this.computeSims(o1, o2);
        }
        double val = this.aps.getSimPair(e1.getObject(), e2.getObject());
        return val;
    }

    @Override
    public double getDissim(Entity<OWLEntity> e1, Entity<OWLEntity> e2) {
        return 1.0 - this.getMeasureValue(e1, e2);
    }

    @Override
    public double getSim(Entity<OWLEntity> e1, Entity<OWLEntity> e2) {
        return this.getMeasureValue(e1, e2);
    }

    @Override
    public Measure.TYPES getMType() {
        return Measure.TYPES.similarity;
    }
}

