/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.ontosim.entity;

import fr.inrialpes.exmo.ontosim.Measure;
import fr.inrialpes.exmo.ontosim.OntoSimException;
import fr.inrialpes.exmo.ontosim.entity.EntityLexicalMeasure;
import fr.inrialpes.exmo.ontosim.entity.model.HLClass;
import fr.inrialpes.exmo.ontosim.entity.model.HLEntity;
import fr.inrialpes.exmo.ontosim.entity.model.HLIndividual;
import fr.inrialpes.exmo.ontosim.entity.model.HLProperty;
import fr.inrialpes.exmo.ontosim.set.MaxCoupling;
import fr.inrialpes.exmo.ontosim.set.SetMeasure;
import fr.inrialpes.exmo.ontowrap.OntologyFactory;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class NeighborhoodEntityMeasure<E>
implements Measure<HLEntity<E>> {
    private SetMeasure<HLEntity<E>> initialM;

    public NeighborhoodEntityMeasure() {
        this.initialM = new MaxCoupling(new EntityLexicalMeasure());
    }

    public NeighborhoodEntityMeasure(SetMeasure<HLEntity<E>> intialM) {
        this.initialM = intialM;
    }

    protected void getVal(Set<? extends HLEntity<E>> s1, Set<? extends HLEntity<E>> s2, List<Double> values) {
        if (s1.size() > 0 && s2.size() > 0) {
            try {
                values.add(this.initialM.getMeasureValue(s1, s2));
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }

    protected List<Double> getVals(HLClass<E> e1, HLClass<E> e2) {
        Vector<Double> vals = new Vector<Double>(3);
        this.getVal(e1.getSubClasses(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), e2.getSubClasses(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), vals);
        this.getVal(e1.getSuperClasses(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), e2.getSuperClasses(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), vals);
        this.getVal(e1.getProperties(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), e2.getProperties(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), vals);
        return vals;
    }

    protected List<Double> getVals(HLProperty<E> e1, HLProperty<E> e2) {
        Vector<Double> vals = new Vector<Double>(4);
        this.getVal(e1.getSubProperties(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), e2.getSubProperties(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), vals);
        this.getVal(e1.getSuperProperties(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), e2.getSuperProperties(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), vals);
        this.getVal(e1.getDomain(OntologyFactory.ASSERTED), e2.getDomain(OntologyFactory.ASSERTED), vals);
        return vals;
    }

    protected List<Double> getVals(HLIndividual<E> e1, HLIndividual<E> e2) {
        Vector<Double> vals = new Vector<Double>(1);
        this.getVal(e1.getClasses(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), e2.getClasses(OntologyFactory.LOCAL, OntologyFactory.DIRECT, OntologyFactory.NAMED), vals);
        return vals;
    }

    @Override
    public Measure.TYPES getMType() {
        return this.initialM.getMType();
    }

    @Override
    public double getMeasureValue(HLEntity<E> o1, HLEntity<E> o2) {
        List<Double> sims = null;
        if (o1 instanceof HLClass && o2 instanceof HLClass) {
            sims = this.getVals((HLClass)o1, (HLClass)o2);
        } else if (o1 instanceof HLProperty && o2 instanceof HLProperty) {
            sims = this.getVals((HLProperty)o1, (HLProperty)o2);
        } else if (o1 instanceof HLIndividual && o2 instanceof HLIndividual) {
            sims = this.getVals((HLIndividual)o1, (HLIndividual)o2);
        } else {
            return 0.0;
        }
        double isim = this.initialM.getLocalMeasure().getMeasureValue(o1, o2);
        for (double v : sims) {
            isim += v;
        }
        return isim / (double)(sims.size() + 1);
    }

    @Override
    public double getSim(HLEntity<E> o1, HLEntity<E> o2) {
        if (this.initialM.getMType() == Measure.TYPES.similarity) {
            return this.getMeasureValue(o1, o2);
        }
        if (this.initialM.getMType() == Measure.TYPES.dissimilarity) {
            return 1.0 - this.getMeasureValue(o1, o2);
        }
        throw new OntoSimException("Not a similarity");
    }

    @Override
    public double getDissim(HLEntity<E> o1, HLEntity<E> o2) {
        if (this.initialM.getMType() == Measure.TYPES.dissimilarity) {
            return this.getMeasureValue(o1, o2);
        }
        if (this.initialM.getMType() == Measure.TYPES.similarity) {
            return 1.0 - this.getMeasureValue(o1, o2);
        }
        throw new OntoSimException("Not a dissimilarity");
    }
}

